/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Logger;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.utils.progress.ConsoleProgressMonitor;
import org.mindswap.pellet.utils.progress.ProgressMonitor;
import org.mindswap.pellet.utils.progress.SilentProgressMonitor;
import org.mindswap.pellet.utils.progress.SwingProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PelletOptions {
    public static final Logger log = Logger.getLogger(PelletOptions.class.getName());
    public static boolean SATURATE_TABLEAU = false;
    public static boolean USE_UNIQUE_NAME_ASSUMPTION = false;
    public static boolean TRACK_BRANCH_EFFECTS = false;
    public static boolean TREAT_ALL_VARS_DISTINGUISHED = true;
    public static boolean USE_DISJUNCT_SORTING = !SATURATE_TABLEAU;
    public static MonitorType USE_CLASSIFICATION_MONITOR = MonitorType.CONSOLE;
    public static final String NO_SORTING = "NO";
    public static final String OLDEST_FIRST = "OLDEST_FIRST";
    public static String USE_DISJUNCTION_SORTING = "OLDEST_FIRST";
    public static boolean USE_ABSORPTION = true;
    public static UndefinedDatatypeHandling UNDEFINED_DATATYPE_HANDLING = UndefinedDatatypeHandling.INFINITE_STRING;
    public static boolean USE_ROLE_ABSORPTION = true;
    public static boolean USE_NOMINAL_ABSORPTION = true;
    public static boolean USE_HASVALUE_ABSORPTION = true;
    public static boolean USE_BACKJUMPING = !SATURATE_TABLEAU & true;
    public static boolean USE_FULL_DATATYPE_REASONING = true;
    public static boolean AUTO_XML_SCHEMA_LOADING = false;
    public static boolean USE_CACHING = true;
    public static boolean USE_ADVANCED_CACHING = true;
    public static int MAX_ANONYMOUS_CACHE = 20000;
    public static boolean CHECK_NOMINAL_EDGES = true;
    public static boolean USE_PSEUDO_NOMINALS = false;
    public static boolean IGNORE_INVERSES = false;
    public static boolean USE_COMPLETION_STRATEGY = !SATURATE_TABLEAU & true;
    public static boolean USE_CONTINUOUS_RULES = true;
    public static boolean ALWAYS_REBUILD_RETE = false;
    public static boolean USE_SEMANTIC_BRANCHING = !SATURATE_TABLEAU & true;
    public static Class<? extends CompletionStrategy> DEFAULT_COMPLETION_STRATEGY = null;
    public static boolean COPY_ON_WRITE = true;
    public static boolean SILENT_UNDEFINED_ENTITY_HANDLING = true;
    public static boolean REALIZE_INDIVIDUAL_AT_A_TIME = false;
    public static boolean VALIDATE_ABOX = false;
    public static boolean PRINT_ABOX = false;
    public static final boolean DEPTH_FIRST = true;
    public static final boolean BREADTH_FIRST = false;
    public static boolean KEEP_ABOX_ASSERTIONS = false;
    public static boolean SEARCH_TYPE = true;
    public static InstanceRetrievalMethod INSTANCE_RETRIEVAL = InstanceRetrievalMethod.BINARY;
    public static boolean INVALID_LITERAL_AS_INCONSISTENCY = true;
    public static boolean OPTIMIZE_DOWN_MONOTONIC = false;
    public static boolean SIMPLIFY_QUERY = true;
    public static double SAMPLING_RATIO = 0.2;
    public static int STATIC_REORDERING_LIMIT = 8;
    public static boolean FULL_SIZE_ESTIMATE = false;
    public static boolean CACHE_RETRIEVAL = false;
    public static boolean USE_TRACING = false;
    public static String DEFAULT_CONFIGURATION_FILE = "pellet.properties";
    public static boolean FREEZE_BUILTIN_NAMESPACES = true;
    public static boolean IGNORE_DEPRECATED_TERMS = true;
    public static boolean IGNORE_UNSUPPORTED_AXIOMS = true;
    public static boolean DL_SAFE_RULES = true;
    public static boolean RETURN_DEDUCTIONS_GRAPH = false;
    public static boolean USE_COMPLETION_QUEUE = false;
    public static boolean USE_OPTIMIZED_BASIC_COMPLETION_QUEUE = false;
    public static boolean USE_SMART_RESTORE = true;
    public static boolean USE_INCREMENTAL_CONSISTENCY = false;
    public static boolean USE_INCREMENTAL_DELETION = false;
    public static boolean MAINTAIN_COMPLETION_QUEUE = false;
    public static boolean USE_CD_CLASSIFICATION = true;
    public static boolean USE_NAIVE_QUERY_ENGINE = false;
    public static boolean USE_ANNOTATION_SUPPORT = false;
    public static boolean HIDE_TOP_PROPERTY_VALUES = true;

    public static Properties setOptions(Properties newOptions) {
        Properties oldOptions = new Properties();
        ALWAYS_REBUILD_RETE = PelletOptions.getBooleanProperty(newOptions, "ALWAYS_REBUILD_RETE", ALWAYS_REBUILD_RETE, oldOptions);
        CACHE_RETRIEVAL = PelletOptions.getBooleanProperty(newOptions, "CACHE_RETRIEVAL", CACHE_RETRIEVAL, oldOptions);
        DL_SAFE_RULES = PelletOptions.getBooleanProperty(newOptions, "DL_SAFE_RULES", DL_SAFE_RULES, oldOptions);
        FREEZE_BUILTIN_NAMESPACES = PelletOptions.getBooleanProperty(newOptions, "FREEZE_BUILTIN_NAMESPACES", FREEZE_BUILTIN_NAMESPACES, oldOptions);
        FULL_SIZE_ESTIMATE = PelletOptions.getBooleanProperty(newOptions, "FULL_SIZE_ESTIMATE", FULL_SIZE_ESTIMATE, oldOptions);
        IGNORE_DEPRECATED_TERMS = PelletOptions.getBooleanProperty(newOptions, "IGNORE_DEPRECATED_TERMS", IGNORE_DEPRECATED_TERMS, oldOptions);
        IGNORE_INVERSES = PelletOptions.getBooleanProperty(newOptions, "IGNORE_INVERSES", IGNORE_INVERSES, oldOptions);
        IGNORE_UNSUPPORTED_AXIOMS = PelletOptions.getBooleanProperty(newOptions, "IGNORE_UNSUPPORTED_AXIOMS", IGNORE_UNSUPPORTED_AXIOMS, oldOptions);
        MAINTAIN_COMPLETION_QUEUE = PelletOptions.getBooleanProperty(newOptions, "MAINTAIN_COMPLETION_QUEUE", MAINTAIN_COMPLETION_QUEUE, oldOptions);
        MAX_ANONYMOUS_CACHE = PelletOptions.getIntProperty(newOptions, "MAX_ANONYMOUS_CACHE", MAX_ANONYMOUS_CACHE, oldOptions);
        OPTIMIZE_DOWN_MONOTONIC = PelletOptions.getBooleanProperty(newOptions, "OPTIMIZE_DOWN_MONOTONIC", OPTIMIZE_DOWN_MONOTONIC, oldOptions);
        REALIZE_INDIVIDUAL_AT_A_TIME = PelletOptions.getBooleanProperty(newOptions, "REALIZE_INDIVIDUAL_AT_A_TIME", REALIZE_INDIVIDUAL_AT_A_TIME, oldOptions);
        RETURN_DEDUCTIONS_GRAPH = PelletOptions.getBooleanProperty(newOptions, "RETURN_DEDUCTIONS_GRAPH", RETURN_DEDUCTIONS_GRAPH, oldOptions);
        SAMPLING_RATIO = PelletOptions.getDoubleProperty(newOptions, "SAMPLING_RATIO", SAMPLING_RATIO, oldOptions);
        SILENT_UNDEFINED_ENTITY_HANDLING = PelletOptions.getBooleanProperty(newOptions, "SILENT_UNDEFINED_ENTITY_HANDLING", SILENT_UNDEFINED_ENTITY_HANDLING, oldOptions);
        SIMPLIFY_QUERY = PelletOptions.getBooleanProperty(newOptions, "SIMPLIFY_QUERY", SIMPLIFY_QUERY, oldOptions);
        STATIC_REORDERING_LIMIT = PelletOptions.getIntProperty(newOptions, "STATIC_REORDERING_LIMIT", STATIC_REORDERING_LIMIT, oldOptions);
        TRACK_BRANCH_EFFECTS = PelletOptions.getBooleanProperty(newOptions, "TRACK_BRANCH_EFFECTS", TRACK_BRANCH_EFFECTS, oldOptions);
        TREAT_ALL_VARS_DISTINGUISHED = PelletOptions.getBooleanProperty(newOptions, "TREAT_ALL_VARS_DISTINGUISHED", TREAT_ALL_VARS_DISTINGUISHED, oldOptions);
        USE_ABSORPTION = PelletOptions.getBooleanProperty(newOptions, "USE_ABSORPTION", USE_ABSORPTION, oldOptions);
        USE_ADVANCED_CACHING = PelletOptions.getBooleanProperty(newOptions, "USE_ADVANCED_CACHING", USE_ADVANCED_CACHING, oldOptions);
        USE_ANNOTATION_SUPPORT = PelletOptions.getBooleanProperty(newOptions, "USE_ANNOTATION_SUPPORT", USE_ANNOTATION_SUPPORT, oldOptions);
        USE_BACKJUMPING = PelletOptions.getBooleanProperty(newOptions, "USE_BACKJUMPING", USE_BACKJUMPING, oldOptions);
        USE_CACHING = PelletOptions.getBooleanProperty(newOptions, "USE_CACHING", USE_CACHING, oldOptions);
        USE_CD_CLASSIFICATION = PelletOptions.getBooleanProperty(newOptions, "USE_CD_CLASSIFICATION", USE_CD_CLASSIFICATION, oldOptions);
        USE_CLASSIFICATION_MONITOR = PelletOptions.getEnumProperty(newOptions, "USE_CLASSIFICATION_MONITOR", USE_CLASSIFICATION_MONITOR, oldOptions);
        USE_COMPLETION_QUEUE = PelletOptions.getBooleanProperty(newOptions, "USE_COMPLETION_QUEUE", USE_COMPLETION_QUEUE, oldOptions);
        USE_CONTINUOUS_RULES = PelletOptions.getBooleanProperty(newOptions, "USE_CONTINUOUS_RULES", USE_CONTINUOUS_RULES, oldOptions);
        USE_FULL_DATATYPE_REASONING = PelletOptions.getBooleanProperty(newOptions, "USE_FULL_DATATYPE_REASONING", USE_FULL_DATATYPE_REASONING, oldOptions);
        USE_INCREMENTAL_CONSISTENCY = PelletOptions.getBooleanProperty(newOptions, "USE_INCREMENTAL_CONSISTENCY", USE_INCREMENTAL_CONSISTENCY, oldOptions);
        USE_INCREMENTAL_DELETION = PelletOptions.getBooleanProperty(newOptions, "USE_INCREMENTAL_DELETION", USE_INCREMENTAL_DELETION, oldOptions);
        USE_NAIVE_QUERY_ENGINE = PelletOptions.getBooleanProperty(newOptions, "USE_NAIVE_QUERY_ENGINE", USE_NAIVE_QUERY_ENGINE, oldOptions);
        USE_PSEUDO_NOMINALS = PelletOptions.getBooleanProperty(newOptions, "USE_PSEUDO_NOMINALS", USE_PSEUDO_NOMINALS, oldOptions);
        USE_ROLE_ABSORPTION = PelletOptions.getBooleanProperty(newOptions, "USE_ROLE_ABSORPTION", USE_ROLE_ABSORPTION, oldOptions);
        USE_SEMANTIC_BRANCHING = PelletOptions.getBooleanProperty(newOptions, "USE_SEMANTIC_BRANCHING", USE_SEMANTIC_BRANCHING, oldOptions);
        USE_SMART_RESTORE = PelletOptions.getBooleanProperty(newOptions, "USE_SMART_RESTORE", USE_SMART_RESTORE, oldOptions);
        USE_TRACING = PelletOptions.getBooleanProperty(newOptions, "USE_TRACING", USE_TRACING, oldOptions);
        USE_UNIQUE_NAME_ASSUMPTION = PelletOptions.getBooleanProperty(newOptions, "USE_UNIQUE_NAME_ASSUMPTION", USE_UNIQUE_NAME_ASSUMPTION, oldOptions);
        HIDE_TOP_PROPERTY_VALUES = PelletOptions.getBooleanProperty(newOptions, "HIDE_TOP_PROPERTY_VALUES", HIDE_TOP_PROPERTY_VALUES, oldOptions);
        return oldOptions;
    }

    public static void load(URL configFile) throws FileNotFoundException, IOException {
        log.fine("Reading Pellet configuration file " + configFile);
        Properties properties = new Properties();
        properties.load(configFile.openStream());
        PelletOptions.setOptions(properties);
    }

    private static boolean getBooleanProperty(Properties properties, String property, boolean defaultValue, Properties defaultValues) {
        defaultValues.setProperty(property, String.valueOf(defaultValue));
        String value = properties.getProperty(property);
        boolean returnValue = defaultValue;
        if (value != null) {
            if ((value = value.trim()).equalsIgnoreCase("true")) {
                returnValue = true;
            } else if (value.equalsIgnoreCase("false")) {
                returnValue = false;
            } else {
                log.severe("Ignoring invalid value (" + value + ") for the configuration option " + property);
            }
        }
        properties.setProperty(property, String.valueOf(returnValue));
        return returnValue;
    }

    private static double getDoubleProperty(Properties properties, String property, double defaultValue, Properties defaultValues) {
        defaultValues.setProperty(property, String.valueOf(defaultValue));
        String value = properties.getProperty(property);
        double doubleValue = defaultValue;
        if (value != null) {
            try {
                doubleValue = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                log.severe("Ignoring invalid double value (" + value + ") for the configuration option " + property);
            }
        }
        properties.setProperty(property, String.valueOf(doubleValue));
        return doubleValue;
    }

    private static int getIntProperty(Properties properties, String property, int defaultValue, Properties defaultValues) {
        defaultValues.setProperty(property, String.valueOf(defaultValue));
        String value = properties.getProperty(property);
        int intValue = defaultValue;
        if (value != null) {
            try {
                intValue = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                log.severe("Ignoring invalid int value (" + value + ") for the configuration option " + property);
            }
        }
        properties.setProperty(property, String.valueOf(intValue));
        return intValue;
    }

    private static <T extends Enum<T>> T getEnumProperty(Properties properties, String property, T defaultValue, Properties defaultValues) {
        defaultValues.setProperty(property, String.valueOf(defaultValue));
        String value = properties.getProperty(property);
        T returnValue = defaultValue;
        if (value != null) {
            value = value.trim().toUpperCase();
            try {
                returnValue = Enum.valueOf(defaultValue.getDeclaringClass(), value);
            }
            catch (IllegalArgumentException e) {
                log.severe("Ignoring invalid value (" + value + ") for the configuration option " + property);
            }
        }
        properties.setProperty(property, String.valueOf(returnValue));
        return returnValue;
    }

    static {
        String configFile = System.getProperty("pellet.configuration");
        URL url = null;
        if (configFile == null) {
            url = PelletOptions.class.getClassLoader().getResource(DEFAULT_CONFIGURATION_FILE);
        } else {
            try {
                url = new URL(configFile);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
                url = PelletOptions.class.getClassLoader().getResource(configFile);
            }
            if (url == null) {
                log.severe("Cannot file Pellet configuration file " + configFile);
            }
        }
        if (url != null) {
            try {
                PelletOptions.load(url);
            }
            catch (FileNotFoundException e) {
                log.severe("Pellet configuration file cannot be found");
            }
            catch (IOException e) {
                log.severe("I/O error while reading Pellet configuration file");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UndefinedDatatypeHandling {
        EMPTY,
        EXCEPTION,
        INFINITE_STRING;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InstanceRetrievalMethod {
        BINARY,
        LINEAR,
        TRACING_BASED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MonitorType implements EnumFactory<ProgressMonitor>
    {
        CONSOLE(ConsoleProgressMonitor.class),
        SWING(SwingProgressMonitor.class),
        NONE(SilentProgressMonitor.class);

        private final Class<? extends ProgressMonitor> c;

        private MonitorType(Class<? extends ProgressMonitor> c) {
            this.c = c;
        }

        @Override
        public ProgressMonitor create() {
            try {
                return this.c.newInstance();
            }
            catch (InstantiationException e) {
                throw new InternalReasonerException(e);
            }
            catch (IllegalAccessException e) {
                throw new InternalReasonerException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface EnumFactory<T> {
        public T create();
    }
}

