/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.RoleTaxonomyBuilder;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Pair;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.fsm.State;
import org.mindswap.pellet.utils.fsm.Transition;
import org.mindswap.pellet.utils.fsm.TransitionGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RBox {
    public static Logger log = Logger.getLogger(RBox.class.getName());
    private Map<ATermAppl, Role> roles = new HashMap<ATermAppl, Role>();
    private Set<Role> reflexiveRoles = new HashSet<Role>();
    private final List<Pair<Role, DependencySet>> domainRemovals;
    private final List<Pair<Role, DependencySet>> rangeRemovals;
    private Taxonomy<ATermAppl> objectTaxonomy;
    private Taxonomy<ATermAppl> dataTaxonomy;

    public RBox() {
        if (PelletOptions.USE_TRACING) {
            this.domainRemovals = new ArrayList<Pair<Role, DependencySet>>();
            this.rangeRemovals = new ArrayList<Pair<Role, DependencySet>>();
        } else {
            this.domainRemovals = Collections.emptyList();
            this.rangeRemovals = Collections.emptyList();
        }
        this.addDatatypeRole(ATermUtils.TOP_DATA_PROPERTY);
        this.addDatatypeRole(ATermUtils.BOTTOM_DATA_PROPERTY);
        Role topObjProp = this.addObjectRole(ATermUtils.TOP_OBJECT_PROPERTY);
        Role bottomObjProp = this.addObjectRole(ATermUtils.BOTTOM_OBJECT_PROPERTY);
        topObjProp.setTransitive(true, DependencySet.INDEPENDENT);
        topObjProp.setReflexive(true, DependencySet.INDEPENDENT);
        bottomObjProp.setIrreflexive(true, DependencySet.INDEPENDENT);
        bottomObjProp.setAsymmetric(true, DependencySet.INDEPENDENT);
        this.addEquivalentRole((ATerm)topObjProp.getName(), (ATerm)topObjProp.getInverse().getName(), DependencySet.INDEPENDENT);
        this.addEquivalentRole((ATerm)bottomObjProp.getName(), (ATerm)bottomObjProp.getInverse().getName(), DependencySet.INDEPENDENT);
    }

    public Role getRole(ATerm r) {
        return this.roles.get(r);
    }

    public Role getDefinedRole(ATerm r) {
        Role role = this.roles.get(r);
        if (role == null) {
            throw new RuntimeException(r + " is not defined as a property");
        }
        return role;
    }

    public Role addRole(ATermAppl r) {
        Role role = this.getRole((ATerm)r);
        if (role == null) {
            role = new Role(r, 0);
            this.roles.put(r, role);
        }
        return role;
    }

    public boolean addRange(ATerm p, ATermAppl a, Set<ATermAppl> explain) {
        Role r = this.getRole(p);
        if (r == null) {
            throw new IllegalArgumentException(p + " is not defined as a property");
        }
        ATermAppl normalized = ATermUtils.normalize(a);
        DependencySet ds = new DependencySet(explain);
        boolean added = this.addRange(r, normalized, ds);
        return added;
    }

    public boolean addRange(ATerm p, ATermAppl a) {
        Role r = this.getRole(p);
        if (r == null) {
            throw new IllegalArgumentException(p + " is not defined as a property");
        }
        ATermAppl normalized = ATermUtils.normalize(a);
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeRange(p, (ATerm)normalized)) : DependencySet.INDEPENDENT;
        return this.addRange(r, normalized, ds);
    }

    private boolean addRange(Role r, ATermAppl a, DependencySet ds) {
        Role i;
        boolean added = r.addRange(a, ds);
        if (added && (i = r.getInverse()) != null && !(added = i.addDomain(a, ds))) {
            log.warning(String.format("Unexpected condition: adding range succeeded, but adding domain to inverse failed (%s,%s)", r, a));
        }
        return added;
    }

    public Role addObjectRole(ATermAppl r) {
        Role role = this.getRole((ATerm)r);
        int roleType = role == null ? 0 : role.getType();
        switch (roleType) {
            case 2: {
                role = null;
                break;
            }
            case 1: {
                break;
            }
            default: {
                if (role == null) {
                    role = new Role(r, 1);
                    this.roles.put(r, role);
                } else {
                    role.setType(1);
                }
                ATermAppl invR = ATermUtils.makeInv(r);
                Role invRole = new Role(invR, 1);
                this.roles.put(invR, invRole);
                role.setInverse(invRole);
                invRole.setInverse(role);
                this.addSubRole((ATerm)ATermUtils.BOTTOM_OBJECT_PROPERTY, (ATerm)role.getName(), DependencySet.INDEPENDENT);
                this.addSubRole((ATerm)role.getName(), (ATerm)ATermUtils.TOP_OBJECT_PROPERTY, DependencySet.INDEPENDENT);
                this.addSubRole((ATerm)ATermUtils.BOTTOM_OBJECT_PROPERTY, (ATerm)role.getName(), DependencySet.INDEPENDENT);
                this.addSubRole((ATerm)role.getName(), (ATerm)ATermUtils.TOP_OBJECT_PROPERTY, DependencySet.INDEPENDENT);
            }
        }
        return role;
    }

    public Role addDatatypeRole(ATermAppl r) {
        Role role = this.getRole((ATerm)r);
        if (role == null) {
            role = new Role(r, 2);
            this.roles.put(r, role);
            this.addSubRole((ATerm)ATermUtils.BOTTOM_DATA_PROPERTY, (ATerm)role.getName(), DependencySet.INDEPENDENT);
            this.addSubRole((ATerm)role.getName(), (ATerm)ATermUtils.TOP_DATA_PROPERTY, DependencySet.INDEPENDENT);
        } else {
            switch (role.getType()) {
                case 2: {
                    break;
                }
                case 1: {
                    role = null;
                    break;
                }
                default: {
                    role.setType(2);
                    this.addSubRole((ATerm)ATermUtils.BOTTOM_DATA_PROPERTY, (ATerm)role.getName(), DependencySet.INDEPENDENT);
                    this.addSubRole((ATerm)role.getName(), (ATerm)ATermUtils.TOP_DATA_PROPERTY, DependencySet.INDEPENDENT);
                }
            }
        }
        return role;
    }

    public Role addAnnotationRole(ATermAppl r) {
        Role role = this.getRole((ATerm)r);
        if (role == null) {
            role = new Role(r, 3);
            this.roles.put(r, role);
        } else if (role.getType() == 0) {
            role.setType(3);
        } else if (role.getType() != 3) {
            role = null;
        }
        return role;
    }

    public Role addOntologyRole(ATermAppl r) {
        Role role = this.getRole((ATerm)r);
        if (role == null) {
            role = new Role(r, 4);
            this.roles.put(r, role);
        } else if (role.getType() == 0) {
            role.setType(4);
        } else if (role.getType() != 4) {
            role = null;
        }
        return role;
    }

    public boolean addSubRole(ATerm sub, ATerm sup) {
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeSubProp(sub, sup)) : DependencySet.INDEPENDENT;
        return this.addSubRole(sub, sup, ds);
    }

    public boolean addSubRole(ATerm sub, ATerm sup, DependencySet ds) {
        Role roleSup = this.getRole(sup);
        Role roleSub = this.getRole(sub);
        if (roleSup == null) {
            return false;
        }
        if (sub.getType() == 4) {
            roleSup.addSubRoleChain((ATermList)sub, ds);
        } else {
            if (roleSub == null) {
                return false;
            }
            roleSup.addSubRole(roleSub, ds);
            roleSub.addSuperRole(roleSup, ds);
        }
        return true;
    }

    public boolean addEquivalentRole(ATerm s, ATerm r) {
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeEqProp(s, r)) : DependencySet.INDEPENDENT;
        return this.addEquivalentRole(r, s, ds);
    }

    public boolean addEquivalentRole(ATerm s, ATerm r, DependencySet ds) {
        Role roleS = this.getRole(s);
        Role roleR = this.getRole(r);
        if (roleS == null || roleR == null) {
            return false;
        }
        roleR.addSubRole(roleS, ds);
        roleR.addSuperRole(roleS, ds);
        roleS.addSubRole(roleR, ds);
        roleS.addSuperRole(roleR, ds);
        if (roleR.getInverse() != null) {
            roleR.getInverse().addSubRole(roleS.getInverse(), ds);
            roleR.getInverse().addSuperRole(roleS.getInverse(), ds);
            roleS.getInverse().addSubRole(roleR.getInverse(), ds);
            roleS.getInverse().addSuperRole(roleR.getInverse(), ds);
        }
        return true;
    }

    public boolean addDisjointRole(ATerm s, ATerm r, DependencySet ds) {
        Role roleS = this.getRole(s);
        Role roleR = this.getRole(r);
        if (roleS == null || roleR == null) {
            return false;
        }
        roleR.addDisjointRole(roleS, ds);
        roleS.addDisjointRole(roleR, ds);
        return true;
    }

    public boolean addDomain(ATerm p, ATermAppl a, Set<ATermAppl> explain) {
        Role r = this.getRole(p);
        if (r == null) {
            throw new IllegalArgumentException(p + " is not defined as a property");
        }
        ATermAppl normalized = ATermUtils.normalize(a);
        DependencySet ds = new DependencySet(explain);
        return this.addDomain(r, normalized, ds);
    }

    public boolean addDomain(ATerm p, ATermAppl a) {
        Role r = this.getRole(p);
        if (r == null) {
            throw new IllegalArgumentException(p + " is not defined as a property");
        }
        ATermAppl normalized = ATermUtils.normalize(a);
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeDomain(p, (ATerm)normalized)) : DependencySet.INDEPENDENT;
        return this.addDomain(r, normalized, ds);
    }

    private boolean addDomain(Role r, ATermAppl a, DependencySet ds) {
        Role i;
        boolean added = r.addDomain(a, ds);
        if (added && (i = r.getInverse()) != null && !(added = i.addRange(a, ds))) {
            log.warning(String.format("Unexpected condition: adding domain succeeded, but adding range to inverse failed (%s,%s)", r, a));
        }
        return added;
    }

    public boolean addInverseRole(ATerm s, ATerm r, DependencySet ds) {
        Role roleS = this.getRole(s);
        Role roleR = this.getRole(r);
        if (roleS == null || roleR == null || !roleS.isObjectRole() || !roleR.isObjectRole()) {
            return false;
        }
        this.addEquivalentRole((ATerm)roleS.getInverse().getName(), r, ds);
        return true;
    }

    public boolean isDomainAsserted(ATerm p, ATermAppl a) {
        Role r = this.getRole(p);
        if (r == null) {
            throw new IllegalArgumentException(p + " is not defined as a property");
        }
        ATermAppl normalized = ATermUtils.normalize(a);
        DependencySet ds = r.getExplainDomain(normalized);
        if (ds == null) {
            return false;
        }
        if (PelletOptions.USE_TRACING) {
            return ds.getExplain().size() == 1 && ds.getExplain().iterator().next().getAFun().equals(ATermUtils.DOMAINFUN);
        }
        return ds == DependencySet.INDEPENDENT;
    }

    public boolean isRangeAsserted(ATerm p, ATermAppl a) {
        Role r = this.getRole(p);
        if (r == null) {
            throw new IllegalArgumentException(p + " is not defined as a property");
        }
        ATermAppl normalized = ATermUtils.normalize(a);
        DependencySet ds = r.getExplainRange(normalized);
        if (ds == null) {
            return false;
        }
        if (PelletOptions.USE_TRACING) {
            return ds.getExplain().size() == 1 && ds.getExplain().iterator().next().getAFun().equals(ATermUtils.RANGEFUN);
        }
        return ds == DependencySet.INDEPENDENT;
    }

    public boolean isRole(ATerm r) {
        return this.roles.containsKey(r);
    }

    public void prepare() {
        HashSet<Role> complexRoles = new HashSet<Role>();
        block0: for (Role role : this.roles.values()) {
            if (role.getType() != 1 && role.getType() != 2) continue;
            HashMap<ATerm, DependencySet> subExplain = new HashMap<ATerm, DependencySet>();
            HashSet<Role> subRoles = new HashSet<Role>();
            HashSet<ATermList> subRoleChains = new HashSet<ATermList>();
            this.computeSubRoles(role, subRoles, subRoleChains, subExplain, DependencySet.INDEPENDENT);
            role.setSubRolesAndChains(subRoles, subRoleChains, subExplain);
            for (Role s : subRoles) {
                DependencySet explainSub = role.getExplainSub((ATerm)s.getName());
                s.addSuperRole(role, explainSub);
            }
            for (ATermList chain : subRoleChains) {
                if (chain.getLength() == 2 && chain.getFirst().equals(chain.getLast()) && subRoles.contains(this.getRole(chain.getFirst()))) continue;
                role.setHasComplexSubRole(true);
                complexRoles.add(role);
                continue block0;
            }
        }
        for (Role role : complexRoles) {
            this.buildDFA(role, new HashSet<Role>());
        }
        for (Role role : this.roles.values()) {
            Role invR = role.getInverse();
            if (invR != null) {
                if (invR.isTransitive() && !role.isTransitive()) {
                    role.setTransitive(true, invR.getExplainTransitive());
                } else if (role.isTransitive() && !invR.isTransitive()) {
                    invR.setTransitive(true, role.getExplainTransitive());
                }
                if (invR.isFunctional() && !role.isInverseFunctional()) {
                    role.setInverseFunctional(true, invR.getExplainFunctional());
                }
                if (role.isFunctional() && !invR.isInverseFunctional()) {
                    invR.setInverseFunctional(true, role.getExplainFunctional());
                }
                if (invR.isInverseFunctional() && !role.isFunctional()) {
                    role.setFunctional(true, invR.getExplainInverseFunctional());
                }
                if (invR.isAsymmetric() && !role.isAsymmetric()) {
                    role.setAsymmetric(true, invR.getExplainAsymmetric());
                }
                if (role.isAsymmetric() && !invR.isAsymmetric()) {
                    invR.setAsymmetric(true, role.getExplainAsymmetric());
                }
                if (invR.isReflexive() && !role.isReflexive()) {
                    role.setReflexive(true, invR.getExplainReflexive());
                }
                if (role.isReflexive() && !invR.isReflexive()) {
                    invR.setReflexive(true, role.getExplainReflexive());
                }
                for (Role disjointR : role.getDisjointRoles()) {
                    invR.addDisjointRole(disjointR.getInverse(), role.getExplainDisjointRole(disjointR));
                }
            }
            for (Role s : role.getSubRoles()) {
                if (role.isForceSimple()) {
                    s.setForceSimple(true);
                }
                if (s.isSimple()) continue;
                role.setSimple(false);
            }
        }
        for (Role r : this.roles.values()) {
            if (r.isForceSimple()) {
                if (!r.isSimple()) {
                    this.ignoreTransitivity(r);
                }
            } else {
                boolean isTransitive = r.isTransitive();
                DependencySet transitiveDS = r.getExplainTransitive();
                for (Role s : r.getSubRoles()) {
                    if (!s.isTransitive()) continue;
                    if (r.isSubRoleOf(s) && r != s) {
                        isTransitive = true;
                        transitiveDS = r.getExplainSub((ATerm)s.getName()).union(s.getExplainTransitive(), true);
                    }
                    r.addTransitiveSubRole(s);
                }
                if (isTransitive != r.isTransitive()) {
                    r.setTransitive(isTransitive, transitiveDS);
                }
            }
            if (r.isFunctional()) {
                r.addFunctionalSuper(r);
            }
            for (Role s : r.getSuperRoles()) {
                DependencySet ds;
                DependencySet supDS;
                if (s.equals(r)) continue;
                DependencySet dependencySet = supDS = PelletOptions.USE_TRACING ? r.getExplainSuper((ATerm)s.getName()) : DependencySet.INDEPENDENT;
                if (s.isFunctional()) {
                    ds = PelletOptions.USE_TRACING ? supDS.union(s.getExplainFunctional(), true) : DependencySet.INDEPENDENT;
                    r.setFunctional(true, ds);
                    r.addFunctionalSuper(s);
                }
                if (s.isIrreflexive() && !r.isIrreflexive()) {
                    ds = PelletOptions.USE_TRACING ? supDS.union(s.getExplainIrreflexive(), true) : DependencySet.INDEPENDENT;
                    r.setIrreflexive(true, ds);
                }
                for (Role disjointR : s.getDisjointRoles()) {
                    DependencySet ds2 = PelletOptions.USE_TRACING ? supDS.union(s.getExplainDisjointRole(disjointR), true) : DependencySet.INDEPENDENT;
                    r.addDisjointRole(disjointR, ds2);
                }
            }
            if (r.isReflexive() && !r.isAnon()) {
                this.reflexiveRoles.add(r);
            }
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine(r.debugString());
        }
        this.objectTaxonomy = null;
        this.dataTaxonomy = null;
    }

    public void propagateDomainRange() {
        DependencySet sds;
        DependencySet rds;
        for (Pair<Role, DependencySet> pair : this.domainRemovals) {
            rds = (DependencySet)pair.second;
            for (Role s : ((Role)pair.first).getSubRoles()) {
                ATermAppl[] domains;
                for (ATermAppl domain : domains = s.getDomains().toArray(new ATermAppl[0])) {
                    sds = s.getExplainDomain(domain);
                    if (!SetUtils.intersects(rds.getExplain(), sds.getExplain())) continue;
                    s.removeDomain(domain, sds);
                }
            }
        }
        this.domainRemovals.clear();
        for (Pair<Role, DependencySet> pair : this.rangeRemovals) {
            rds = (DependencySet)pair.second;
            for (Role s : ((Role)pair.first).getSubRoles()) {
                ATermAppl[] ranges = s.getRanges().toArray(new ATermAppl[0]);
                for (ATermAppl range : ranges) {
                    sds = s.getExplainRange(range);
                    if (!SetUtils.intersects(rds.getExplain(), sds.getExplain())) continue;
                    s.removeRange(range, sds);
                }
            }
        }
        this.rangeRemovals.clear();
        for (Role role : this.roles.values()) {
            Set<ATermAppl> domains = role.getDomains();
            Set<ATermAppl> ranges = role.getRanges();
            for (Role s : role.getSubRoles()) {
                DependencySet ds;
                DependencySet explainSub = role.getExplainSub((ATerm)s.getName());
                for (ATermAppl domain : domains.toArray(new ATermAppl[0])) {
                    if (s.getDomains().contains(domain)) continue;
                    ds = explainSub.union(role.getExplainDomain(domain), true);
                    s.addDomain(domain, ds);
                }
                for (ATermAppl range : ranges.toArray(new ATermAppl[0])) {
                    if (s.getRanges().contains(range)) continue;
                    ds = explainSub.union(role.getExplainRange(range), true);
                    s.addRange(range, ds);
                }
            }
        }
    }

    public boolean removeDomain(ATerm p, ATermAppl a) {
        DependencySet ds;
        if (!PelletOptions.USE_TRACING) {
            return false;
        }
        Role r = this.getRole(p);
        if (r == null) {
            return false;
        }
        ATermAppl normalized = ATermUtils.normalize(a);
        boolean removed = r.removeDomain(normalized, ds = new DependencySet(ATermUtils.makeDomain(p, (ATerm)normalized)));
        if (removed) {
            this.domainRemovals.add(new Pair<Role, DependencySet>(r, ds));
            Role i = r.getInverse();
            if (i != null) {
                removed = i.removeRange(normalized, ds);
                this.rangeRemovals.add(new Pair<Role, DependencySet>(i, ds));
            }
        }
        return removed;
    }

    public boolean removeRange(ATerm p, ATermAppl a) {
        DependencySet ds;
        if (!PelletOptions.USE_TRACING) {
            return false;
        }
        Role r = this.getRole(p);
        if (r == null) {
            return false;
        }
        ATermAppl normalized = ATermUtils.normalize(a);
        boolean removed = r.removeRange(normalized, ds = new DependencySet(ATermUtils.makeRange(p, (ATerm)normalized)));
        if (removed) {
            this.rangeRemovals.add(new Pair<Role, DependencySet>(r, ds));
            Role i = r.getInverse();
            if (i != null) {
                removed = i.removeDomain(normalized, ds);
                this.domainRemovals.add(new Pair<Role, DependencySet>(i, ds));
            }
        }
        return removed;
    }

    private void ignoreTransitivity(Role role) {
        Role namedRole = role.isAnon() ? role.getInverse() : role;
        String msg = "Unsupported axiom: Ignoring transitivity and/or complex subproperty axioms for " + namedRole;
        if (!PelletOptions.IGNORE_UNSUPPORTED_AXIOMS) {
            throw new UnsupportedFeatureException(msg);
        }
        log.warning(msg);
        role.removeSubRoleChains();
        role.setHasComplexSubRole(false);
        role.setSimple(true);
        role.setFSM(null);
        role.getInverse().removeSubRoleChains();
        role.getInverse().setHasComplexSubRole(false);
        role.getInverse().setSimple(true);
        role.getInverse().setFSM(null);
    }

    private void computeImmediateSubRoles(Role r, Map<ATerm, DependencySet> subs) {
        DependencySet subDS;
        Role invR = r.getInverse();
        if (invR != null && invR != r) {
            for (Role invSubR : invR.getSubRoles()) {
                Role subR = invSubR.getInverse();
                if (subR == null) {
                    System.err.println("Property " + invSubR + " was supposed to be an ObjectProperty but it is not!");
                    continue;
                }
                if (subR == r) continue;
                DependencySet subDS2 = invR.getExplainSub((ATerm)invSubR.getName());
                subs.put((ATerm)subR.getName(), subDS2);
            }
            for (ATermList roleChain : invR.getSubRoleChains()) {
                subDS = invR.getExplainSub((ATerm)roleChain);
                ATermList subChain = this.inverse(roleChain);
                subs.put((ATerm)subChain, subDS);
            }
        }
        for (Role sub : r.getSubRoles()) {
            subDS = r.getExplainSub((ATerm)sub.getName());
            subs.put((ATerm)sub.getName(), subDS);
        }
        for (ATermList subChain : r.getSubRoleChains()) {
            subDS = r.getExplainSub((ATerm)subChain);
            subs.put((ATerm)subChain, subDS);
        }
    }

    private void computeSubRoles(Role r, Set<Role> subRoles, Set<ATermList> subRoleChains, Map<ATerm, DependencySet> dependencies, DependencySet ds) {
        if (subRoles.contains(r)) {
            return;
        }
        subRoles.add(r);
        dependencies.put((ATerm)r.getName(), ds);
        HashMap<ATerm, DependencySet> immSubs = new HashMap<ATerm, DependencySet>();
        this.computeImmediateSubRoles(r, immSubs);
        for (Map.Entry entry : immSubs.entrySet()) {
            DependencySet subDS;
            ATerm sub = (ATerm)entry.getKey();
            DependencySet dependencySet = subDS = PelletOptions.USE_TRACING ? ds.union((DependencySet)entry.getValue(), true) : DependencySet.INDEPENDENT;
            if (sub instanceof ATermAppl) {
                Role subRole = this.getRole(sub);
                this.computeSubRoles(subRole, subRoles, subRoleChains, dependencies, subDS);
                continue;
            }
            subRoleChains.add((ATermList)sub);
            dependencies.put(sub, subDS);
        }
    }

    private TransitionGraph<Role> buildDFA(Role s, Set<Role> visited) {
        if (!visited.add(s)) {
            return null;
        }
        TransitionGraph<Role> tg = s.getFSM();
        if (tg == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Building NFA for " + s);
            }
            if ((tg = this.buildNFA(s, visited)) == null) {
                log.warning("Cycle detected in the complex subproperty chain involving " + s);
                s.setForceSimple(true);
                this.ignoreTransitivity(s);
                return null;
            }
            assert (tg.isConnected());
            if (log.isLoggable(Level.FINE)) {
                log.fine("Determinize " + s + ": " + tg.size());
            }
            tg = this.handleSymmetry(s, tg);
            assert (tg.isConnected());
            tg.determinize();
            assert (tg.isConnected());
            assert (tg.isDeterministic());
            if (log.isLoggable(Level.FINE)) {
                log.fine("Minimize NFA for " + s + ": " + tg);
            }
            tg.minimize();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Minimized NFA for " + s + ": " + tg);
            }
            assert (tg.isConnected());
            tg.renumber();
            assert (tg.isConnected());
            this.setFSM(s, tg);
            this.setFSM(s.getInverse(), this.mirror(tg).determinize().renumber());
        }
        visited.remove(s);
        return tg;
    }

    private void setFSM(Role s, TransitionGraph<Role> tg) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("NFA for " + s + ":\n" + tg);
        }
        s.setFSM(tg);
        Set<Role> eqRoles = s.getEquivalentProperties();
        eqRoles.remove(s);
        for (Role eqRole : eqRoles) {
            eqRole.setFSM(tg);
        }
    }

    private TransitionGraph<Role> buildNFA(Role s, Set<Role> visited) {
        TransitionGraph<Role> tg = new TransitionGraph<Role>();
        State i = tg.newState();
        State f = tg.newState();
        tg.setInitialState(i);
        tg.addFinalState(f);
        tg.addTransition(i, s, f);
        if (s.isBuiltin()) {
            return tg;
        }
        for (Role sub : s.getProperSubRoles()) {
            if (sub.isBottom() || sub.getInverse().isBottom()) continue;
            tg.addTransition(i, sub, f);
        }
        for (ATermList subChain : s.getSubRoleChains()) {
            if (this.addRoleChainTransition(tg, s, subChain)) continue;
            return null;
        }
        HashSet<Role> alphabet = new HashSet<Role>(tg.getAlpahabet());
        for (Role r : alphabet) {
            for (Pair<State<Role>, State<Role>> pair : tg.findTransitions(r)) {
                if (s.isEquivalent(r)) {
                    if (tg.isInitial((State)pair.first) || tg.isFinal((State)pair.second) || tg.isFinal((State)pair.first) && tg.isInitial((State)pair.second)) continue;
                    return null;
                }
                TransitionGraph<Role> newGraph = this.buildDFA(r, visited);
                if (newGraph == null) {
                    return null;
                }
                tg.insert(newGraph, (State)pair.first, (State)pair.second);
            }
        }
        return tg;
    }

    private boolean addRoleChainTransition(TransitionGraph<Role> tg, Role s, ATermList chain) {
        Role firstRole = this.getRole(chain.getFirst());
        Role lastRole = this.getRole(chain.getLast());
        boolean firstRoleSame = s.isEquivalent(firstRole);
        boolean lastRoleSame = s.isEquivalent(lastRole);
        int length = chain.getLength();
        if (firstRoleSame) {
            if (lastRoleSame && length != 2) {
                return false;
            }
            this.addRoleChainTransition(tg, tg.getFinalState(), tg.getFinalState(), chain.getNext(), length - 1);
        } else if (lastRoleSame) {
            this.addRoleChainTransition(tg, tg.getInitialState(), tg.getInitialState(), chain, length - 1);
        } else {
            this.addRoleChainTransition(tg, tg.getInitialState(), tg.getFinalState(), chain, length);
        }
        return true;
    }

    private void addRoleChainTransition(TransitionGraph<Role> tg, State<Role> initialState, State<Role> finalState, ATermList chain, int length) {
        State<Role> prev = initialState;
        int i = 0;
        while (i < length) {
            Role role = this.getRole(chain.getFirst());
            State<Role> next = i == length - 1 ? finalState : tg.newState();
            tg.addTransition(prev, role, next);
            prev = next;
            ++i;
            chain = chain.getNext();
        }
    }

    private TransitionGraph<Role> handleSymmetry(Role r, TransitionGraph<Role> tg) {
        if (!r.getSubRoles().contains(r.getInverse())) {
            return tg;
        }
        return tg.choice(this.mirror(tg));
    }

    private TransitionGraph<Role> mirror(TransitionGraph<Role> tg) {
        HashMap<State<Role>, State<Role>> newStates = new HashMap<State<Role>, State<Role>>();
        TransitionGraph<Role> mirror = new TransitionGraph<Role>();
        State<Role> oldInitialState = tg.getInitialState();
        State<Role> newFinalState = this.copyState(oldInitialState, mirror, newStates);
        mirror.addFinalState(newFinalState);
        Set<State<Role>> oldFinalStates = tg.getFinalStates();
        State newInitialState = null;
        if (oldFinalStates.size() == 1) {
            State<Role> oldFinalState = oldFinalStates.iterator().next();
            newInitialState = (State)newStates.get(oldFinalState);
        } else {
            newInitialState = mirror.newState();
            for (State<Role> oldFinalState : oldFinalStates) {
                mirror.addTransition(newInitialState, (State)newStates.get(oldFinalState));
            }
        }
        mirror.setInitialState(newInitialState);
        return mirror;
    }

    private State<Role> copyState(State<Role> oldState, TransitionGraph<Role> newTG, Map<State<Role>, State<Role>> newStates) {
        State<Role> newState = newStates.get(oldState);
        if (newState == null) {
            newState = newTG.newState();
            newStates.put(oldState, newState);
            for (Transition<Role> t : oldState.getTransitions()) {
                State<Role> oldTo = t.getTo();
                State<Role> newFrom = this.copyState(oldTo, newTG, newStates);
                if (t.isEpsilon()) {
                    newTG.addTransition(newFrom, newState);
                    continue;
                }
                newTG.addTransition(newFrom, t.getName().getInverse(), newState);
            }
        }
        return newState;
    }

    public String toString() {
        return "[RBox " + this.roles.values() + "]";
    }

    public ATermList inverse(ATermList roles) {
        ATermList invList = ATermUtils.EMPTY_LIST;
        ATermList list = roles;
        while (!list.isEmpty()) {
            ATermAppl r = (ATermAppl)list.getFirst();
            Role role = this.getRole((ATerm)r);
            Role invR = role.getInverse();
            if (invR == null) {
                System.err.println("Property " + r + " was supposed to be an ObjectProperty but it is not!");
            } else {
                invList = invList.insert((ATerm)invR.getName());
            }
            list = list.getNext();
        }
        return invList;
    }

    public Set<ATermAppl> getRoleNames() {
        return this.roles.keySet();
    }

    public Set<Role> getReflexiveRoles() {
        return this.reflexiveRoles;
    }

    public Collection<Role> getRoles() {
        return this.roles.values();
    }

    public Taxonomy<ATermAppl> getObjectTaxonomy() {
        if (this.objectTaxonomy == null) {
            RoleTaxonomyBuilder builder = new RoleTaxonomyBuilder(this, true);
            this.objectTaxonomy = builder.classify();
        }
        return this.objectTaxonomy;
    }

    public Taxonomy<ATermAppl> getDataTaxonomy() {
        if (this.dataTaxonomy == null) {
            RoleTaxonomyBuilder builder = new RoleTaxonomyBuilder(this, false);
            this.dataTaxonomy = builder.classify();
        }
        return this.dataTaxonomy;
    }
}

