/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import com.sun.msv.datatype.xsd.DatatypeFactory;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.datatype.xsd.datetime.BigDateTimeValueType;
import com.sun.msv.datatype.xsd.datetime.IDateTimeValueType;
import com.sun.msv.datatype.xsd.datetime.ITimeDurationValueType;
import com.sun.msv.datatype.xsd.datetime.TimeDurationFactory;
import com.sun.msv.datatype.xsd.datetime.TimeZone;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.mindswap.pellet.datatypes.AbstractValueSpace;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseXSDAtomicType;
import org.mindswap.pellet.datatypes.ValueSpace;
import org.mindswap.pellet.datatypes.XSDDateTime;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.GenericIntervalList;
import org.relaxng.datatype.DatatypeException;

public class XSDDuration
extends BaseXSDAtomicType
implements AtomicDatatype {
    private static XSDatatype dt = null;
    private static final Object NEG_INF = "-Inf";
    private static final Object POS_INF = "+Inf";
    private static final ITimeDurationValueType DURATION_ZERO = TimeDurationFactory.create(null, null, null, null, null, null);
    private static final IDateTimeValueType TIME_ZERO = new BigDateTimeValueType(new BigInteger("1970"), 0, 0, 0, 0, new BigDecimal(0), TimeZone.GMT);
    public static final ValueSpace DURATION_VALUE_SPACE;
    public static XSDDuration instance;

    XSDDuration() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#duration"), DURATION_VALUE_SPACE);
    }

    public BaseXSDAtomicType create(GenericIntervalList intervals) {
        XSDDuration type = new XSDDuration();
        type.values = intervals;
        return type;
    }

    public AtomicDatatype getPrimitiveType() {
        return instance;
    }

    static {
        try {
            dt = DatatypeFactory.getTypeByName((String)"duration");
        }
        catch (DatatypeException e) {
            e.printStackTrace();
        }
        DURATION_VALUE_SPACE = new DurationValueSpace();
        instance = new XSDDuration();
    }

    public static class DurationValueSpace
    extends AbstractValueSpace
    implements ValueSpace {
        public DurationValueSpace() {
            super(NEG_INF, DURATION_ZERO, POS_INF, true);
        }

        public boolean isValid(Object value) {
            return value instanceof ITimeDurationValueType;
        }

        public Object getValue(String value) {
            return (ITimeDurationValueType)dt.createValue(value, null);
        }

        public int compare(Object a, Object b) {
            if (a == b) {
                return EQ;
            }
            if (a == POS_INF || b == NEG_INF) {
                return GT;
            }
            if (b == POS_INF || a == NEG_INF) {
                return LT;
            }
            return ((ITimeDurationValueType)a).compare((ITimeDurationValueType)b);
        }

        public int count(Object start, Object end) {
            if (start == end) {
                return SIZE_ONE;
            }
            if (start == POS_INF || end == NEG_INF) {
                return SIZE_INF;
            }
            if (end == POS_INF || start == NEG_INF) {
                return SIZE_INF;
            }
            IDateTimeValueType t1 = TIME_ZERO.add((ITimeDurationValueType)start);
            IDateTimeValueType t2 = TIME_ZERO.add((ITimeDurationValueType)end);
            return XSDDateTime.instance.getValueSpace().count(t1, t2);
        }

        public Object succ(Object start, int n) {
            if (this.isInfinite(start)) {
                throw new IllegalArgumentException("Cannot handle infinite values");
            }
            IDateTimeValueType duration = TIME_ZERO.add((ITimeDurationValueType)start);
            BigDecimal millis = new BigDecimal(duration.toCalendar().getTimeInMillis());
            BigDecimal succ = millis.add(new BigDecimal(n));
            return TimeDurationFactory.create(null, null, null, null, null, (Number)succ);
        }

        public String getLexicalForm(Object value) {
            String str = value.toString();
            String abs = str.replaceAll("-", "");
            boolean negative = str.length() != abs.length();
            return negative ? "-" + abs : str;
        }
    }
}

