/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.dig;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Logger;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.dig.DIGConstants;
import org.mindswap.pellet.dig.ElementList;
import org.mindswap.pellet.dig.PelletDIGServer;
import org.mindswap.pellet.utils.ATermUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DIGHandler
extends DIGConstants {
    protected static Logger log = Logger.getLogger(PelletDIGServer.class.getName());
    protected KnowledgeBase kb = null;

    public KnowledgeBase getKB() {
        return this.kb;
    }

    public void setKB(KnowledgeBase kb) {
        this.kb = kb;
    }

    public static String getAttributeValue(Element node, String name) {
        return node.getAttribute(name);
    }

    public static Element getElement(Element node) {
        Element[] nodes = DIGHandler.getElementArray(node);
        return nodes.length > 0 ? nodes[0] : null;
    }

    public static Element[] getElementArray(Element node) {
        return new ElementList(node.getChildNodes()).getNodeArray();
    }

    public static ElementList getElements(Element node) {
        return new ElementList(node.getChildNodes());
    }

    public static ElementList getElements(Element node, String tagName) {
        return new ElementList(node.getElementsByTagName(tagName));
    }

    public static String getTagName(Element node) {
        return node.getLocalName();
    }

    public static String getURI(Element node) {
        return DIGHandler.getAttributeValue(node, "uri");
    }

    public static String getName(Element node) {
        return DIGHandler.getAttributeValue(node, "name");
    }

    public static int getNum(Element node) {
        return Integer.parseInt(DIGHandler.getAttributeValue(node, "num"));
    }

    public static int getIntVal(Element node) {
        return Integer.parseInt(DIGHandler.getAttributeValue(node, "val"));
    }

    public static String getVal(Element node) {
        return DIGHandler.getAttributeValue(node, "val");
    }

    public static ATermAppl getNameTerm(Element node) {
        return ATermUtils.makeTermAppl(DIGHandler.getAttributeValue(node, "name"));
    }

    public static String getId(Element node) {
        return DIGHandler.getAttributeValue(node, "id");
    }

    public ATermAppl getInverse(Element node) {
        if (DIGHandler.getTagName(node).equals("inverse")) {
            return this.property(DIGHandler.getElement(node));
        }
        return null;
    }

    public ATermAppl literal(Element node) {
        String type = DIGHandler.getTagName(node);
        ATermAppl term = null;
        if (type.equals("sval")) {
            Node child = node.getFirstChild();
            String val = child == null ? "" : child.getNodeValue();
            term = ATermUtils.makePlainLiteral(val);
        } else if (type.equals("ival")) {
            String val = node.getFirstChild().getNodeValue();
            term = ATermUtils.makeTypedLiteral(val, "http://www.w3.org/2001/XMLSchema#int");
        } else {
            throw new RuntimeException("Invalid data value constructor " + type);
        }
        return term;
    }

    public ATermAppl property(Element node) {
        String type = DIGHandler.getTagName(node);
        ATermAppl term = null;
        if (type.equals("ratom")) {
            term = DIGHandler.getNameTerm(node);
        } else if (type.equals("attribute")) {
            term = DIGHandler.getNameTerm(node);
        } else if (type.equals("inverse")) {
            if (this.kb.isChanged()) {
                throw new RuntimeException("<inverse> tag is only supported in <equalr> or in <ask> queries");
            }
            term = this.kb.getInverse((ATerm)this.getInverse(node));
        } else {
            if (type.equals("feature")) {
                throw new RuntimeException("<feature> not supported");
            }
            try {
                term = DIGHandler.getNameTerm(node);
                log.severe(type + " is not a valid role constructor");
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid role constructor: " + type);
            }
        }
        return term;
    }

    public static ATermAppl individual(Element c) {
        return DIGHandler.getNameTerm(c);
    }

    public ATermAppl concept(Element c) {
        String type = DIGHandler.getTagName(c);
        ATermAppl term = null;
        if (type.equals("top")) {
            term = ATermUtils.TOP;
        } else if (type.equals("bottom")) {
            term = ATermUtils.BOTTOM;
        } else if (type.equals("catom")) {
            term = DIGHandler.getNameTerm(c);
        } else if (type.equals("and")) {
            ElementList nodes = DIGHandler.getElements(c);
            ATermList list = ATermUtils.EMPTY_LIST;
            for (int i = nodes.getLength() - 1; i >= 0; --i) {
                Element node = nodes.item(i);
                list = list.append((ATerm)this.concept(node));
            }
            term = ATermUtils.makeAnd(list);
        } else if (type.equals("or")) {
            ElementList nodes = DIGHandler.getElements(c);
            ATermList list = ATermUtils.EMPTY_LIST;
            for (int i = nodes.getLength() - 1; i >= 0; --i) {
                Element node = nodes.item(i);
                list = list.append((ATerm)this.concept(node));
            }
            term = ATermUtils.makeOr(list);
        } else if (type.equals("not")) {
            Element node = DIGHandler.getElement(c);
            term = ATermUtils.makeNot((ATerm)this.concept(node));
        } else if (type.equals("all")) {
            ElementList nodes = DIGHandler.getElements(c);
            if (nodes.getLength() != 2) {
                throw new RuntimeException("Invalid ALL property restriction");
            }
            ATermAppl prop = this.property(nodes.item(0));
            ATermAppl allValues = this.concept(nodes.item(1));
            term = ATermUtils.makeAllValues((ATerm)prop, (ATerm)allValues);
        } else if (type.equals("some")) {
            ElementList nodes = DIGHandler.getElements(c);
            if (nodes.getLength() != 2) {
                throw new RuntimeException("Invalid SOME property restriction");
            }
            ATermAppl prop = this.property(nodes.item(0));
            ATermAppl someValues = this.concept(nodes.item(1));
            term = ATermUtils.makeSomeValues((ATerm)prop, (ATerm)someValues);
        } else if (type.equals("atmost")) {
            ElementList nodes = DIGHandler.getElements(c);
            if (nodes.getLength() != 2) {
                throw new RuntimeException("Invalid ATMOST property restriction");
            }
            int num = DIGHandler.getNum(c);
            ATermAppl prop = this.property(nodes.item(0));
            ATermAppl qualification = this.concept(nodes.item(1));
            term = ATermUtils.makeMax((ATerm)prop, num, (ATerm)qualification);
        } else if (type.equals("atleast")) {
            ElementList nodes = DIGHandler.getElements(c);
            if (nodes.getLength() != 2) {
                throw new RuntimeException("Invalid ATLEAST property restriction");
            }
            int num = DIGHandler.getNum(c);
            ATermAppl prop = this.property(nodes.item(0));
            ATermAppl qualification = this.concept(nodes.item(1));
            term = ATermUtils.makeMin((ATerm)prop, num, (ATerm)qualification);
        } else if (type.equals("iset")) {
            ElementList nodes = DIGHandler.getElements(c);
            ATermList list = ATermUtils.EMPTY_LIST;
            for (int i = nodes.getLength() - 1; i >= 0; --i) {
                Element node = nodes.item(i);
                list = list.append((ATerm)ATermUtils.makeValue((ATerm)DIGHandler.individual(node)));
            }
            term = ATermUtils.makeOr(list);
        } else if (type.equals("intequals")) {
            Element node = DIGHandler.getElement(c);
            String val = String.valueOf(DIGHandler.getIntVal(c));
            ATermAppl prop = this.property(node);
            ATermAppl value = ATermUtils.makeTypedLiteral(val, "http://www.w3.org/2001/XMLSchema#int");
            term = ATermUtils.makeHasValue((ATerm)prop, (ATerm)value);
        } else if (type.equals("stringequals")) {
            Element node = DIGHandler.getElement(c);
            String val = DIGHandler.getVal(c);
            ATermAppl prop = this.property(node);
            ATermAppl value = ATermUtils.makePlainLiteral(val);
            term = ATermUtils.makeHasValue((ATerm)prop, (ATerm)value);
        } else {
            throw new RuntimeException("Invalid concept constructor " + type);
        }
        return term;
    }

    public static String serialize(Document doc) {
        return DIGHandler.serialize(doc.getDocumentElement());
    }

    public static String serialize(Element el) {
        try {
            StringWriter out = new StringWriter();
            Document doc = el.getOwnerDocument();
            OutputFormat format = new OutputFormat(doc);
            format.setIndenting(true);
            format.setLineWidth(0);
            format.setPreserveSpace(false);
            format.setOmitXMLDeclaration(false);
            XMLSerializer serial = new XMLSerializer((Writer)out, format);
            serial.asDOMSerializer();
            serial.serialize(el);
            return out.toString();
        }
        catch (IOException e) {
            log.severe("Problem serializing element " + e);
            return "Problem serializing element " + e;
        }
    }
}

