/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.dig;

import aterm.ATermAppl;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.xerces.dom.DocumentImpl;
import org.mindswap.pellet.dig.DIGErrors;
import org.mindswap.pellet.utils.ATermUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DIGResponse {
    private Document doc = new DocumentImpl();
    private Element root;

    public DIGResponse(String rootTag) {
        this.root = this.doc.createElement(rootTag);
        this.root.setAttribute("xmlns", "http://dl.kr.org/dig/2003/02/lang");
        this.root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://dl.kr.org/dig/2003/02/lang      http://dl-web.man.ac.uk/dig/2003/02/dig.xsd");
        this.doc.appendChild(this.root);
    }

    public Document getDocument() {
        return this.doc;
    }

    protected Element addElement(String tag) {
        return this.addElement(tag, this.root);
    }

    protected Element addElement(String tag, Element parent) {
        Element element = this.doc.createElement(tag);
        parent.appendChild(element);
        return element;
    }

    public static Document createOkResponse() {
        DIGResponse resp = new DIGResponse("response");
        resp.addElement("ok");
        return resp.getDocument();
    }

    public static Document createKBResponse(String uri) {
        DIGResponse resp = new DIGResponse("response");
        Element kb = resp.addElement("kb");
        kb.setAttribute("uri", uri);
        return resp.getDocument();
    }

    public static Document createErrorResponse(int code, String details) {
        DIGResponse resp = new DIGResponse("response");
        resp.addError(code, details);
        return resp.getDocument();
    }

    public Element addError(int code, String details) {
        Element error = this.addElement("error");
        error.setAttribute("code", DIGErrors.codes[2 * code]);
        error.setAttribute("message", DIGErrors.codes[2 * code + 1]);
        if (details != null) {
            error.appendChild(this.doc.createTextNode(details));
        }
        return error;
    }

    public Element addBoolean(boolean b) {
        return this.addElement(b ? "true" : "false");
    }

    public Element addConceptSet(Collection<Set<ATermAppl>> concepts) {
        return this.addSet(concepts, "conceptSet", "catom");
    }

    public Element addRoleSet(Collection<Set<ATermAppl>> roles, boolean attribute) {
        return this.addSet(roles, "roleSet", attribute ? "attribute" : "ratom");
    }

    public Element addIndividualSet(Collection<ATermAppl> individuals) {
        Element set = this.addElement("individualSet");
        for (ATermAppl individual : individuals) {
            Element element = this.addElement("individual", set);
            element.setAttribute("name", individual.getName());
        }
        return set;
    }

    public void addValues(Collection<ATermAppl> values, String id) {
        for (ATermAppl literal : values) {
            String value = literal.getArgument(0).toString();
            ATermAppl datatypeURI = (ATermAppl)literal.getArgument(2);
            boolean isInt = !datatypeURI.equals(ATermUtils.EMPTY);
            Element val = this.addElement(isInt ? "ival" : "sval");
            val.appendChild(this.doc.createTextNode(value));
            val.setAttribute("id", id);
        }
    }

    public Element addIndividualPairSet(Map<ATermAppl, Collection<ATermAppl>> values) {
        Element set = this.addElement("individualPairSet");
        for (Map.Entry<ATermAppl, Collection<ATermAppl>> entry : values.entrySet()) {
            ATermAppl subj = entry.getKey();
            for (ATermAppl obj : entry.getValue()) {
                Element indPair = this.addElement("individualPair", set);
                Element subjElement = this.addElement("individual", indPair);
                subjElement.setAttribute("name", subj.getName());
                Element objElement = this.addElement("individual", indPair);
                objElement.setAttribute("name", obj.getName());
            }
        }
        return set;
    }

    private Element addSet(Collection<Set<ATermAppl>> values, String tag, String atom) {
        Element set = this.addElement(tag);
        for (Set<ATermAppl> synonms : values) {
            this.addSynonms(set, synonms, atom);
        }
        return set;
    }

    public void addSynonms(Element parent, Collection<ATermAppl> elements, String atom) {
        Element synonms = this.addElement("synonyms", parent);
        for (ATermAppl term : elements) {
            if (term.equals(ATermUtils.TOP)) {
                this.addElement("top", synonms);
                continue;
            }
            if (term.equals(ATermUtils.BOTTOM)) {
                this.addElement("bottom", synonms);
                continue;
            }
            Element element = this.addElement(atom, synonms);
            element.setAttribute("name", term.getName());
        }
    }
}

