/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatypes;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.vocabulary.OWL;
import java.util.Map;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.jena.vocabulary.OWL2;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.QNameProvider;

public class JenaUtils {
    public static final Literal XSD_BOOLEAN_TRUE = ResourceFactory.createTypedLiteral((String)Boolean.TRUE.toString(), (RDFDatatype)XSDDatatype.XSDboolean);

    public static ATermAppl makeLiteral(LiteralLabel jenaLiteral) {
        String lexicalValue = jenaLiteral.getLexicalForm();
        String datatypeURI = jenaLiteral.getDatatypeURI();
        ATermAppl literalValue = null;
        literalValue = datatypeURI != null ? ATermUtils.makeTypedLiteral(lexicalValue, datatypeURI) : (jenaLiteral.language() != null ? ATermUtils.makePlainLiteral(lexicalValue, jenaLiteral.language()) : ATermUtils.makePlainLiteral(lexicalValue));
        return literalValue;
    }

    public static ATermAppl makeATerm(RDFNode node) {
        return JenaUtils.makeATerm(node.asNode());
    }

    public static ATermAppl makeATerm(Node node) {
        if (node.isLiteral()) {
            return JenaUtils.makeLiteral(node.getLiteral());
        }
        if (node.isBlank()) {
            return ATermUtils.makeBnode(node.getBlankNodeLabel());
        }
        if (node.isURI()) {
            if (node.equals((Object)OWL.Thing.asNode())) {
                return ATermUtils.TOP;
            }
            if (node.equals((Object)OWL.Nothing.asNode())) {
                return ATermUtils.BOTTOM;
            }
            if (node.equals((Object)OWL2.topDataProperty.asNode())) {
                return ATermUtils.TOP_DATA_PROPERTY;
            }
            if (node.equals((Object)OWL2.bottomDataProperty.asNode())) {
                return ATermUtils.BOTTOM_DATA_PROPERTY;
            }
            if (node.equals((Object)OWL2.topObjectProperty.asNode())) {
                return ATermUtils.TOP_OBJECT_PROPERTY;
            }
            if (node.equals((Object)OWL2.bottomObjectProperty.asNode())) {
                return ATermUtils.BOTTOM_OBJECT_PROPERTY;
            }
            return ATermUtils.makeTermAppl(node.getURI());
        }
        if (node.isVariable()) {
            return ATermUtils.makeVar(node.getName());
        }
        return null;
    }

    public static Node makeGraphLiteral(ATermAppl literal) {
        Node node;
        String lexicalValue = ((ATermAppl)literal.getArgument(0)).getName();
        ATermAppl lang = (ATermAppl)literal.getArgument(1);
        ATermAppl datatype = (ATermAppl)literal.getArgument(2);
        if (datatype.equals(ATermUtils.PLAIN_LITERAL_DATATYPE)) {
            node = lang.equals(ATermUtils.EMPTY) ? Node.createLiteral((String)lexicalValue) : Node.createLiteral((String)lexicalValue, (String)lang.getName(), (boolean)false);
        } else if (datatype.equals(Datatypes.XML_LITERAL)) {
            node = Node.createLiteral((String)lexicalValue, (String)"", (boolean)true);
        } else {
            RDFDatatype type = TypeMapper.getInstance().getTypeByName(datatype.getName());
            node = Node.createLiteral((String)lexicalValue, (String)"", (RDFDatatype)type);
        }
        return node;
    }

    public static Node makeGraphResource(ATermAppl term) {
        if (ATermUtils.isBnode(term)) {
            return Node.createAnon((AnonId)new AnonId(((ATermAppl)term.getArgument(0)).getName()));
        }
        if (term.equals(ATermUtils.TOP)) {
            return OWL.Thing.asNode();
        }
        if (term.equals(ATermUtils.BOTTOM)) {
            return OWL.Nothing.asNode();
        }
        if (term.equals(ATermUtils.TOP_DATA_PROPERTY)) {
            return OWL2.topDataProperty.asNode();
        }
        if (term.equals(ATermUtils.BOTTOM_DATA_PROPERTY)) {
            return OWL2.bottomDataProperty.asNode();
        }
        if (term.equals(ATermUtils.TOP_OBJECT_PROPERTY)) {
            return OWL2.topObjectProperty.asNode();
        }
        if (term.equals(ATermUtils.BOTTOM_OBJECT_PROPERTY)) {
            return OWL2.bottomObjectProperty.asNode();
        }
        if (term.getArity() == 0) {
            return Node.createURI((String)term.getName());
        }
        throw new InternalReasonerException("Invalid term found " + term);
    }

    public static Node makeGraphNode(ATermAppl value) {
        if (ATermUtils.isLiteral(value)) {
            return JenaUtils.makeGraphLiteral(value);
        }
        return JenaUtils.makeGraphResource(value);
    }

    public static Literal makeLiteral(ATermAppl literal, Model model) {
        return (Literal)model.asRDFNode(JenaUtils.makeGraphLiteral(literal));
    }

    public static Resource makeResource(ATermAppl term, Model model) {
        return (Resource)model.asRDFNode(JenaUtils.makeGraphResource(term));
    }

    public static RDFNode makeRDFNode(ATermAppl term, Model model) {
        return model.asRDFNode(JenaUtils.makeGraphNode(term));
    }

    public static QNameProvider makeQNameProvider(PrefixMapping mapping) {
        QNameProvider qnames = new QNameProvider();
        for (Map.Entry entry : mapping.getNsPrefixMap().entrySet()) {
            String prefix = (String)entry.getKey();
            String uri = (String)entry.getValue();
            qnames.setMapping(prefix, uri);
        }
        return qnames;
    }
}

