/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.jena.vocabulary.OWL2;
import org.mindswap.pellet.output.ATermManchesterSyntaxRenderer;
import org.mindswap.pellet.output.ATermRenderer;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.QNameProvider;

public class NodeFormatter {
    private QNameProvider qnames;
    private StringWriter sw;
    private ATermRenderer renderer;
    private PrintWriter formatter;
    private Model rawModel;
    private static final Resource NULL = null;

    public NodeFormatter(Model model) {
        if (model == null) {
            throw new NullPointerException("No model given!");
        }
        this.renderer = new ATermManchesterSyntaxRenderer();
        this.sw = new StringWriter();
        this.formatter = new PrintWriter(this.sw);
        this.renderer.setWriter(this.formatter);
        this.qnames = JenaUtils.makeQNameProvider((PrefixMapping)model);
        if (model instanceof InfModel) {
            InfGraph graph = (InfGraph)model.getGraph();
            this.rawModel = ModelFactory.createModelForGraph((Graph)graph.getRawGraph());
        } else {
            this.rawModel = model;
        }
    }

    public QNameProvider getQNames() {
        return this.qnames;
    }

    public String format(RDFNode node) {
        if (node == null) {
            return "<<null>>";
        }
        this.sw.getBuffer().setLength(0);
        ATerm term = this.node2term(node);
        if (term instanceof ATermAppl) {
            this.renderer.visit((ATermAppl)term);
        } else {
            this.sw.write("{");
            this.renderer.visitList((ATermList)term);
            this.sw.write("}");
        }
        return this.sw.toString();
    }

    public ATerm node2term(RDFNode node) {
        ATermAppl aTerm = null;
        if (node.equals(OWL.Thing)) {
            return ATermUtils.TOP;
        }
        if (node.equals(OWL.Nothing)) {
            return ATermUtils.BOTTOM;
        }
        if (node.equals(OWL2.topDataProperty)) {
            return ATermUtils.TOP_DATA_PROPERTY;
        }
        if (node.equals(OWL2.bottomDataProperty)) {
            return ATermUtils.BOTTOM_DATA_PROPERTY;
        }
        if (node.equals(OWL2.topObjectProperty)) {
            return ATermUtils.TOP_OBJECT_PROPERTY;
        }
        if (node.equals(OWL2.bottomObjectProperty)) {
            return ATermUtils.BOTTOM_OBJECT_PROPERTY;
        }
        if (node instanceof Literal) {
            Literal l = (Literal)node;
            String datatypeURI = l.getDatatypeURI();
            aTerm = datatypeURI != null ? ATermUtils.makeTypedLiteral(l.getString(), datatypeURI) : ATermUtils.makePlainLiteral(l.getString(), l.getLanguage());
        } else if (node instanceof Resource) {
            Resource r = (Resource)node;
            if (this.rawModel.contains(r, OWL.onProperty, (RDFNode)NULL)) {
                aTerm = this.createRestriction(r);
            } else if (r.isAnon()) {
                if (this.rawModel.contains(r, RDF.first, (RDFNode)NULL)) {
                    aTerm = this.createList(r);
                } else if (this.rawModel.contains(r, OWL.intersectionOf)) {
                    ATermList list = this.createList(this.rawModel.getProperty(r, OWL.intersectionOf).getResource());
                    aTerm = ATermUtils.makeAnd(list);
                } else if (this.rawModel.contains(r, OWL.unionOf)) {
                    ATermList list = this.createList(this.rawModel.getProperty(r, OWL.unionOf).getResource());
                    aTerm = ATermUtils.makeOr(list);
                } else if (this.rawModel.contains(r, OWL.oneOf)) {
                    ATermList list = this.createList(this.rawModel.getProperty(r, OWL.oneOf).getResource());
                    ATermList result = ATermUtils.EMPTY_LIST;
                    ATermList l = list;
                    while (!l.isEmpty()) {
                        ATermAppl c = (ATermAppl)l.getFirst();
                        ATermAppl nominal = ATermUtils.makeValue((ATerm)c);
                        result = result.insert((ATerm)nominal);
                        l = l.getNext();
                    }
                    aTerm = ATermUtils.makeOr(result);
                } else if (this.rawModel.contains(r, OWL.complementOf)) {
                    ATerm complement = this.node2term((RDFNode)this.rawModel.getProperty(r, OWL.complementOf).getResource());
                    aTerm = ATermUtils.makeNot(complement);
                } else {
                    aTerm = ATermUtils.makeBnode(r.getId().toString());
                }
            } else {
                aTerm = ATermUtils.makeTermAppl(r.getURI());
            }
        }
        return aTerm;
    }

    private ATermAppl createRestriction(Resource s) {
        ATermAppl aTerm = ATermUtils.BOTTOM;
        Statement stmt = this.rawModel.getProperty(s, OWL.onProperty);
        Resource p = stmt.getResource();
        ATerm pt = this.node2term((RDFNode)p);
        if (s.hasProperty(OWL.hasValue)) {
            stmt = this.rawModel.getProperty(s, OWL.hasValue);
            RDFNode o = stmt.getObject();
            ATerm ot = this.node2term(o);
            aTerm = ATermUtils.makeHasValue(pt, ot);
        } else if (s.hasProperty(OWL.allValuesFrom)) {
            stmt = this.rawModel.getProperty(s, OWL.allValuesFrom);
            Resource o = stmt.getResource();
            ATerm ot = this.node2term((RDFNode)o);
            aTerm = ATermUtils.makeAllValues(pt, ot);
        } else if (s.hasProperty(OWL.someValuesFrom)) {
            stmt = this.rawModel.getProperty(s, OWL.someValuesFrom);
            Resource o = stmt.getResource();
            ATerm ot = this.node2term((RDFNode)o);
            aTerm = ATermUtils.makeSomeValues(pt, ot);
        } else if (s.hasProperty(OWL.minCardinality)) {
            stmt = this.rawModel.getProperty(s, OWL.minCardinality);
            int cardinality = 0;
            try {
                cardinality = stmt.getInt();
            }
            catch (Exception ex) {
                cardinality = Integer.parseInt(stmt.getLiteral().getLexicalForm());
            }
            aTerm = ATermUtils.makeDisplayMin(pt, cardinality, (ATerm)ATermUtils.EMPTY);
        } else if (s.hasProperty(OWL.maxCardinality)) {
            stmt = this.rawModel.getProperty(s, OWL.maxCardinality);
            int cardinality = 0;
            try {
                cardinality = stmt.getInt();
            }
            catch (Exception ex) {
                cardinality = Integer.parseInt(stmt.getLiteral().getLexicalForm());
            }
            aTerm = ATermUtils.makeDisplayMax(pt, cardinality, (ATerm)ATermUtils.EMPTY);
        } else if (s.hasProperty(OWL.cardinality)) {
            stmt = this.rawModel.getProperty(s, OWL.cardinality);
            int cardinality = 0;
            try {
                cardinality = stmt.getInt();
            }
            catch (Exception ex) {
                cardinality = Integer.parseInt(stmt.getLiteral().getLexicalForm());
            }
            aTerm = ATermUtils.makeDisplayCard(pt, cardinality, (ATerm)ATermUtils.EMPTY);
        }
        return aTerm;
    }

    private ATermList createList(Resource r) {
        if (r.equals(RDF.nil)) {
            return ATermUtils.EMPTY_LIST;
        }
        if (!this.rawModel.contains(r, RDF.first)) {
            System.err.println("Invalid list structure: List " + r + " does not have a rdf:first property. Ignoring rest of the list.");
            return ATermUtils.EMPTY_LIST;
        }
        ATerm first = this.node2term(this.rawModel.getProperty(r, RDF.first).getObject());
        Resource rest = this.rawModel.getProperty(r, RDF.rest).getResource();
        return ATermUtils.makeList(first, this.createList(rest));
    }
}

