/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.DatasetImpl;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.ModelUtils;
import com.hp.hpl.jena.util.FileManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.UnsupportedQueryException;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletResultSet;
import org.mindswap.pellet.query.Query;
import org.mindswap.pellet.query.QueryEngine;
import org.mindswap.pellet.query.impl.ARQParser;

public class PelletQueryExecution
implements QueryExecution {
    public static Logger log = Logger.getLogger(PelletQueryExecution.class.getName());
    private com.hp.hpl.jena.query.Query query;
    private Dataset source;
    private boolean purePelletQueryExec = false;

    public PelletQueryExecution(String query, Model source) {
        this(QueryFactory.create((String)query), source);
    }

    public PelletQueryExecution(com.hp.hpl.jena.query.Query query, Model source) {
        this(query, (Dataset)new DatasetImpl(source));
    }

    public PelletQueryExecution(com.hp.hpl.jena.query.Query query, Dataset source) {
        this.query = query;
        this.source = source;
        Graph graph = source.getDefaultModel().getGraph();
        if (!(graph instanceof PelletInfGraph)) {
            throw new QueryException("PelletQueryExecution can only be used with Pellet-backed models");
        }
        if (PelletOptions.FULL_SIZE_ESTIMATE) {
            ((PelletInfGraph)graph).getKB().getSizeEstimate().computeAll();
        }
    }

    public Model execDescribe() {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    public Model execDescribe(Model model) {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    public Model execConstruct() {
        Model model = ModelFactory.createDefaultModel();
        this.execConstruct(model);
        return model;
    }

    public Model execConstruct(Model model) {
        if (!this.query.isConstructType()) {
            throw new QueryExecException("Attempt to get a CONSTRUCT model from a " + PelletQueryExecution.labelForQuery(this.query) + " query");
        }
        try {
            ResultSet results = this.exec();
            model.setNsPrefixes((PrefixMapping)this.source.getDefaultModel());
            model.setNsPrefixes(this.query.getPrefixMapping());
            HashSet set = new HashSet();
            Template template = this.query.getConstructTemplate();
            while (results.hasNext()) {
                HashMap bNodeMap = new HashMap();
                QuerySolution qs = results.nextSolution();
                Binding binding = this.toBinding(qs);
                template.subst(set, bNodeMap, binding);
            }
            for (Triple t : set) {
                Statement stmt = ModelUtils.tripleToStatement((Model)model, (Triple)t);
                if (stmt == null) continue;
                model.add(stmt);
            }
            this.close();
            return model;
        }
        catch (UnsupportedQueryException e) {
            log.log(this.purePelletQueryExec ? Level.INFO : Level.FINE, "This is not an ABox query: " + e.getMessage());
            if (this.purePelletQueryExec) {
                throw e;
            }
            log.fine("Using Jena to answer the query");
            return QueryExecutionFactory.create((com.hp.hpl.jena.query.Query)this.query, (Dataset)this.source).execConstruct();
        }
    }

    public boolean execAsk() {
        if (!this.query.isAskType()) {
            throw new QueryExecException("Attempt to have boolean from a " + PelletQueryExecution.labelForQuery(this.query) + " query");
        }
        try {
            ResultSet results = this.exec();
            return results.hasNext();
        }
        catch (UnsupportedQueryException e) {
            log.log(this.purePelletQueryExec ? Level.INFO : Level.FINE, "This is not an ABox query: " + e.getMessage());
            if (this.purePelletQueryExec) {
                throw e;
            }
            log.fine("Using Jena to answer the query");
            return QueryExecutionFactory.create((com.hp.hpl.jena.query.Query)this.query, (Dataset)this.source).execAsk();
        }
    }

    public ResultSet execSelect() {
        if (!this.query.isSelectType()) {
            throw new QueryExecException("Attempt to have ResultSet from a " + PelletQueryExecution.labelForQuery(this.query) + " query");
        }
        try {
            return this.exec();
        }
        catch (UnsupportedQueryException e) {
            log.log(this.purePelletQueryExec ? Level.INFO : Level.FINE, "This is not an ABox query: " + e.getMessage());
            if (this.purePelletQueryExec) {
                throw e;
            }
            log.fine("Using Jena to answer the query");
            return QueryExecutionFactory.create((com.hp.hpl.jena.query.Query)this.query, (Dataset)this.source).execSelect();
        }
    }

    private ResultSet exec() {
        PelletInfGraph pelletInfGraph = (PelletInfGraph)this.source.getDefaultModel().getGraph();
        pelletInfGraph.prepare();
        KnowledgeBase kb = pelletInfGraph.getKB();
        Model model = this.source.getDefaultModel();
        ARQParser parser = (ARQParser)QueryEngine.createParser();
        Query q = parser.parse(this.query, kb);
        PelletResultSet results = new PelletResultSet(QueryEngine.exec(q), model);
        List sortConditions = this.query.getOrderBy();
        if (sortConditions != null && !sortConditions.isEmpty()) {
            results = ResultSetFactory.makeSorted((ResultSet)results, (List)sortConditions);
        }
        return results;
    }

    public void abort() {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    public void close() {
        log.fine("Closing PelletQueryExecution '" + this.hashCode() + "'.");
    }

    public void setFileManager(FileManager manager) {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    public void setInitialBinding(QuerySolution arg0) {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    public Context getContext() {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    public Dataset getDataset() {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    private static String labelForQuery(com.hp.hpl.jena.query.Query q) {
        if (q.isSelectType()) {
            return "SELECT";
        }
        if (q.isConstructType()) {
            return "CONSTRUCT";
        }
        if (q.isDescribeType()) {
            return "DESCRIBE";
        }
        if (q.isAskType()) {
            return "ASK";
        }
        return "<<unknown>>";
    }

    private Binding toBinding(QuerySolution solution) {
        BindingMap result = new BindingMap();
        Iterator i = solution.varNames();
        while (i.hasNext()) {
            String varName = (String)i.next();
            result.add(Var.alloc((String)varName), solution.get(varName).asNode());
        }
        return result;
    }

    public boolean isPurePelletQueryExec() {
        return this.purePelletQueryExec;
    }

    public void setPurePelletQueryExec(boolean purePelletQueryExec) {
        this.purePelletQueryExec = purePelletQueryExec;
    }
}

