/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.cache;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.cache.CachedNode;
import org.mindswap.pellet.tableau.cache.CachedNodeFactory;
import org.mindswap.pellet.tableau.cache.ConceptCache;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.MultiValueMap;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.fsm.Transition;
import org.mindswap.pellet.utils.fsm.TransitionGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConceptCache
implements ConceptCache {
    public static final Logger log = Logger.getLogger(AbstractConceptCache.class.getName());
    private int maxSize;

    public AbstractConceptCache(int maxSize) {
        this.maxSize = maxSize;
    }

    protected boolean isFull() {
        return this.size() == this.maxSize;
    }

    @Override
    public Bool getSat(ATermAppl c) {
        CachedNode cached = (CachedNode)this.get(c);
        return cached == null ? Bool.UNKNOWN : Bool.create(!cached.isBottom());
    }

    @Override
    public boolean putSat(ATermAppl c, boolean isSatisfiable) {
        CachedNode cached = (CachedNode)this.get(c);
        if (cached != null) {
            if (isSatisfiable != !cached.isBottom()) {
                throw new InternalReasonerException("Caching inconsistent results for " + c);
            }
            return false;
        }
        if (isSatisfiable) {
            this.put(c, CachedNodeFactory.createSatisfiableNode());
        } else {
            ATermAppl notC = ATermUtils.negate(c);
            this.put(c, CachedNodeFactory.createBottomNode());
            this.put(notC, CachedNodeFactory.createTopNode());
        }
        return true;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    private Bool checkTrivialClash(CachedNode node1, CachedNode node2) {
        Bool result = null;
        if (node1.isBottom() || node2.isBottom()) {
            result = Bool.TRUE;
        } else if (node1.isTop() || node2.isTop()) {
            result = Bool.FALSE;
        } else if (!node1.isComplete() || !node2.isComplete()) {
            result = Bool.UNKNOWN;
        }
        return result;
    }

    @Override
    public Bool isMergable(KnowledgeBase kb, CachedNode root1, CachedNode root2) {
        Bool clash;
        DependencySet ds;
        boolean bothNamedIndividuals;
        Bool result = this.checkTrivialClash(root1, root2);
        if (result != null) {
            return result.not();
        }
        CachedNode[] roots = new CachedNode[]{root1, root2};
        boolean isIndependent = root1.isIndependent() && root2.isIndependent();
        int root = roots[0].getDepends().size() < roots[1].getDepends().size() ? 0 : 1;
        int otherRoot = 1 - root;
        for (Map.Entry<ATermAppl, DependencySet> entry : roots[root].getDepends().entrySet()) {
            boolean allIndependent;
            ATermAppl c = entry.getKey();
            ATermAppl notC = ATermUtils.negate(c);
            DependencySet ds2 = roots[otherRoot].getDepends().get(notC);
            if (ds2 == null) continue;
            DependencySet ds1 = entry.getValue();
            boolean bl = allIndependent = isIndependent && ds1.isIndependent() && ds2.isIndependent();
            if (allIndependent) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(roots[root] + " has " + c + " " + roots[otherRoot] + " has negation " + ds1.max() + " " + ds2.max());
                }
                return Bool.FALSE;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(roots[root] + " has " + c + " " + roots[otherRoot] + " has negation " + ds1.max() + " " + ds2.max());
            }
            result = Bool.UNKNOWN;
        }
        if (result != null) {
            return result;
        }
        for (root = 0; root < 2; ++root) {
            otherRoot = 1 - root;
            for (ATermAppl c : roots[root].getDepends().keySet()) {
                if (ATermUtils.isAllValues(c)) {
                    result = this.checkAllValuesClash(kb, c, roots[root], roots[otherRoot]);
                } else if (ATermUtils.isNot(c)) {
                    ATermAppl arg = (ATermAppl)c.getArgument(0);
                    if (ATermUtils.isMin(arg)) {
                        result = this.checkMaxClash(kb, c, roots[root], roots[otherRoot]);
                    } else if (ATermUtils.isSelf(arg)) {
                        result = this.checkSelfClash(kb, arg, roots[root], roots[otherRoot]);
                    }
                }
                if (result == null) continue;
                return result;
            }
        }
        boolean bl = bothNamedIndividuals = root1 instanceof Individual && root2 instanceof Individual;
        if (kb.getExpressivity().hasFunctionality()) {
            root = roots[0].getOutEdges().size() + roots[0].getInEdges().size() < roots[1].getOutEdges().size() + roots[1].getInEdges().size() ? 0 : 1;
            otherRoot = 1 - root;
            result = bothNamedIndividuals ? this.checkFunctionalityClashWithDifferents((Individual)roots[root], (Individual)roots[otherRoot]) : this.checkFunctionalityClash(roots[root], roots[otherRoot]);
            if (result != null) {
                return result;
            }
        }
        if (bothNamedIndividuals && (ds = ((Individual)root1).getDifferenceDependency((Individual)root2)) != null) {
            return ds.isIndependent() ? Bool.FALSE : Bool.UNKNOWN;
        }
        if (kb.getExpressivity().hasDisjointRoles() && (clash = this.checkDisjointPropertyClash(root1, root2)) != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Cannot determine if two named individuals can be merged or not: " + roots[0] + "  + roots[1]");
            }
            return Bool.UNKNOWN;
        }
        return Bool.TRUE;
    }

    private Bool checkAllValuesClash(KnowledgeBase kb, ATermAppl av, CachedNode root, CachedNode otherRoot) {
        Role role;
        ATerm r = av.getArgument(0);
        if (r.getType() == 4) {
            r = ((ATermList)r).getFirst();
        }
        if (!(role = kb.getRole(r)).hasComplexSubRole()) {
            if (otherRoot.hasRNeighbor(role)) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(root + " has " + av + " " + otherRoot + " has " + role + " neighbor");
                }
                return Bool.UNKNOWN;
            }
        } else {
            TransitionGraph<Role> tg = role.getFSM();
            for (Transition<Role> t : tg.getInitialState().getTransitions()) {
                if (!otherRoot.hasRNeighbor(t.getName())) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.fine(root + " has " + av + " " + otherRoot + " has " + t.getName() + " neighbor");
                }
                return Bool.UNKNOWN;
            }
        }
        return null;
    }

    private Bool checkMaxClash(KnowledgeBase kb, ATermAppl mc, CachedNode root, CachedNode otherRoot) {
        int n2;
        ATermAppl maxCard = (ATermAppl)mc.getArgument(0);
        Role maxR = kb.getRole(maxCard.getArgument(0));
        int max = ((ATermInt)maxCard.getArgument(1)).getInt() - 1;
        int n1 = this.getRNeighbors(root, maxR).size();
        if (n1 + (n2 = this.getRNeighbors(otherRoot, maxR).size()) > max) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(root + " has " + mc + " " + otherRoot + " has R-neighbor");
            }
            return Bool.UNKNOWN;
        }
        return null;
    }

    private Bool checkSelfClash(KnowledgeBase kb, ATermAppl self, CachedNode root, CachedNode otherRoot) {
        Role r = kb.getRole(self.getArgument(0));
        for (Edge e : otherRoot.getOutEdges()) {
            if (!e.getRole().isSubRoleOf(r) || !e.getToName().equals(otherRoot.getName())) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine(root + " has not(" + self + ") " + otherRoot + " has self edge");
            }
            boolean allIndependent = root.isIndependent() && otherRoot.isIndependent() && e.getDepends().isIndependent();
            return allIndependent ? Bool.FALSE : Bool.UNKNOWN;
        }
        return null;
    }

    private Bool checkFunctionalityClash(CachedNode root, CachedNode otherRoot) {
        Set<Role> functionalSupers;
        Role role;
        HashSet<Role> checked = new HashSet<Role>();
        for (Edge edge : root.getOutEdges()) {
            role = edge.getRole();
            if (!role.isFunctional()) continue;
            functionalSupers = role.getFunctionalSupers();
            for (Role supRole : functionalSupers) {
                if (checked.contains(supRole)) continue;
                checked.add(supRole);
                if (!otherRoot.hasRNeighbor(supRole)) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.fine(root + " and " + otherRoot + " has " + supRole);
                }
                return Bool.UNKNOWN;
            }
        }
        for (Edge edge : root.getInEdges()) {
            role = edge.getRole().getInverse();
            if (role == null || !role.isFunctional()) continue;
            functionalSupers = role.getFunctionalSupers();
            for (Role supRole : functionalSupers) {
                if (checked.contains(supRole)) continue;
                checked.add(supRole);
                if (!otherRoot.hasRNeighbor(supRole)) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.fine(root + " and " + otherRoot + " has " + supRole);
                }
                return Bool.UNKNOWN;
            }
        }
        return null;
    }

    private Bool checkFunctionalityClashWithDifferents(Individual root, Individual otherRoot) {
        DependencySet ds;
        EdgeList otherEdges;
        Set<Role> functionalSupers;
        Role role;
        Bool result = null;
        for (Edge edge : root.getOutEdges()) {
            role = edge.getRole();
            if (!role.isFunctional()) continue;
            functionalSupers = role.getFunctionalSupers();
            for (Role supRole : functionalSupers) {
                otherEdges = otherRoot.getRNeighborEdges(supRole);
                for (Edge otherEdge : otherEdges) {
                    ds = edge.getTo().getDifferenceDependency(otherEdge.getNeighbor(otherRoot));
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(root + " and " + otherRoot + " has " + supRole + " " + edge + " " + otherEdge);
                    }
                    if (ds != null && ds.isIndependent()) {
                        return Bool.FALSE;
                    }
                    result = Bool.UNKNOWN;
                }
            }
        }
        for (Edge edge : root.getInEdges()) {
            role = edge.getRole().getInverse();
            if (role == null || !role.isFunctional()) continue;
            functionalSupers = role.getFunctionalSupers();
            for (Role supRole : functionalSupers) {
                otherEdges = otherRoot.getRNeighborEdges(supRole);
                for (Edge otherEdge : otherEdges) {
                    ds = edge.getTo().getDifferenceDependency(otherEdge.getNeighbor(otherRoot));
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(root + " and " + otherRoot + " has " + supRole + " " + edge + " " + otherEdge);
                    }
                    if (ds != null && ds.isIndependent()) {
                        return Bool.FALSE;
                    }
                    result = Bool.UNKNOWN;
                }
            }
        }
        return result;
    }

    private MultiValueMap<ATermAppl, Role> collectNeighbors(CachedNode ind) {
        ATermAppl neighbor;
        Role role;
        MultiValueMap<ATermAppl, Role> neighbors = new MultiValueMap<ATermAppl, Role>();
        for (Edge edge : ind.getInEdges()) {
            role = edge.getRole();
            neighbor = edge.getFromName();
            if (ATermUtils.isBnode(neighbor)) continue;
            neighbors.put((Object)neighbor, (Object)role);
        }
        for (Edge edge : ind.getOutEdges()) {
            role = edge.getRole();
            neighbor = edge.getToName();
            if (!role.isObjectRole() || ATermUtils.isBnode(neighbor)) continue;
            neighbors.put((Object)neighbor, (Object)role.getInverse());
        }
        return neighbors;
    }

    private boolean checkDisjointProperties(Set<Role> roles1, Set<Role> roles2) {
        HashSet<Role> allDisjoints = new HashSet<Role>();
        for (Role role : roles1) {
            allDisjoints.addAll(role.getDisjointRoles());
        }
        return SetUtils.intersects(allDisjoints, roles2);
    }

    private Bool checkDisjointPropertyClash(CachedNode root1, CachedNode root2) {
        MultiValueMap<ATermAppl, Role> neighbors1 = this.collectNeighbors(root1);
        if (neighbors1.isEmpty()) {
            return null;
        }
        MultiValueMap<ATermAppl, Role> neighbors2 = this.collectNeighbors(root2);
        if (neighbors2.isEmpty()) {
            return null;
        }
        for (Map.Entry e : neighbors1.entrySet()) {
            ATermAppl commonNeighbor = (ATermAppl)e.getKey();
            Set roles1 = (Set)e.getValue();
            Set roles2 = (Set)neighbors2.get(commonNeighbor);
            if (roles2 == null || !this.checkDisjointProperties(roles1, roles2)) continue;
            return Bool.UNKNOWN;
        }
        return null;
    }

    @Override
    public Bool checkNominalEdges(KnowledgeBase kb, CachedNode pNode, CachedNode cNode) {
        Bool result = Bool.UNKNOWN;
        if (pNode.isComplete() && cNode.isComplete() && cNode.isIndependent() && (result = this.checkNominalEdges(kb, pNode, cNode, false)).isUnknown()) {
            result = this.checkNominalEdges(kb, pNode, cNode, true);
        }
        return result;
    }

    private Bool checkNominalEdges(KnowledgeBase kb, CachedNode pNode, CachedNode cNode, boolean checkInverses) {
        EdgeList edges = checkInverses ? cNode.getInEdges() : cNode.getOutEdges();
        for (Edge edge : edges) {
            ATermAppl val;
            Role role = checkInverses ? edge.getRole().getInverse() : edge.getRole();
            DependencySet ds = edge.getDepends();
            if (!ds.isIndependent()) continue;
            boolean found = false;
            ATermAppl aTermAppl = val = checkInverses ? edge.getFromName() : edge.getToName();
            if (!role.isObjectRole()) {
                found = pNode.hasRNeighbor(role);
            } else if (!this.isRootNominal(kb, val)) {
                if (!role.hasComplexSubRole()) {
                    found = pNode.hasRNeighbor(role);
                } else {
                    TransitionGraph<Role> tg = role.getFSM();
                    Iterator<Transition<Role>> it = tg.getInitialState().getTransitions().iterator();
                    while (!found && it.hasNext()) {
                        Transition<Role> tr = it.next();
                        found = pNode.hasRNeighbor(tr.getName());
                    }
                }
            } else {
                Set<ATermAppl> neighbors = null;
                if (role.isSimple() || !(pNode instanceof Individual)) {
                    neighbors = this.getRNeighbors(pNode, role);
                } else {
                    neighbors = new HashSet<ATermAppl>();
                    kb.getABox().getObjectPropertyValues(pNode.getName(), role, neighbors, neighbors, false);
                }
                Individual ind = kb.getABox().getIndividual((ATerm)val).getSame();
                HashSet<ATermAppl> samesAndMaybes = new HashSet<ATermAppl>();
                kb.getABox().getSames(ind, samesAndMaybes, samesAndMaybes);
                found = SetUtils.intersects(samesAndMaybes, neighbors);
            }
            if (found) continue;
            return Bool.FALSE;
        }
        return Bool.UNKNOWN;
    }

    private boolean isRootNominal(KnowledgeBase kb, ATermAppl val) {
        Individual ind = kb.getABox().getIndividual((ATerm)val);
        return ind != null && ind.isRootNominal();
    }

    private Set<ATermAppl> getRNeighbors(CachedNode node, Role role) {
        Role r;
        HashSet<ATermAppl> neighbors = new HashSet<ATermAppl>();
        for (Edge edge : node.getOutEdges()) {
            r = edge.getRole();
            if (!r.isSubRoleOf(role)) continue;
            neighbors.add(edge.getToName());
        }
        if (role.isObjectRole()) {
            role = role.getInverse();
            for (Edge edge : node.getInEdges()) {
                r = edge.getRole();
                if (!r.isSubRoleOf(role)) continue;
                neighbors.add(edge.getFromName());
            }
        }
        return neighbors;
    }
}

