/*
 * Decompiled with CFR 0.152.
 */
package shark;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import shark.AndroidBuildMirror;
import shark.HeapGraph;
import shark.HeapObject;
import shark.MetadataExtractor;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"Lshark/AndroidMetadataExtractor;", "Lshark/MetadataExtractor;", "()V", "extractMetadata", "", "", "graph", "Lshark/HeapGraph;", "readLeakCanaryVersion", "readProcessName", "shark-android"})
public final class AndroidMetadataExtractor
implements MetadataExtractor {
    @NotNull
    public static final AndroidMetadataExtractor INSTANCE;

    @NotNull
    public Map<String, String> extractMetadata(@NotNull HeapGraph graph) {
        Intrinsics.checkParameterIsNotNull((Object)graph, (String)"graph");
        AndroidBuildMirror build = AndroidBuildMirror.Companion.fromHeapGraph(graph);
        String leakCanaryVersion = this.readLeakCanaryVersion(graph);
        String processName = this.readProcessName(graph);
        return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"Build.VERSION.SDK_INT", (Object)String.valueOf(build.getSdkInt())), TuplesKt.to((Object)"Build.MANUFACTURER", (Object)build.getManufacturer()), TuplesKt.to((Object)"LeakCanary version", (Object)leakCanaryVersion), TuplesKt.to((Object)"App process name", (Object)processName)});
    }

    private final String readLeakCanaryVersion(HeapGraph graph) {
        HeapObject.HeapClass versionHolderClass = graph.findClassByName("leakcanary.internal.InternalLeakCanary");
        Object object = versionHolderClass;
        if (object == null || (object = object.get("version")) == null || (object = object.getValue()) == null || (object = object.readAsJavaString()) == null) {
            object = "Unknown";
        }
        return object;
    }

    private final String readProcessName(HeapGraph graph) {
        HeapObject.HeapClass heapClass = graph.findClassByName("android.app.ActivityThread");
        HeapObject.HeapInstance activityThread = heapClass != null && (heapClass = heapClass.get("sCurrentActivityThread")) != null ? heapClass.getValueAsInstance() : null;
        HeapObject.HeapInstance heapInstance = activityThread;
        HeapObject.HeapInstance appBindData = heapInstance != null && (heapInstance = heapInstance.get("android.app.ActivityThread", "mBoundApplication")) != null ? heapInstance.getValueAsInstance() : null;
        HeapObject.HeapInstance heapInstance2 = appBindData;
        HeapObject.HeapInstance appInfo = heapInstance2 != null && (heapInstance2 = heapInstance2.get("android.app.ActivityThread$AppBindData", "appInfo")) != null ? heapInstance2.getValueAsInstance() : null;
        Object object = appInfo;
        if (object == null || (object = object.get("android.content.pm.ApplicationInfo", "processName")) == null || (object = object.getValueAsInstance()) == null || (object = object.readAsJavaString()) == null) {
            object = "Unknown";
        }
        return object;
    }

    private AndroidMetadataExtractor() {
    }

    static {
        AndroidMetadataExtractor androidMetadataExtractor;
        INSTANCE = androidMetadataExtractor = new AndroidMetadataExtractor();
    }
}

