/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.doxia.module.latex;

import java.io.Writer;
import org.codehaus.doxia.sink.SinkAdapter;
import org.codehaus.doxia.util.LineBreaker;

public class LatexSink
extends SinkAdapter {
    private LineBreaker out;
    private String preamble;
    private boolean titleFlag;
    private int numberedListNesting;
    private boolean verbatimFlag;
    private boolean boxFlag;
    private boolean figureFlag;
    private boolean tableFlag;
    private boolean gridFlag;
    private int[] cellJustif;
    private int cellCount;
    private static final String defaultPreamble = "\\newcommand{\\ptitle}[1]{\\title{#1}}\n\\newcommand{\\pauthor}[1]{\\author{#1}}\n\\newcommand{\\pdate}[1]{\\date{#1}}\n\\newcommand{\\pmaketitle}{\\maketitle}\n\\newcommand{\\psectioni}[1]{\\section{#1}}\n\\newcommand{\\psectionii}[1]{\\subsection{#1}}\n\\newcommand{\\psectioniii}[1]{\\subsubsection{#1}}\n\\newcommand{\\psectioniv}[1]{\\paragraph{#1}}\n\\newcommand{\\psectionv}[1]{\\subparagraph{#1}}\n\\newenvironment{plist}{\\begin{itemize}}{\\end{itemize}}\n\\newenvironment{pnumberedlist}{\\begin{enumerate}}{\\end{enumerate}}\n\\newcommand{\\pdef}[1]{\\textbf{#1}\\hfill}\n\\newenvironment{pdefinitionlist}\n{\\begin{list}{}{\\settowidth{\\labelwidth}{\\textbf{999.}}\n                \\setlength{\\leftmargin}{\\labelwidth}\n                \\addtolength{\\leftmargin}{\\labelsep}\n                \\renewcommand{\\makelabel}{\\pdef}}}\n{\\end{list}}\n\\newenvironment{pfigure}{\\begin{center}}{\\end{center}}\n\\newcommand{\\pfiguregraphics}[1]{\\includegraphics{#1.eps}}\n\\newcommand{\\pfigurecaption}[1]{\\\\ \\vspace{\\pparskipamount}\n                                \\textit{#1}}\n\\newenvironment{ptable}{\\begin{center}}{\\end{center}}\n\\newenvironment{ptablerows}[1]{\\begin{tabular}{#1}}{\\end{tabular}}\n\\newenvironment{pcell}[1]{\\begin{tabular}[t]{#1}}{\\end{tabular}}\n\\newcommand{\\ptablecaption}[1]{\\\\ \\vspace{\\pparskipamount}\n                               \\textit{#1}}\n\\newenvironment{pverbatim}{\\begin{small}}{\\end{small}}\n\\newsavebox{\\pbox}\n\\newenvironment{pverbatimbox}\n{\\begin{lrbox}{\\pbox}\\begin{minipage}{\\linewidth}\\begin{small}}\n{\\end{small}\\end{minipage}\\end{lrbox}\\fbox{\\usebox{\\pbox}}}\n\\newcommand{\\phorizontalrule}{\\begin{center}\n                              \\rule[0.5ex]{\\linewidth}{1pt}\n                              \\end{center}}\n\\newcommand{\\panchor}[1]{\\textcolor{panchorcolor}{#1}}\n\\newcommand{\\plink}[1]{\\textcolor{plinkcolor}{#1}}\n\\newcommand{\\pitalic}[1]{\\textit{#1}}\n\\newcommand{\\pbold}[1]{\\textbf{#1}}\n\\newcommand{\\pmonospaced}[1]{\\texttt{\\small #1}}\n\n\\documentclass[a4paper]{article}\n\\usepackage{a4wide}\n\\usepackage{color}\n\\usepackage{graphics}\n\\usepackage{times}\n\\usepackage[latin1]{inputenc}\n\\usepackage[T1]{fontenc}\n\n\\pagestyle{plain}\n\n\\definecolor{plinkcolor}{rgb}{0,0,0.54}\n\\definecolor{panchorcolor}{rgb}{0.54,0,0}\n\n\\newlength{\\pparskipamount}\n\\setlength{\\pparskipamount}{1ex}\n\\setlength{\\parindent}{0pt}\n\\setlength{\\parskip}{\\pparskipamount}\n\n";

    public LatexSink(Writer out) {
        this(out, defaultPreamble);
    }

    public LatexSink(Writer out, String preamble) {
        this.out = new LineBreaker(out);
        this.setPreamble(preamble);
    }

    public void setPreamble(String preamble) {
        this.preamble = preamble;
    }

    public String getPreamble() {
        return this.preamble;
    }

    public void head() {
        this.titleFlag = false;
        this.numberedListNesting = 0;
        this.verbatimFlag = false;
        this.boxFlag = false;
        this.figureFlag = false;
        this.tableFlag = false;
        this.gridFlag = false;
        this.cellJustif = null;
        this.cellCount = 0;
        this.markup(this.preamble);
        this.markup("\\begin{document}\n\n");
    }

    public void body() {
        if (this.titleFlag) {
            this.titleFlag = false;
            this.markup("\\pmaketitle\n\n");
        }
    }

    public void body_() {
        this.markup("\\end{document}\n\n");
        this.out.flush();
    }

    public void section1() {
        this.markup("\\psectioni{");
    }

    public void section2() {
        this.markup("\\psectionii{");
    }

    public void section3() {
        this.markup("\\psectioniii{");
    }

    public void section4() {
        this.markup("\\psectioniv{");
    }

    public void section5() {
        this.markup("\\psectionv{");
    }

    public void list() {
        this.markup("\\begin{plist}\n\n");
    }

    public void list_() {
        this.markup("\\end{plist}\n\n");
    }

    public void listItem() {
        this.markup("\\item{} ");
    }

    public void numberedList(int numbering) {
        String style;
        String counter;
        ++this.numberedListNesting;
        switch (this.numberedListNesting) {
            case 1: {
                counter = "enumi";
                break;
            }
            case 2: {
                counter = "enumii";
                break;
            }
            case 3: {
                counter = "enumiii";
                break;
            }
            default: {
                counter = "enumiv";
            }
        }
        switch (numbering) {
            case 2: {
                style = "Alph";
                break;
            }
            case 1: {
                style = "alph";
                break;
            }
            case 4: {
                style = "Roman";
                break;
            }
            case 3: {
                style = "roman";
                break;
            }
            default: {
                style = "arabic";
            }
        }
        this.markup("\\begin{pnumberedlist}\n");
        this.markup("\\renewcommand{\\the" + counter + "}{\\" + style + "{" + counter + "}}\n\n");
    }

    public void numberedList_() {
        this.markup("\\end{pnumberedlist}\n\n");
        --this.numberedListNesting;
    }

    public void numberedListItem() {
        this.markup("\\item{} ");
    }

    public void definitionList() {
        this.markup("\\begin{pdefinitionlist}\n\n");
    }

    public void definitionList_() {
        this.markup("\\end{pdefinitionlist}\n\n");
    }

    public void figure() {
        this.figureFlag = true;
        this.markup("\\begin{pfigure}\n");
    }

    public void figure_() {
        this.markup("\\end{pfigure}\n\n");
        this.figureFlag = false;
    }

    public void table() {
        this.tableFlag = true;
        this.markup("\\begin{ptable}\n");
    }

    public void table_() {
        this.markup("\\end{ptable}\n\n");
        this.tableFlag = false;
    }

    public void tableRows(int[] justification, boolean grid) {
        StringBuffer justif = new StringBuffer();
        block5: for (int i = 0; i < justification.length; ++i) {
            if (grid) {
                justif.append('|');
            }
            switch (justification[i]) {
                case 0: {
                    justif.append('c');
                    continue block5;
                }
                case 1: {
                    justif.append('l');
                    continue block5;
                }
                case 2: {
                    justif.append('r');
                }
            }
        }
        if (grid) {
            justif.append('|');
        }
        this.markup("\\begin{ptablerows}{" + justif.toString() + "}\n");
        if (grid) {
            this.markup("\\hline\n");
        }
        this.gridFlag = grid;
        this.cellJustif = justification;
    }

    public void tableRows_() {
        this.markup("\\end{ptablerows}\n");
        this.gridFlag = false;
        this.cellJustif = null;
    }

    public void tableRow() {
        this.cellCount = 0;
    }

    public void tableRow_() {
        this.markup("\\\\\n");
        if (this.gridFlag) {
            this.markup("\\hline\n");
        }
        this.cellCount = 0;
    }

    public void title() {
        this.titleFlag = true;
        this.markup("\\ptitle{");
    }

    public void title_() {
        this.markup("}\n");
    }

    public void author() {
        this.markup("\\pauthor{");
    }

    public void author_() {
        this.markup("}\n");
    }

    public void date() {
        this.markup("\\pdate{");
    }

    public void date_() {
        this.markup("}\n");
    }

    public void sectionTitle_() {
        this.markup("}\n\n");
    }

    public void paragraph_() {
        this.markup("\n\n");
    }

    public void verbatim(boolean boxed) {
        if (boxed) {
            this.markup("\\begin{pverbatimbox}\n");
        } else {
            this.markup("\\begin{pverbatim}\n");
        }
        this.markup("\\begin{verbatim}\n");
        this.verbatimFlag = true;
        this.boxFlag = boxed;
    }

    public void verbatim_() {
        this.markup("\n\\end{verbatim}\n");
        if (this.boxFlag) {
            this.markup("\\end{pverbatimbox}\n\n");
        } else {
            this.markup("\\end{pverbatim}\n\n");
        }
        this.verbatimFlag = false;
        this.boxFlag = false;
    }

    public void definedTerm() {
        this.markup("\\item[\\mbox{");
    }

    public void definedTerm_() {
        this.markup("}] ");
    }

    public void figureCaption() {
        this.markup("\\pfigurecaption{");
    }

    public void figureCaption_() {
        this.markup("}\n");
    }

    public void tableCell() {
        char justif;
        if (this.cellCount > 0) {
            this.markup(" &\n");
        }
        switch (this.cellJustif[this.cellCount]) {
            case 1: {
                justif = 'l';
                break;
            }
            case 2: {
                justif = 'r';
                break;
            }
            default: {
                justif = 'c';
            }
        }
        this.markup("\\begin{pcell}{" + justif + "}");
    }

    public void tableCell_() {
        this.markup("\\end{pcell}");
        ++this.cellCount;
    }

    public void tableCaption() {
        this.markup("\\ptablecaption{");
    }

    public void tableCaption_() {
        this.markup("}\n");
    }

    public void figureGraphics(String name) {
        this.markup("\\pfiguregraphics{" + name + "}\n");
    }

    public void horizontalRule() {
        this.markup("\\phorizontalrule\n\n");
    }

    public void pageBreak() {
        this.markup("\\newpage\n\n");
    }

    public void anchor(String name) {
        this.markup("\\panchor{");
    }

    public void anchor_() {
        this.markup("}");
    }

    public void link(String name) {
        this.markup("\\plink{");
    }

    public void link_() {
        this.markup("}");
    }

    public void italic() {
        this.markup("\\pitalic{");
    }

    public void italic_() {
        this.markup("}");
    }

    public void bold() {
        this.markup("\\pbold{");
    }

    public void bold_() {
        this.markup("}");
    }

    public void monospaced() {
        this.markup("\\pmonospaced{");
    }

    public void monospaced_() {
        this.markup("}");
    }

    public void lineBreak() {
        this.markup(this.figureFlag || this.tableFlag || this.titleFlag ? "\\\\\n" : "\\newline\n");
    }

    public void nonBreakingSpace() {
        this.markup("~");
    }

    public void text(String text) {
        if (this.verbatimFlag) {
            this.verbatimContent(text);
        } else {
            this.content(text);
        }
    }

    protected void markup(String text) {
        this.out.write(text, true);
    }

    protected void content(String text) {
        this.out.write(LatexSink.escaped(text), false);
    }

    protected void verbatimContent(String text) {
        this.out.write(text, true);
    }

    protected static String escaped(String text) {
        int length = text.length();
        StringBuffer buffer = new StringBuffer(length);
        block14: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '-': 
                case '<': 
                case '>': {
                    buffer.append("\\symbol{" + c + "}");
                    continue block14;
                }
                case '~': {
                    buffer.append("\\textasciitilde ");
                    continue block14;
                }
                case '^': {
                    buffer.append("\\textasciicircum ");
                    continue block14;
                }
                case '|': {
                    buffer.append("\\textbar ");
                    continue block14;
                }
                case '\\': {
                    buffer.append("\\textbackslash ");
                    continue block14;
                }
                case '$': {
                    buffer.append("\\$");
                    continue block14;
                }
                case '&': {
                    buffer.append("\\&");
                    continue block14;
                }
                case '%': {
                    buffer.append("\\%");
                    continue block14;
                }
                case '#': {
                    buffer.append("\\#");
                    continue block14;
                }
                case '{': {
                    buffer.append("\\{");
                    continue block14;
                }
                case '}': {
                    buffer.append("\\}");
                    continue block14;
                }
                case '_': {
                    buffer.append("\\_");
                    continue block14;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    public void flush() {
        this.out.flush();
    }

    public void close() {
        this.out.close();
    }
}

