/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml.metadata;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opensaml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.provider.ChainingMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataFilter;
import org.opensaml.saml2.metadata.provider.MetadataFilterChain;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.saml2.metadata.provider.ObservableMetadataProvider;
import org.opensaml.saml2.metadata.provider.SignatureValidationFilter;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.x509.BasicPKIXValidationInformation;
import org.opensaml.xml.security.x509.BasicX509CredentialNameEvaluator;
import org.opensaml.xml.security.x509.CertPathPKIXValidationOptions;
import org.opensaml.xml.security.x509.PKIXTrustEvaluator;
import org.opensaml.xml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.xml.security.x509.PKIXValidationOptions;
import org.opensaml.xml.security.x509.StaticPKIXValidationInformationResolver;
import org.opensaml.xml.security.x509.X509CredentialNameEvaluator;
import org.opensaml.xml.signature.SignatureTrustEngine;
import org.opensaml.xml.signature.impl.PKIXSignatureTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.saml.key.KeyManager;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.ExtendedMetadataDelegate;
import org.springframework.security.saml.metadata.ExtendedMetadataProvider;
import org.springframework.security.saml.trust.AllowAllSignatureTrustEngine;
import org.springframework.security.saml.trust.CertPathPKIXTrustEvaluator;
import org.springframework.security.saml.trust.httpclient.TLSProtocolConfigurer;
import org.springframework.security.saml.util.SAMLUtil;
import org.springframework.util.Assert;

public class MetadataManager
extends ChainingMetadataProvider
implements ExtendedMetadataProvider,
InitializingBean,
DisposableBean {
    protected final Logger log = LoggerFactory.getLogger(MetadataManager.class);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock refreshLock = new ReentrantReadWriteLock();
    private String hostedSPName;
    private String defaultIDP;
    private ExtendedMetadata defaultExtendedMetadata;
    private Timer timer;
    private long refreshCheckInterval = 10000L;
    private boolean refreshRequired = true;
    protected KeyManager keyManager;
    private List<ExtendedMetadataDelegate> availableProviders;
    private Set<String> idpName = new HashSet<String>();
    private Set<String> spName = new HashSet<String>();
    private Set<String> aliasSet;

    public MetadataManager(List<MetadataProvider> providers) throws MetadataProviderException {
        this.defaultExtendedMetadata = new ExtendedMetadata();
        this.availableProviders = new LinkedList<ExtendedMetadataDelegate>();
        this.setProviders(providers);
        this.getObservers().add(new MetadataProviderObserver());
    }

    public final void afterPropertiesSet() throws MetadataProviderException {
        Assert.notNull((Object)this.keyManager, (String)"KeyManager must be set");
        if (this.refreshCheckInterval > 0L) {
            this.log.debug("Creating metadata reload timer with interval {}", (Object)this.refreshCheckInterval);
            this.timer = new Timer("Metadata-reload", true);
            this.timer.schedule((TimerTask)new RefreshTask(), this.refreshCheckInterval, this.refreshCheckInterval);
        } else {
            this.log.debug("Metadata reload timer is not created, refreshCheckInternal is {}", (Object)this.refreshCheckInterval);
        }
        this.refreshMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.refreshLock.writeLock().lock();
            this.lock.writeLock().lock();
            for (MetadataProvider provider : this.getProviders()) {
                if (!(provider instanceof ExtendedMetadataDelegate)) continue;
                ((ExtendedMetadataDelegate)provider).destroy();
            }
            super.destroy();
            if (this.timer != null) {
                this.timer.cancel();
                this.timer.purge();
                this.timer = null;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.setRefreshRequired(false);
        }
        finally {
            this.lock.writeLock().unlock();
            this.refreshLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProviders(List<MetadataProvider> newProviders) throws MetadataProviderException {
        try {
            this.lock.writeLock().lock();
            this.availableProviders.clear();
            if (newProviders != null) {
                for (MetadataProvider provider : newProviders) {
                    this.addMetadataProvider(provider);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.setRefreshRequired(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshMetadata() {
        try {
            this.refreshLock.writeLock().lock();
            if (!this.isRefreshRequired()) {
                this.log.debug("Refresh is not required, isRefreshRequired flag isn't set");
                return;
            }
            this.log.debug("Reloading metadata");
            try {
                this.lock.writeLock().lock();
                super.setProviders(Collections.emptyList());
                this.idpName = new HashSet<String>();
                this.spName = new HashSet<String>();
                this.aliasSet = new HashSet<String>();
                for (ExtendedMetadataDelegate provider : this.availableProviders) {
                    try {
                        this.log.debug("Refreshing metadata provider {}", (Object)provider.toString());
                        this.initializeProviderFilters(provider);
                        this.initializeProvider(provider);
                        this.initializeProviderData(provider);
                        super.addMetadataProvider((MetadataProvider)provider);
                        this.log.debug("Metadata provider was initialized {}", (Object)provider.toString());
                    }
                    catch (MetadataProviderException e) {
                        this.log.error("Initialization of metadata provider " + provider + " failed, provider will be ignored", (Throwable)e);
                    }
                }
                this.setRefreshRequired(false);
                this.log.debug("Reloading metadata was finished");
            }
            catch (MetadataProviderException e) {
                throw new RuntimeException("Error clearing existing providers");
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        finally {
            this.refreshLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMetadataProvider(MetadataProvider newProvider) throws MetadataProviderException {
        if (newProvider == null) {
            throw new IllegalArgumentException("Null provider can't be added");
        }
        try {
            this.lock.writeLock().lock();
            ExtendedMetadataDelegate wrappedProvider = this.getWrappedProvider(newProvider);
            this.availableProviders.add(wrappedProvider);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.setRefreshRequired(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetadataProvider(MetadataProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Null provider can't be removed");
        }
        try {
            this.lock.writeLock().lock();
            ExtendedMetadataDelegate wrappedProvider = this.getWrappedProvider(provider);
            this.availableProviders.remove(wrappedProvider);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.setRefreshRequired(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MetadataProvider> getProviders() {
        try {
            this.lock.readLock().lock();
            ArrayList<MetadataProvider> arrayList = new ArrayList<MetadataProvider>(super.getProviders());
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExtendedMetadataDelegate> getAvailableProviders() {
        try {
            this.lock.readLock().lock();
            ArrayList<ExtendedMetadataDelegate> arrayList = new ArrayList<ExtendedMetadataDelegate>(this.availableProviders);
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private ExtendedMetadataDelegate getWrappedProvider(MetadataProvider provider) {
        if (!(provider instanceof ExtendedMetadataDelegate)) {
            this.log.debug("Wrapping metadata provider {} with extendedMetadataDelegate", (Object)provider);
            return new ExtendedMetadataDelegate(provider);
        }
        return (ExtendedMetadataDelegate)provider;
    }

    protected void initializeProvider(ExtendedMetadataDelegate provider) throws MetadataProviderException {
        this.log.debug("Initializing extendedMetadataDelegate {}", (Object)provider);
        provider.initialize();
    }

    protected void initializeProviderData(ExtendedMetadataDelegate provider) throws MetadataProviderException {
        this.log.debug("Initializing provider data {}", (Object)provider);
        List<String> stringSet = this.parseProvider((MetadataProvider)provider);
        for (String key : stringSet) {
            ExtendedMetadata extendedMetadata;
            RoleDescriptor spRoleDescriptor;
            RoleDescriptor idpRoleDescriptor = provider.getRole(key, IDPSSODescriptor.DEFAULT_ELEMENT_NAME, "urn:oasis:names:tc:SAML:2.0:protocol");
            if (idpRoleDescriptor != null) {
                if (this.idpName.contains(key)) {
                    this.log.warn("Provider {} contains entity {} with IDP which was already contained in another metadata provider and will be ignored", (Object)provider, (Object)key);
                } else {
                    this.idpName.add(key);
                }
            }
            if ((spRoleDescriptor = provider.getRole(key, SPSSODescriptor.DEFAULT_ELEMENT_NAME, "urn:oasis:names:tc:SAML:2.0:protocol")) != null) {
                if (this.spName.contains(key)) {
                    this.log.warn("Provider {} contains entity {} which was already included in another metadata provider and will be ignored", (Object)provider, (Object)key);
                } else {
                    this.spName.add(key);
                }
            }
            if ((extendedMetadata = this.getExtendedMetadata(key, (MetadataProvider)provider)) != null) {
                if (extendedMetadata.isLocal()) {
                    String alias = extendedMetadata.getAlias();
                    if (alias != null) {
                        SAMLUtil.verifyAlias(alias, key);
                        if (this.aliasSet.contains(alias)) {
                            this.log.warn("Provider {} contains alias {} which is not unique and will be ignored", (Object)provider, (Object)alias);
                        } else {
                            this.aliasSet.add(alias);
                            this.log.debug("Local entity {} available under alias {}", (Object)key, (Object)alias);
                        }
                    } else {
                        this.log.debug("Local entity {} doesn't have an alias", (Object)key);
                    }
                    if (spRoleDescriptor == null || this.getHostedSPName() != null) continue;
                    this.setHostedSPName(key);
                    continue;
                }
                this.log.debug("Remote entity {} available", (Object)key);
                continue;
            }
            this.log.debug("No extended metadata available for entity {}", (Object)key);
        }
    }

    protected void initializeProviderFilters(ExtendedMetadataDelegate provider) throws MetadataProviderException {
        if (provider.isTrustFiltersInitialized()) {
            this.log.debug("Metadata provider was already initialized, signature filter initialization will be skipped");
        } else {
            boolean requireSignature = provider.isMetadataRequireSignature();
            SignatureTrustEngine trustEngine = this.getTrustEngine((MetadataProvider)provider);
            SignatureValidationFilter filter = new SignatureValidationFilter(trustEngine);
            filter.setRequireSignature(requireSignature);
            this.log.debug("Created new trust manager for metadata provider {}", (Object)provider);
            MetadataFilter currentFilter = provider.getMetadataFilter();
            if (currentFilter != null) {
                if (currentFilter instanceof MetadataFilterChain) {
                    this.log.debug("Adding signature filter into existing chain");
                    MetadataFilterChain chain = (MetadataFilterChain)currentFilter;
                    chain.getFilters().add(filter);
                } else {
                    this.log.debug("Combining signature filter with the existing in a new chain");
                    MetadataFilterChain chain = new MetadataFilterChain();
                    chain.getFilters().add(currentFilter);
                    chain.getFilters().add(filter);
                }
            } else {
                this.log.debug("Adding signature filter");
                provider.setMetadataFilter((MetadataFilter)filter);
            }
            provider.setTrustFiltersInitialized(true);
        }
    }

    protected SignatureTrustEngine getTrustEngine(MetadataProvider provider) {
        Set<String> trustedKeys = null;
        boolean verifyTrust = true;
        boolean forceRevocationCheck = false;
        if (provider instanceof ExtendedMetadataDelegate) {
            ExtendedMetadataDelegate metadata = (ExtendedMetadataDelegate)provider;
            trustedKeys = metadata.getMetadataTrustedKeys();
            verifyTrust = metadata.isMetadataTrustCheck();
            forceRevocationCheck = metadata.isForceMetadataRevocationCheck();
        }
        if (verifyTrust) {
            this.log.debug("Setting trust verification for metadata provider {}", (Object)provider);
            CertPathPKIXValidationOptions pkixOptions = new CertPathPKIXValidationOptions();
            if (forceRevocationCheck) {
                this.log.debug("Revocation checking forced to true");
                pkixOptions.setForceRevocationEnabled(true);
            } else {
                this.log.debug("Revocation checking not forced");
                pkixOptions.setForceRevocationEnabled(false);
            }
            return new PKIXSignatureTrustEngine(this.getPKIXResolver(provider, trustedKeys, null), Configuration.getGlobalSecurityConfiguration().getDefaultKeyInfoCredentialResolver(), (PKIXTrustEvaluator)new CertPathPKIXTrustEvaluator((PKIXValidationOptions)pkixOptions), (X509CredentialNameEvaluator)new BasicX509CredentialNameEvaluator());
        }
        this.log.debug("Trust verification skipped for metadata provider {}", (Object)provider);
        return new AllowAllSignatureTrustEngine(Configuration.getGlobalSecurityConfiguration().getDefaultKeyInfoCredentialResolver());
    }

    protected PKIXValidationInformationResolver getPKIXResolver(MetadataProvider provider, Set<String> trustedKeys, Set<String> trustedNames) {
        if (trustedKeys == null) {
            trustedKeys = this.keyManager.getAvailableCredentials();
        }
        LinkedList<X509Certificate> certificates = new LinkedList<X509Certificate>();
        for (String key : trustedKeys) {
            this.log.debug("Adding PKIX trust anchor {} for metadata verification of provider {}", (Object)key, (Object)provider);
            X509Certificate certificate = this.keyManager.getCertificate(key);
            if (certificate != null) {
                certificates.add(certificate);
                continue;
            }
            this.log.warn("Cannot construct PKIX trust anchor for key with alias {} for provider {}, key isn't included in the keystore", (Object)key, (Object)provider);
        }
        LinkedList<BasicPKIXValidationInformation> info = new LinkedList<BasicPKIXValidationInformation>();
        info.add(new BasicPKIXValidationInformation(certificates, null, Integer.valueOf(4)));
        return new StaticPKIXValidationInformationResolver(info, trustedNames);
    }

    protected List<String> parseProvider(MetadataProvider provider) throws MetadataProviderException {
        LinkedList<String> result = new LinkedList<String>();
        XMLObject object = provider.getMetadata();
        if (object instanceof EntityDescriptor) {
            this.addDescriptor(result, (EntityDescriptor)object);
        } else if (object instanceof EntitiesDescriptor) {
            this.addDescriptors(result, (EntitiesDescriptor)object);
        }
        return result;
    }

    private void addDescriptors(List<String> result, EntitiesDescriptor descriptors) throws MetadataProviderException {
        this.log.debug("Found metadata EntitiesDescriptor with ID", (Object)descriptors.getID());
        if (descriptors.getEntitiesDescriptors() != null) {
            for (EntitiesDescriptor descriptor : descriptors.getEntitiesDescriptors()) {
                this.addDescriptors(result, descriptor);
            }
        }
        if (descriptors.getEntityDescriptors() != null) {
            for (EntitiesDescriptor descriptor : descriptors.getEntityDescriptors()) {
                this.addDescriptor(result, (EntityDescriptor)descriptor);
            }
        }
    }

    private void addDescriptor(List<String> result, EntityDescriptor descriptor) throws MetadataProviderException {
        String entityID = descriptor.getEntityID();
        this.log.debug("Found metadata EntityDescriptor with ID", (Object)entityID);
        result.add(entityID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getIDPEntityNames() {
        try {
            this.lock.readLock().lock();
            Set<String> set = Collections.unmodifiableSet(this.idpName);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getSPEntityNames() {
        try {
            this.lock.readLock().lock();
            Set<String> set = Collections.unmodifiableSet(this.spName);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIDPValid(String idpID) {
        try {
            this.lock.readLock().lock();
            boolean bl = this.idpName.contains(idpID);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSPValid(String spID) {
        try {
            this.lock.readLock().lock();
            boolean bl = this.spName.contains(spID);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String getHostedSPName() {
        return this.hostedSPName;
    }

    public void setHostedSPName(String hostedSPName) {
        this.hostedSPName = hostedSPName;
    }

    public String getDefaultIDP() throws MetadataProviderException {
        try {
            this.lock.readLock().lock();
            if (this.defaultIDP != null) {
                String string = this.defaultIDP;
                return string;
            }
            Iterator<String> iterator = this.getIDPEntityNames().iterator();
            if (iterator.hasNext()) {
                String string = iterator.next();
                return string;
            }
            throw new MetadataProviderException("No IDP was configured, please update included metadata with at least one IDP");
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setDefaultIDP(String defaultIDP) {
        this.defaultIDP = defaultIDP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtendedMetadata getExtendedMetadata(String entityID) throws MetadataProviderException {
        try {
            this.lock.readLock().lock();
            for (MetadataProvider provider : this.getProviders()) {
                ExtendedMetadata extendedMetadata = this.getExtendedMetadata(entityID, provider);
                if (extendedMetadata == null) continue;
                ExtendedMetadata extendedMetadata2 = extendedMetadata;
                return extendedMetadata2;
            }
            ExtendedMetadata extendedMetadata = this.getDefaultExtendedMetadata().clone();
            return extendedMetadata;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private ExtendedMetadata getExtendedMetadata(String entityID, MetadataProvider provider) throws MetadataProviderException {
        ExtendedMetadataProvider extendedProvider;
        ExtendedMetadata extendedMetadata;
        if (provider instanceof ExtendedMetadataProvider && (extendedMetadata = (extendedProvider = (ExtendedMetadataProvider)provider).getExtendedMetadata(entityID)) != null) {
            return extendedMetadata.clone();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityDescriptor getEntityDescriptor(byte[] hash) throws MetadataProviderException {
        try {
            this.lock.readLock().lock();
            for (String idp : this.idpName) {
                if (!SAMLUtil.compare(hash, idp)) continue;
                EntityDescriptor entityDescriptor = this.getEntityDescriptor(idp);
                return entityDescriptor;
            }
            for (String sp : this.spName) {
                if (!SAMLUtil.compare(hash, sp)) continue;
                EntityDescriptor entityDescriptor = this.getEntityDescriptor(sp);
                return entityDescriptor;
            }
            EntityDescriptor entityDescriptor = null;
            return entityDescriptor;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEntityIdForAlias(String entityAlias) throws MetadataProviderException {
        try {
            ExtendedMetadata extendedMetadata;
            this.lock.readLock().lock();
            if (entityAlias == null) {
                String string = null;
                return string;
            }
            String entityId = null;
            for (String idp : this.idpName) {
                extendedMetadata = this.getExtendedMetadata(idp);
                if (!extendedMetadata.isLocal() || !entityAlias.equals(extendedMetadata.getAlias())) continue;
                if (entityId != null && !entityId.equals(idp)) {
                    throw new MetadataProviderException("Alias " + entityAlias + " is used both for entity " + entityId + " and " + idp);
                }
                entityId = idp;
            }
            for (String sp : this.spName) {
                extendedMetadata = this.getExtendedMetadata(sp);
                if (!extendedMetadata.isLocal() || !entityAlias.equals(extendedMetadata.getAlias())) continue;
                if (entityId != null && !entityId.equals(sp)) {
                    throw new MetadataProviderException("Alias " + entityAlias + " is used both for entity " + entityId + " and " + sp);
                }
                entityId = sp;
            }
            String string = entityId;
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedMetadata getDefaultExtendedMetadata() {
        try {
            this.lock.readLock().lock();
            ExtendedMetadata extendedMetadata = this.defaultExtendedMetadata;
            return extendedMetadata;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setDefaultExtendedMetadata(ExtendedMetadata defaultExtendedMetadata) {
        Assert.notNull((Object)defaultExtendedMetadata, (String)"ExtendedMetadata parameter mustn't be null");
        this.lock.writeLock().lock();
        this.defaultExtendedMetadata = defaultExtendedMetadata;
        this.lock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRefreshRequired() {
        try {
            this.refreshLock.readLock().lock();
            boolean bl = this.refreshRequired;
            return bl;
        }
        finally {
            this.refreshLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRefreshRequired(boolean refreshRequired) {
        try {
            this.refreshLock.writeLock().lock();
            this.refreshRequired = refreshRequired;
        }
        finally {
            this.refreshLock.writeLock().unlock();
        }
    }

    public void setRefreshCheckInterval(long refreshCheckInterval) {
        this.refreshCheckInterval = refreshCheckInterval;
    }

    @Autowired
    public void setKeyManager(KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    @Autowired(required=false)
    public void setTLSConfigurer(TLSProtocolConfigurer configurer) {
    }

    private class MetadataProviderObserver
    implements ObservableMetadataProvider.Observer {
        private MetadataProviderObserver() {
        }

        public void onEvent(MetadataProvider provider) {
            MetadataManager.this.setRefreshRequired(true);
        }
    }

    private class RefreshTask
    extends TimerTask {
        private RefreshTask() {
        }

        @Override
        public void run() {
            try {
                MetadataManager.this.log.trace("Executing metadata refresh task");
                for (MetadataProvider provider : MetadataManager.this.getProviders()) {
                    provider.getMetadata();
                }
                if (MetadataManager.this.isRefreshRequired()) {
                    MetadataManager.this.refreshMetadata();
                }
            }
            catch (Throwable e) {
                MetadataManager.this.log.warn("Metadata refreshing has failed", e);
            }
        }
    }
}

