/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate4;

import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.hibernate.service.jta.platform.internal.AbstractJtaPlatform;
import org.springframework.transaction.jta.UserTransactionAdapter;
import org.springframework.util.Assert;

class ConfigurableJtaPlatform
extends AbstractJtaPlatform {
    private final TransactionManager transactionManager;
    private final UserTransaction userTransaction;

    public ConfigurableJtaPlatform(TransactionManager tm, UserTransaction ut) {
        Assert.notNull((Object)tm, (String)"TransactionManager reference must not be null");
        this.transactionManager = tm;
        this.userTransaction = ut != null ? ut : new UserTransactionAdapter(tm);
    }

    protected TransactionManager locateTransactionManager() {
        return this.transactionManager;
    }

    protected UserTransaction locateUserTransaction() {
        return this.userTransaction;
    }

    protected boolean canCacheTransactionManager() {
        return true;
    }

    protected boolean canCacheUserTransaction() {
        return true;
    }
}

