/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.service.cleanup;

import edu.harvard.catalyst.scheduler.dto.Epic.EmpiSubjectDto;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.service.cleanup.SubjectEmpiFieldMatcher;

public class NameMatcher
extends SubjectEmpiFieldMatcher {
    public NameMatcher(Subject schedulerSubject, EmpiSubjectDto.Patient empiSubject) {
        super(5.0f, schedulerSubject, empiSubject);
    }

    @Override
    SubjectEmpiFieldMatcher.MatchInfo computeMatchInfo(String site) {
        EmpiSubjectDto.Name name = this.empiSubject.getName();
        String empiLastName = name.getLast();
        String empiFirstName = name.getFirst();
        String empiMiddleInitial = name.getMiddleInitial();
        String schedulerLastName = this.schedulerSubject.getLastName();
        String schedulerFirstName = this.schedulerSubject.getFirstName();
        String schedulerMiddleName = this.schedulerSubject.getMiddleName();
        if (empiLastName != null && empiLastName.equalsIgnoreCase(schedulerLastName) && empiFirstName != null && empiFirstName.equalsIgnoreCase(schedulerFirstName) && empiMiddleInitial != null && schedulerMiddleName != null && schedulerMiddleName.toUpperCase().startsWith(empiMiddleInitial.toUpperCase())) {
            this.matchInfo.setPoints(Float.valueOf(this.weightedPoints(100.0f)));
            this.matchInfo.setMatchLabel("Exact Match!");
        } else {
            if (empiLastName != null && empiLastName.equalsIgnoreCase(schedulerLastName)) {
                this.matchInfo.setPoints(Float.valueOf(this.weightedPoints(50.0f)));
                this.matchInfo.setMatchLabel("Partial Match");
            } else {
                this.matchInfo.setMatchLabel("No Match");
            }
            this.matchInfo.setComment(name.toCommentString() + " (empi) vs (sched) " + schedulerLastName + ", " + schedulerFirstName + ", " + schedulerMiddleName);
        }
        return this.matchInfo;
    }
}

