/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.core;

import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import java.util.HashMap;
import java.util.Map;

public enum BookedVisitActivityLogStatics {
    BATCH_ENTRY("Batch Entry"),
    CANCELLED("Cancelled"),
    CHECKED_IN("Checked-In"),
    CHECKED_OUT("Checked-Out"),
    COMMENTED("Commented"),
    OVERBOOKED("Overbooked"),
    RESCHEDULED("Rescheduled"),
    SCHEDULED("Scheduled"),
    VIEWED_DETAILS_FROM_APPOINTMENT_LIST("Viewed Appointment List Details");

    public static final String USER_DATA_NOT_AVAILABLE = "user data not available.";
    private final String logString;
    private static Map<String, BookedVisitActivityLogStatics> map;

    public static BookedVisitActivityLogStatics valueByLogString(String logString) {
        BookedVisitActivityLogStatics value = map.get(logString);
        if (value == null) {
            SchedulerRuntimeException.logAndMaybeThrow("Invalid value for BookedVisitActivityLogStatics enum: " + logString, true, null);
        }
        return value;
    }

    private BookedVisitActivityLogStatics(String logString) {
        this.logString = logString;
    }

    public String getLogString() {
        return this.logString;
    }

    public static String getActionForViewedResourcesListForAppointment(String status) {
        return "Clicked on the " + status + " appointment and viewed the resources list.";
    }

    public static String getActionForViewedHistoryForAppointment(String status) {
        return "Clicked on the " + status + " appointment and viewed the activity history.";
    }

    static {
        map = new HashMap<String, BookedVisitActivityLogStatics>();
        for (BookedVisitActivityLogStatics logEnum : BookedVisitActivityLogStatics.values()) {
            map.put(logEnum.logString, logEnum);
        }
    }
}

