/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import edu.harvard.catalyst.scheduler.dto.Epic.EmpiSubjectDto;
import edu.harvard.catalyst.scheduler.dto.response.Address;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class SubjectsResponseDTO {
    private Long totalCount;
    private String logMessage;
    private String empiFailoverMessage;
    List<SubjectsResponseDTO> subjectList;
    private int id;
    private int partnersUid;
    private String lastName;
    private String firstName;
    private String middleName;
    private String nameSuffix;
    private Date dob;
    private String gender;
    private Address address;
    private String primaryContact;
    private boolean active;
    static String inactiveStatus = "inactive";
    public static final Comparator<SubjectsResponseDTO> SubjectLastNameComparatorAsc = (o1, o2) -> o1.lastName.compareToIgnoreCase(o2.lastName);
    public static final Comparator<SubjectsResponseDTO> SubjectLastNameComparatorDesc = (o1, o2) -> o2.lastName.compareToIgnoreCase(o1.lastName);
    public static final Comparator<SubjectsResponseDTO> SubjectFirstNameComparatorAsc = (o1, o2) -> o1.firstName.compareToIgnoreCase(o2.firstName);
    public static final Comparator<SubjectsResponseDTO> SubjectFirstNameComparatorDesc = (o1, o2) -> o2.firstName.compareToIgnoreCase(o1.firstName);
    public static final Comparator<SubjectsResponseDTO> SubjectContactComparatorAsc = (o1, o2) -> o1.primaryContact.compareToIgnoreCase(o2.primaryContact);
    public static final Comparator<SubjectsResponseDTO> SubjectContactComparatorDesc = (o1, o2) -> o2.primaryContact.compareToIgnoreCase(o1.primaryContact);
    public static final Comparator<SubjectsResponseDTO> SubjectBirthdateComparatorAsc = (o1, o2) -> o1.dob.compareTo(o2.dob);
    public static final Comparator<SubjectsResponseDTO> SubjectBirthdateComparatorDesc = (o1, o2) -> o2.dob.compareTo(o1.dob);
    public static final Comparator<SubjectsResponseDTO> SubjectGenderComparatorAsc = (o1, o2) -> o1.gender.compareToIgnoreCase(o2.gender);
    public static final Comparator<SubjectsResponseDTO> SubjectGenderComparatorDesc = (o1, o2) -> o2.gender.compareToIgnoreCase(o1.gender);
    public static final Comparator<SubjectsResponseDTO> SubjectCityComparatorAsc = (o1, o2) -> o1.address.getCity().compareToIgnoreCase(o2.address.getCity());
    public static final Comparator<SubjectsResponseDTO> SubjectCityComparatorDesc = (o1, o2) -> o2.address.getCity().compareToIgnoreCase(o1.address.getCity());
    public static final Comparator<SubjectsResponseDTO> SubjectStateComparatorAsc = (o1, o2) -> o1.address.getStateName().compareToIgnoreCase(o2.address.getStateName());
    public static final Comparator<SubjectsResponseDTO> SubjectStateComparatorDesc = (o1, o2) -> o2.address.getStateName().compareToIgnoreCase(o1.address.getStateName());

    public SubjectsResponseDTO(List<SubjectsResponseDTO> responseList, Long totalCount) {
        this.totalCount = totalCount;
        this.subjectList = responseList;
    }

    public SubjectsResponseDTO(int id, String lastName, String firstName, String middleName, Date dob, String gender, Address address, String primaryContact, boolean active) {
        this.id = id;
        this.lastName = lastName;
        this.firstName = firstName;
        this.middleName = middleName;
        this.nameSuffix = this.nameSuffix;
        this.dob = dob;
        this.gender = gender;
        this.address = address;
        this.primaryContact = primaryContact;
        this.active = active;
    }

    public static SubjectsResponseDTO createSubjectsResponseDTO(EmpiSubjectDto empiSubjectDto) {
        List<SubjectsResponseDTO> subjectsResponseDTOList = new ArrayList<SubjectsResponseDTO>();
        if (empiSubjectDto.getPatients() != null) {
            subjectsResponseDTOList = empiSubjectDto.getPatients().getPatientList().stream().map(p -> new SubjectsResponseDTO((EmpiSubjectDto.Patient)p)).collect(Collectors.toList());
        }
        SubjectsResponseDTO result = new SubjectsResponseDTO(subjectsResponseDTOList, Long.valueOf(subjectsResponseDTOList.size()));
        return result;
    }

    public SubjectsResponseDTO(EmpiSubjectDto.Patient subject) {
        this.id = subject.getUid();
        this.partnersUid = subject.getUid();
        this.lastName = subject.getName().getLast();
        this.firstName = subject.getName().getFirst();
        this.middleName = subject.getName().getMiddleInitial();
        this.nameSuffix = subject.getName().getSuffix();
        this.dob = DateUtility.parse(DateUtility.monthDayYear(), subject.getDobString());
        this.gender = subject.getGender();
        Address address = new Address();
        if (subject.getAddress() != null) {
            address = new Address(subject.getAddress().getLine1(), subject.getAddress().getLine2(), subject.getAddress().getCity(), subject.getAddress().getState(), subject.getAddress().getZipAsString(), subject.getAddress().getCountry());
        }
        this.address = address;
        if (subject.getPhones() != null && subject.getPhones().getPhoneList() != null && !subject.getPhones().getPhoneList().isEmpty()) {
            this.primaryContact = subject.getPhones().getPhoneList().get(0).getNumber();
        }
        this.active = subject.getStatus() != inactiveStatus;
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    public List<SubjectsResponseDTO> getSubjectList() {
        return this.subjectList;
    }

    public int getId() {
        return this.id;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public Date getDob() {
        return this.dob;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getGender() {
        return this.gender;
    }

    public Address getAddress() {
        return this.address;
    }

    public String getPrimaryContact() {
        return this.primaryContact;
    }

    public boolean getActive() {
        return this.active;
    }

    public int getPartnersUid() {
        return this.partnersUid;
    }

    public String getEmpiFailoverMessage() {
        return this.empiFailoverMessage;
    }

    public void setEmpiFailoverMessage(String empiFailoverMessage) {
        this.empiFailoverMessage = empiFailoverMessage;
    }
}

