/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter;

import java.io.IOException;
import java.nio.charset.Charset;
import org.springframework.core.convert.ConversionService;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectToStringHttpMessageConverter
extends AbstractHttpMessageConverter<Object> {
    private ConversionService conversionService;
    private StringHttpMessageConverter stringHttpMessageConverter;

    public ObjectToStringHttpMessageConverter(ConversionService conversionService) {
        this(conversionService, StringHttpMessageConverter.DEFAULT_CHARSET);
    }

    public ObjectToStringHttpMessageConverter(ConversionService conversionService, Charset defaultCharset) {
        super(new MediaType("text", "plain", defaultCharset));
        Assert.notNull((Object)conversionService, (String)"conversionService is required");
        this.conversionService = conversionService;
        this.stringHttpMessageConverter = new StringHttpMessageConverter(defaultCharset);
    }

    public void setWriteAcceptCharset(boolean writeAcceptCharset) {
        this.stringHttpMessageConverter.setWriteAcceptCharset(writeAcceptCharset);
    }

    @Override
    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return this.conversionService.canConvert(String.class, clazz) && this.canRead(mediaType);
    }

    @Override
    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return this.conversionService.canConvert(clazz, String.class) && this.canWrite(mediaType);
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object readInternal(Class<? extends Object> clazz, HttpInputMessage inputMessage) throws IOException {
        Object value = this.stringHttpMessageConverter.readInternal(String.class, inputMessage);
        return this.conversionService.convert(value, clazz);
    }

    @Override
    protected void writeInternal(Object obj, HttpOutputMessage outputMessage) throws IOException {
        String s = (String)this.conversionService.convert(obj, String.class);
        this.stringHttpMessageConverter.writeInternal(s, outputMessage);
    }

    @Override
    protected Long getContentLength(Object obj, MediaType contentType) {
        String value = (String)this.conversionService.convert(obj, String.class);
        return this.stringHttpMessageConverter.getContentLength(value, contentType);
    }
}

