/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import edu.harvard.catalyst.hccrc.core.util.RichList;
import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.entity.Resource;
import java.util.List;

public final class ResourceNameListForInpatientResponseDTO {
    private final List<ResourceNameId> resourcesForInpatient;

    public List<ResourceNameId> getResourcesForInpatient() {
        return this.resourcesForInpatient;
    }

    ResourceNameListForInpatientResponseDTO(List<ResourceNameId> resourcesForInpatient) {
        this.resourcesForInpatient = resourcesForInpatient;
    }

    public static ResourceNameListForInpatientResponseDTO fromResourceList(List<Resource> resources) {
        List resourceList = RichList.enrich(resources).map(r -> new ResourceNameId((Resource)r)).toList();
        return new ResourceNameListForInpatientResponseDTO(resourceList);
    }

    public static final class ResourceNameId {
        private final Integer id;
        private final String name;

        public int getId() {
            return this.id;
        }

        ResourceNameId(Resource resource) {
            if (resource == null) {
                SchedulerRuntimeException.logAndThrow("TemplateResource parameter should be non-null");
            }
            this.id = resource.getId();
            this.name = resource.getName();
        }
    }
}

