/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.hccrc.core.util;

import edu.harvard.catalyst.hccrc.core.util.ListUtils;
import edu.harvard.catalyst.hccrc.core.util.RichList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

public final class Range
implements Iterable<Integer> {
    public final int start;
    public final int end;
    private int current;

    public Range(int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException("Start " + start + " was greater than end " + end);
        }
        this.start = start;
        this.end = end;
        this.current = start;
    }

    public boolean contains(int i) {
        return i >= this.start && i < this.end;
    }

    public Range inclusive() {
        return new Range(this.start, this.end + 1);
    }

    public int size() {
        return this.end - this.start;
    }

    public boolean isEmpty() {
        return this.size() < 1;
    }

    public RichList<Integer> toRichList() {
        return ListUtils.enrich(this.toList());
    }

    public List<Integer> toList() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Integer> result = new ArrayList<Integer>(this.size());
        this.forEach(result::add);
        return result;
    }

    public <A> RichList<A> map(Function<? super Integer, ? extends A> f) {
        return this.toRichList().map(f);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){

            @Override
            public boolean hasNext() {
                return Range.this.current < Range.this.end;
            }

            @Override
            public Integer next() {
                try {
                    Integer n = Range.this.current;
                    return n;
                }
                finally {
                    Range.this.current++;
                }
            }
        };
    }

    public static final Range indices(List<?> list) {
        return Range.from(0).to(list.size());
    }

    public static final Builder from(int start) {
        return new Builder(start);
    }

    public static final class Builder {
        private final int start;

        public Builder(int start) {
            this.start = start;
        }

        public Range to(int end) {
            return new Range(this.start, end);
        }
    }
}

