/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.service;

import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import java.util.ArrayList;
import java.util.List;

public final class PermutationGenerator {
    private final int[] a;
    private int numLeft;
    private final int total;

    int[] getA() {
        return this.a;
    }

    int getNumLeft() {
        return this.numLeft;
    }

    int getTotal() {
        return this.total;
    }

    public PermutationGenerator(int n) {
        if (n < 1) {
            SchedulerRuntimeException.logAndThrow("Min 1");
        }
        this.a = new int[n];
        this.total = PermutationGenerator.getFactorial(n);
        this.reset();
    }

    void reset() {
        for (int i = 0; i < this.a.length; ++i) {
            this.a[i] = i;
        }
        this.numLeft = this.total;
    }

    boolean hasMore() {
        return this.numLeft > 0;
    }

    private static Integer getFactorial(int n) {
        int fact = 1;
        for (int i = n; i > 1; --i) {
            fact *= i;
        }
        return fact;
    }

    private static final List<Integer> toList(int[] is) {
        ArrayList<Integer> result = new ArrayList<Integer>(is.length);
        for (int i : is) {
            result.add(i);
        }
        return result;
    }

    public List<Integer> getNext() {
        if (this.numLeft == this.total) {
            --this.numLeft;
            return PermutationGenerator.toList(this.a);
        }
        int j = this.a.length - 2;
        while (this.a[j] > this.a[j + 1]) {
            --j;
        }
        int k = this.a.length - 1;
        while (this.a[j] > this.a[k]) {
            --k;
        }
        int temp = this.a[k];
        this.a[k] = this.a[j];
        this.a[j] = temp;
        int r = this.a.length - 1;
        for (int s = j + 1; r > s; --r, ++s) {
            temp = this.a[s];
            this.a[s] = this.a[r];
            this.a[r] = temp;
        }
        --this.numLeft;
        return PermutationGenerator.toList(this.a);
    }
}

