/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.service;

import com.google.common.base.Strings;
import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.core.Statics;
import edu.harvard.catalyst.scheduler.dto.AssignResourceAlternativesDTO;
import edu.harvard.catalyst.scheduler.dto.BooleanResultDTO;
import edu.harvard.catalyst.scheduler.dto.SearchDTO;
import edu.harvard.catalyst.scheduler.dto.SublocationClosureIntervalDTO;
import edu.harvard.catalyst.scheduler.dto.request.AddOrModifyRestrictionRequestDTO;
import edu.harvard.catalyst.scheduler.dto.request.AnnotationsIdRequestDTO;
import edu.harvard.catalyst.scheduler.dto.request.BooleanRequest;
import edu.harvard.catalyst.scheduler.dto.request.CreateResourceRequestDTO;
import edu.harvard.catalyst.scheduler.dto.request.ModifyResourceRequest;
import edu.harvard.catalyst.scheduler.dto.request.ResourceIdsRequestDTO;
import edu.harvard.catalyst.scheduler.dto.request.ResourceScheduleRequest;
import edu.harvard.catalyst.scheduler.dto.response.CreateResourceResponse;
import edu.harvard.catalyst.scheduler.dto.response.ResourceScheduleResponse;
import edu.harvard.catalyst.scheduler.dto.response.ResourcesBooleanResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.ResourcesResponse;
import edu.harvard.catalyst.scheduler.dto.response.StatusAndMessageResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.SublocationClosureIntervalResponse;
import edu.harvard.catalyst.scheduler.entity.BookedResource;
import edu.harvard.catalyst.scheduler.entity.LineLevelAnnotations;
import edu.harvard.catalyst.scheduler.entity.OverrideBookedResourceAnnotations;
import edu.harvard.catalyst.scheduler.entity.Resource;
import edu.harvard.catalyst.scheduler.entity.ResourceAlternate;
import edu.harvard.catalyst.scheduler.entity.ResourceAnnotation;
import edu.harvard.catalyst.scheduler.entity.ResourceSchedule;
import edu.harvard.catalyst.scheduler.entity.ResourceSublocation;
import edu.harvard.catalyst.scheduler.entity.ResourceType;
import edu.harvard.catalyst.scheduler.entity.Sublocation;
import edu.harvard.catalyst.scheduler.entity.SublocationClosureInterval;
import edu.harvard.catalyst.scheduler.entity.TemplateResource;
import edu.harvard.catalyst.scheduler.entity.TemplateResourceAnnotations;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.persistence.AppointmentDAO;
import edu.harvard.catalyst.scheduler.persistence.AuthDAO;
import edu.harvard.catalyst.scheduler.persistence.ResourceDAO;
import edu.harvard.catalyst.scheduler.service.AuditService;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import edu.harvard.catalyst.scheduler.util.MailHandler;
import edu.harvard.catalyst.scheduler.util.MailMessageBuilder;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResourceService {
    private MailHandler mailHandler;
    private AuthDAO authDAO;
    private ResourceDAO resourceDAO;
    private AppointmentDAO appointmentDAO;
    private AuditService auditService;

    @Autowired
    public ResourceService(AuthDAO authDAO, ResourceDAO resourceDAO, AuditService auditService, MailHandler mailHandler, AppointmentDAO appointmentDAO) {
        this.authDAO = authDAO;
        this.resourceDAO = resourceDAO;
        this.appointmentDAO = appointmentDAO;
        this.auditService = auditService;
        this.mailHandler = mailHandler;
    }

    ResourceService() {
    }

    public CreateResourceResponse createResource(CreateResourceRequestDTO createResourceRequestDTO, User user, String ipAddress) {
        ResourceType resourceType = null;
        String resourceName = createResourceRequestDTO.getName().trim();
        CreateResourceResponse response = new CreateResourceResponse();
        if (Strings.isNullOrEmpty((String)resourceName)) {
            response.setResult(false);
            response.setErrorMsg("Resource name needs to be specified");
            return response;
        }
        Pattern p = Pattern.compile("[- a-zA-Z0-9,/\\(\\)]+");
        Matcher m = p.matcher(resourceName);
        if (!m.matches()) {
            response.setResult(false);
            response.setErrorMsg("Resource name must contain only the following characters: a-z A-Z 0-9 , - ( ) / and whitespace, and cannot be empty");
            return response;
        }
        try {
            resourceType = ResourceType.valueOf(createResourceRequestDTO.getResourceType());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            response.setResult(false);
            response.setErrorMsg("Invalid resource type specified");
            return response;
        }
        Sublocation sublocation = this.resourceDAO.findSublocationById(createResourceRequestDTO.getSublocationId());
        if (sublocation == null) {
            response.setResult(false);
            response.setErrorMsg("Invalid sublocation specified");
            return response;
        }
        if (this.resourceDAO.findResourceByName(resourceName = resourceName.concat(" - ").concat(sublocation.getName())) != null) {
            response.setResult(false);
            response.setErrorMsg("This resource name is already existing");
            return response;
        }
        Resource resource = new Resource();
        resource.setName(resourceName);
        resource.setResourceType(resourceType);
        response.setSublocationName(sublocation.getName());
        this.resourceDAO.createEntity(resource);
        response.setName(resourceName);
        response.setResourceType(resourceType.getName());
        int newResourceId = resource.getId();
        this.auditService.logResourceActivity(ipAddress, resource, user, "RESOURCE CREATED", null, null);
        if (this.resourceDAO.findResourceSublocation(newResourceId, sublocation.getId()) != null) {
            response.setResult(false);
            response.setErrorMsg("There already is a sublocation associated with this resource");
            return response;
        }
        ResourceSublocation resourceSublocation = new ResourceSublocation();
        resourceSublocation.setSublocation(sublocation);
        resourceSublocation.setResource(resource);
        resourceSublocation.setActive(createResourceRequestDTO.getActive());
        this.resourceDAO.createEntity(resourceSublocation);
        response.setSublocationId(createResourceRequestDTO.getSublocationId());
        response.setResourceId(resource.getId());
        this.auditService.logResourceActivity(ipAddress, resource, user, "RESOURCE SUBLOCATION CREATED", "Active=" + resourceSublocation.isActive(), null);
        response.setResult(true);
        return response;
    }

    public List<LineLevelAnnotations> getResourceAnnotations(int resource) {
        Resource r = this.resourceDAO.findResourceById(resource);
        ArrayList<LineLevelAnnotations> rs = new ArrayList<LineLevelAnnotations>();
        List<ResourceAnnotation> ra = this.resourceDAO.findResourcesAnnotationsByResource(r);
        if (ra != null && !ra.isEmpty()) {
            for (int i = 0; i < ra.size(); ++i) {
                rs.add(ra.get(i).getLineLevelAnnotations());
            }
        }
        Collections.sort(rs, new LineLevelAnnotations.AnnotationsComparator());
        return rs;
    }

    public BooleanResultDTO addResourceAlternatives(AssignResourceAlternativesDTO dto, User user, String ipAddress) {
        BooleanResultDTO booleanResultDTO = new BooleanResultDTO();
        Resource resource = this.resourceDAO.findResourceById(dto.getResourceId());
        for (int i = 0; i < dto.getAlternatives().size(); ++i) {
            Resource altResource = this.resourceDAO.findResourceById(dto.getAlternatives().get(i));
            ResourceAlternate ra = new ResourceAlternate();
            ra.setSourceResource(resource);
            ra.setAlternateResource(altResource);
            this.resourceDAO.createEntity(ra);
        }
        this.auditService.logResourceActivity(ipAddress, resource, user, "CREATE RESOURCE ALTERNATE", null, null);
        booleanResultDTO.setResult(true);
        return booleanResultDTO;
    }

    public SublocationClosureInterval createSublocationClosureInterval(SublocationClosureIntervalDTO dto, User user, String ipAddress) {
        SublocationClosureInterval interval = new SublocationClosureInterval();
        interval.setStartTime(dto.getStartTime());
        interval.setEndTime(dto.getEndTime());
        interval.setReason(dto.getReason());
        interval.setSublocation(this.resourceDAO.findSublocationById(dto.getSublocationId()));
        this.resourceDAO.createEntity(interval);
        this.auditService.logResourceSublocationClosureActivity(ipAddress, interval.getSublocation(), user, "CREATE SUBLOCATION CLOSURE", null, null);
        return interval;
    }

    public List<SublocationClosureIntervalResponse> getSublocationClosureIntervals(String sortBy, String orderBy, int page, int maxResults) {
        return this.resourceDAO.getSublocationClosureInterval(sortBy, orderBy, page, maxResults);
    }

    public List<String> getAllResourceNames(User user, String ipAddress) {
        this.auditService.logViewActivity(ipAddress, user, "All Resource Names Viewed");
        return this.resourceDAO.getAllResourceNames();
    }

    public List<Resource> getResourcesActiveInSublocations(boolean annotations, String ipAddress, User user) {
        List<Resource> resourceList = this.resourceDAO.findResourcesActiveInSublocations();
        ArrayList<Resource> resourceCopies = new ArrayList<Resource>();
        this.auditService.logViewActivity(ipAddress, user, "All Resources Viewed");
        for (Resource r : resourceList) {
            Resource resourceCopy = new Resource(r.getId(), r.getName(), r.getResourceType(), r.getSharedResource(), r.getSublocations(), r.getAlternateResourceList(), r.getSourceResourceList(), r.getDefaultScheduleList(), r.getOverrideScheduleList());
            resourceCopies.add(resourceCopy);
            if (!annotations || !resourceCopy.getResourceType().getName().equalsIgnoreCase("ROOM")) continue;
            resourceCopy.setName("Room : " + resourceCopy.getName());
        }
        return resourceCopies;
    }

    public List<Resource> getRoomResources(String sublocation) {
        List<Resource> rs = this.resourceDAO.findRoomResourcesListedInResourceSublocation(sublocation);
        ArrayList<Resource> rooms = new ArrayList<Resource>();
        for (Resource r : rs) {
            if (r.getName().contains("Any Private Room") || r.getName().contains("All Rooms") || r.getName().contains("Feldberg Room")) continue;
            rooms.add(r);
        }
        return rooms;
    }

    public List<Resource> getNursingResources(String ipAddress, User user, String sublocation) {
        return this.resourceDAO.findNursingResourcesListedInResourceSublocation(sublocation);
    }

    public List<Resource> getNutritionResources(String ipAddress, User user, String sublocation) {
        return this.resourceDAO.findNutritionResourcesListedInResourceSublocation(sublocation);
    }

    public List<ResourcesResponse> getAlternateResources(int resourceId, String sortBy, String orderBy, int page, int maxResults) {
        Resource resource = this.resourceDAO.findResourceById(resourceId);
        List<ResourceAlternate> altResource = this.resourceDAO.findResourceAlternates(resource);
        ArrayList<Resource> altResourceList = new ArrayList<Resource>();
        for (ResourceAlternate resourceAlt : altResource) {
            altResourceList.add(resourceAlt.getAlternateResource());
        }
        List<ResourcesResponse> resourceList = this.resourceDAO.findResourcesWithSublocationAndAlternates(resource, altResourceList, sortBy, orderBy, page, maxResults);
        return resourceList;
    }

    public List<Resource> getUnassignedResources() {
        return this.resourceDAO.findResourcesNotListedInResourceSublocation();
    }

    public List<Resource> getResourcesAvailableForGenderBlockRestriction(int resourceId) {
        return this.resourceDAO.getResourcesAvailableForGenderBlockRestriction(resourceId);
    }

    public List<ResourceScheduleResponse> getResourceSchedules(int resourceId, boolean isOverride, String sortBy, String orderBy, int page, int maxResults) {
        Resource resource = this.resourceDAO.findResourceById(resourceId);
        if (isOverride) {
            return this.resourceDAO.findTemporarySchedulesByResource(resource, isOverride, sortBy, orderBy, page, maxResults);
        }
        return this.resourceDAO.findResourceSchedulesByResource(resource, isOverride, sortBy, orderBy, page, maxResults);
    }

    public ResourceScheduleResponse getResourceDefaultSchedule(int id) {
        return this.resourceDAO.resourceScheduleById(id);
    }

    public BooleanRequest addDefaultAvailability(ResourceScheduleRequest dto, User user, String ipAddress) {
        BooleanRequest booleanRequest = new BooleanRequest();
        Resource resource = this.resourceDAO.findResourceById(dto.getResourceId());
        for (int i = 0; i < dto.getDays().size(); ++i) {
            ResourceSchedule rs = new ResourceSchedule();
            rs.setResource(resource);
            rs.setDayOfWeek(dto.getDays().get(i));
            rs.setStartTime(dto.getStartDate());
            rs.setEndTime(dto.getEndDate());
            rs.setQuantity(dto.getQuantity());
            rs.setOverride(dto.isOverride());
            this.resourceDAO.createEntity(rs);
        }
        this.auditService.logResourceActivity(ipAddress, resource, user, "CREATE RESOURCE DEFAULT SCHEDULE", null, null);
        booleanRequest.setResult(true);
        return booleanRequest;
    }

    public BooleanRequest updateDefaultAvailability(ResourceScheduleRequest dto, User user, String ipAddress, String templatePath) {
        BooleanRequest booleanRequest = new BooleanRequest();
        ResourceSchedule rs = this.resourceDAO.findResourceScheduleById(dto.getId());
        int editDay = rs.getDayOfWeek();
        String editStart = rs.getStartTime().toString();
        String editEnd = rs.getEndTime().toString();
        String editQuantity = rs.getQuantity().toString();
        String previousData = this.deltaOfResourceAvailability(dto, rs);
        this.auditService.logResourceActivity(ipAddress, rs.getResource(), user, "UPDATE RESOURCE DEFAULT SCHEDULE", previousData, null);
        this.resourceDAO.updateEntity(rs);
        booleanRequest.setResult(true);
        this.sendDefaultAvailabilityChangeEmail(rs, editDay, editStart, editEnd, editQuantity, user.getInstitution().getLongName(), templatePath);
        return booleanRequest;
    }

    String deltaOfResourceAvailability(ResourceScheduleRequest dto, ResourceSchedule rs) {
        String previousData = "";
        if (!rs.getStartTime().equals(dto.getStartDate())) {
            previousData = previousData + " Start Time: " + DateUtility.dayHrMinSecFormat(rs.getStartTime()) + " to " + DateUtility.dayHrMinSecFormat(dto.getStartDate()) + ", ";
        }
        if (!rs.getEndTime().equals(dto.getEndDate())) {
            previousData = previousData + " End Time: " + DateUtility.dayHrMinSecFormat(rs.getEndTime()) + " to " + DateUtility.dayHrMinSecFormat(dto.getEndDate()) + ", ";
        }
        if (!rs.getQuantity().equals(dto.getQuantity())) {
            previousData = previousData + " Quantity: " + rs.getQuantity() + " to " + dto.getQuantity() + ", ";
        }
        if (dto.getDays() != null) {
            Integer newDayOfWeek = dto.getDays().get(0);
            if (!newDayOfWeek.equals(rs.getDayOfWeek())) {
                previousData = previousData + " Day Of Week: " + rs.getDayOfWeek() + " to " + newDayOfWeek + ", ";
            }
            rs.setDayOfWeek(newDayOfWeek);
        }
        rs.setStartTime(dto.getStartDate());
        rs.setEndTime(dto.getEndDate());
        rs.setQuantity(dto.getQuantity());
        return previousData;
    }

    void sendDefaultAvailabilityChangeEmail(ResourceSchedule rs, int editDay, String editStart, String editEnd, String editQuantity, String institution, String templatePath) {
        List<User> schedulers = this.authDAO.findSchedulerUserByInstitutionRole();
        for (User u : schedulers) {
            String to = u.getEmail();
            String day = this.returnDayofWeek(editDay);
            int days = rs.getDayOfWeek();
            String newDay = this.returnDayofWeek(days);
            String resourceName = rs.getResource().getName();
            String start = rs.getStartTime().getHours() + " : " + rs.getStartTime().getMinutes();
            String end = rs.getEndTime().getHours() + " : " + rs.getEndTime().getMinutes();
            String quantity = rs.getQuantity().toString();
            String title = "Change in the default availability of the resource.";
            StringTemplateGroup group = new StringTemplateGroup("underwebinf", templatePath, DefaultTemplateLexer.class);
            StringTemplate schedulerEmail = group.getInstanceOf("resourceChangeEmail");
            schedulerEmail.setAttribute("institution", (Object)institution);
            schedulerEmail.setAttribute("resourceName", (Object)resourceName);
            schedulerEmail.setAttribute("editday", (Object)day);
            schedulerEmail.setAttribute("editstart", (Object)editStart);
            schedulerEmail.setAttribute("editend", (Object)editEnd);
            schedulerEmail.setAttribute("editquantity", (Object)editQuantity);
            schedulerEmail.setAttribute("newday", (Object)newDay);
            schedulerEmail.setAttribute("newstart", (Object)start);
            schedulerEmail.setAttribute("newend", (Object)end);
            schedulerEmail.setAttribute("newquantity", (Object)quantity);
            if (u.getEmail() == null) continue;
            this.mailHandler.sendOptionalEmails(new MailMessageBuilder().to(to).subject(title).text(schedulerEmail.toString()).build());
        }
    }

    public String returnDayofWeek(int editDay) {
        String day = null;
        try {
            day = Statics.DAYS_OF_WEEK[editDay - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            SchedulerRuntimeException.logDontThrow("Bad index for days-of-week: " + (editDay - 1), e);
        }
        return day;
    }

    public BooleanRequest addTemporaryAdjustment(ResourceScheduleRequest dto, User user, String ipAddress) {
        BooleanRequest booleanRequest = new BooleanRequest();
        Resource resource = this.resourceDAO.findResourceById(dto.getResourceId());
        ResourceSchedule rs = new ResourceSchedule();
        rs.setResource(resource);
        rs.setStartTime(dto.getStartDate());
        rs.setEndTime(dto.getEndDate());
        rs.setQuantity(dto.getQuantity());
        rs.setOverride(dto.isOverride());
        this.auditService.logResourceActivity(ipAddress, resource, user, "CREATE RESOURCE TEMP ADJUSTMENT", null, null);
        this.resourceDAO.createEntity(rs);
        booleanRequest.setResult(true);
        return booleanRequest;
    }

    public BooleanRequest updateTemporaryAdjustment(ResourceScheduleRequest dto, User user, String ipAddress) {
        BooleanRequest booleanRequest = new BooleanRequest();
        ResourceSchedule rs = this.resourceDAO.findResourceScheduleById(dto.getId());
        String previousData = this.deltaOfResourceAvailability(dto, rs);
        rs.setOverride(dto.isOverride());
        this.auditService.logResourceActivity(ipAddress, rs.getResource(), user, "UPDATE RESOURCE TEMP ADJUSTMENT", previousData, null);
        this.resourceDAO.updateEntity(rs);
        booleanRequest.setResult(true);
        return booleanRequest;
    }

    public BooleanRequest deleteTemporaryAdjustment(int id, User user, String ipAddress, String templateContext) {
        BooleanRequest booleanRequest = new BooleanRequest();
        ResourceSchedule rs = this.resourceDAO.findResourceScheduleById(id);
        String editStart = rs.getStartTime().toString();
        String editEnd = rs.getEndTime().toString();
        this.auditService.logResourceActivity(ipAddress, rs.getResource(), user, "DELETE RESOURCE TEMP ADJUSTMENT", null, null);
        this.resourceDAO.deleteEntity(rs);
        booleanRequest.setResult(true);
        this.sendRemoveOverrideScheduleMail(rs, editStart, editEnd, user.getInstitution().getLongName(), templateContext);
        return booleanRequest;
    }

    void sendRemoveOverrideScheduleMail(ResourceSchedule rs, String editStart, String editEnd, String institution, String templatePath) {
        List<User> schedulers = this.authDAO.findSchedulerUserByInstitutionRole();
        for (User u : schedulers) {
            String to = u.getPreferredNotificationEmail();
            String resourceName = rs.getResource().getName();
            String start = rs.getStartTime().toString();
            String end = rs.getEndTime().toString();
            String quant = rs.getQuantity().toString();
            String title = "Change in the temporary adjustments of the resource.";
            StringTemplateGroup group = new StringTemplateGroup("underwebinf", templatePath, DefaultTemplateLexer.class);
            StringTemplate schedulerEmail = group.getInstanceOf("resourceTempChangeEmail");
            schedulerEmail.setAttribute("institution", (Object)institution);
            schedulerEmail.setAttribute("resourceName", (Object)resourceName);
            schedulerEmail.setAttribute("editstart", (Object)editStart);
            schedulerEmail.setAttribute("editend", (Object)editEnd);
            schedulerEmail.setAttribute("newstart", (Object)start);
            schedulerEmail.setAttribute("newend", (Object)end);
            schedulerEmail.setAttribute("newquantity", (Object)quant);
            if (u.getEmail() == null) continue;
            this.mailHandler.sendOptionalEmails(new MailMessageBuilder().to(to).subject(title).text(schedulerEmail.toString()).build());
        }
    }

    public BooleanRequest deleteDefaultAvailability(int id, User user, String ipAddress) {
        BooleanRequest booleanRequest = new BooleanRequest();
        ResourceSchedule rs = this.resourceDAO.findResourceScheduleById(id);
        this.auditService.logResourceActivity(ipAddress, rs.getResource(), user, "DELETE RESOURCE DEFAULT SCHEDULE", null, null);
        this.resourceDAO.deleteEntity(rs);
        booleanRequest.setResult(true);
        return booleanRequest;
    }

    public BooleanResultDTO deleteSublocationClosureInterval(SublocationClosureIntervalDTO dto, User user, String ipAddress) {
        BooleanResultDTO booleanResultDTO = new BooleanResultDTO();
        SublocationClosureInterval interval = this.resourceDAO.findBySublocationClosureIntervalId(dto.getSublocationClosureIntervalId());
        this.auditService.logResourceSublocationClosureActivity(ipAddress, interval.getSublocation(), user, "DELETE SUBLOCATION CLOSURE", null, null);
        this.resourceDAO.deleteEntity(interval);
        booleanResultDTO.setResult(true);
        return booleanResultDTO;
    }

    public BooleanRequest deleteResourceAlternative(int resourceId, int alternateResourceId, User user, String ipAddress) {
        BooleanRequest booleanRequest = new BooleanRequest();
        Resource resource = this.resourceDAO.findResourceById(resourceId);
        List<ResourceAlternate> list = this.resourceDAO.findResourceAlternates(resource);
        for (ResourceAlternate ra : list) {
            if (ra.getId() != alternateResourceId) continue;
            this.resourceDAO.deleteEntity(ra);
        }
        booleanRequest.setResult(true);
        this.auditService.logResourceActivity(ipAddress, resource, user, "DELETE RESOURCE ALTERNATE", null, null);
        return booleanRequest;
    }

    public BooleanRequest deleteRestriction(int resourceId, User user, String ipAddress) {
        BooleanRequest booleanRequest = new BooleanRequest();
        Resource resource = this.resourceDAO.findResourceById(resourceId);
        Resource sharedResource = this.resourceDAO.findResourceById(resource.getSharedResource());
        resource.setSharedResource(null);
        resource.setSharedResourceNotes(null);
        sharedResource.setSharedResource(null);
        sharedResource.setSharedResourceNotes(null);
        this.resourceDAO.updateEntity(resource);
        this.resourceDAO.updateEntity(sharedResource);
        booleanRequest.setResult(true);
        this.auditService.logResourceActivity(ipAddress, resource, user, "DELETE SHARED RESOURCE", null, null);
        return booleanRequest;
    }

    public BooleanRequest addRestriction(AddOrModifyRestrictionRequestDTO requestDto, User user, String ipAddress) {
        BooleanRequest booleanRequest = new BooleanRequest();
        Resource resource = this.resourceDAO.findResourceById(requestDto.getResourceId());
        Resource sharedResource = this.resourceDAO.findResourceById(requestDto.getSharedResourceId());
        resource.setSharedResource(requestDto.getSharedResourceId());
        resource.setSharedResourceNotes(requestDto.getNotes());
        sharedResource.setSharedResource(requestDto.getResourceId());
        sharedResource.setSharedResourceNotes(requestDto.getNotes());
        this.resourceDAO.updateEntity(resource);
        this.resourceDAO.updateEntity(sharedResource);
        booleanRequest.setResult(true);
        this.auditService.logResourceActivity(ipAddress, resource, user, "ADD SHARED RESOURCE", null, null);
        return booleanRequest;
    }

    public BooleanRequest modifyRestriction(AddOrModifyRestrictionRequestDTO requestDto, User user, String ipAddress) {
        BooleanRequest booleanRequest = new BooleanRequest();
        Resource resource = this.resourceDAO.findResourceById(requestDto.getResourceId());
        Resource sharedResource = this.resourceDAO.findResourceById(resource.getSharedResource());
        resource.setSharedResourceNotes(requestDto.getNotes());
        sharedResource.setSharedResourceNotes(requestDto.getNotes());
        this.resourceDAO.updateEntity(resource);
        this.resourceDAO.updateEntity(sharedResource);
        booleanRequest.setResult(true);
        this.auditService.logResourceActivity(ipAddress, resource, user, "MODIFIED SHARED RESOURCE", null, null);
        return booleanRequest;
    }

    public List<LineLevelAnnotations> getSelectedResourceAnnotations(String annotations, String mode, int templateResourceId) {
        ArrayList<LineLevelAnnotations> la = new ArrayList<LineLevelAnnotations>();
        List<String> items = Arrays.asList(annotations.split("\\s*,\\s*"));
        ArrayList<Integer> intList = new ArrayList<Integer>();
        for (String s : items) {
            intList.add(Integer.valueOf(s));
        }
        for (int i = 0; i < intList.size(); ++i) {
            LineLevelAnnotations rs = this.resourceDAO.findLineLevelAnnotationsById((Integer)intList.get(i));
            la.add(rs);
            this.setLineLevelAnnotations(mode, templateResourceId, la, i);
        }
        return la;
    }

    private void setLineLevelAnnotations(String mode, int templateResourceId, List<LineLevelAnnotations> la, int i) {
        if (mode != null && mode.equalsIgnoreCase("edit")) {
            this.templateResourceAnnotations(templateResourceId, la, i);
        } else if (mode != null && mode.equalsIgnoreCase("override_edit")) {
            this.bookedResourceAnnotations(templateResourceId, la, i);
        } else if (mode != null && (mode.equalsIgnoreCase("new") || mode.equalsIgnoreCase("override_new"))) {
            la.get(i).setQuantity(1);
        }
    }

    private void bookedResourceAnnotations(int templateResourceId, List<LineLevelAnnotations> la, int i) {
        BookedResource r = this.appointmentDAO.findBookedResourceById(templateResourceId);
        OverrideBookedResourceAnnotations rsa = this.resourceDAO.findBookedResourceAnnotationsByBookedResourceAndLineLevel(r, la.get(i));
        if (rsa != null) {
            la.get(i).setQuantity(rsa.getQuantity());
            la.get(i).setComment(rsa.getComment());
            la.get(i).setResourceAnnotations(rsa.getId());
        } else {
            la.get(i).setQuantity(1);
        }
    }

    private void templateResourceAnnotations(int templateResourceId, List<LineLevelAnnotations> la, int i) {
        TemplateResource r = this.resourceDAO.findTemplateResourceById(templateResourceId);
        TemplateResourceAnnotations rsa = this.resourceDAO.findTemplateAnnotationsByTemplateResourceAndLineLevel(r, la.get(i));
        if (rsa != null) {
            la.get(i).setQuantity(rsa.getQuantity());
            la.get(i).setComment(rsa.getComment());
            la.get(i).setResourceAnnotations(rsa.getId());
        } else {
            la.get(i).setQuantity(1);
        }
    }

    public List<LineLevelAnnotations> getBookedResourceAnnotations(int bookedResourceId) {
        BookedResource bookedResourceById = this.appointmentDAO.findBookedResourceById(bookedResourceId);
        List<OverrideBookedResourceAnnotations> rs = this.resourceDAO.findOverrideBookedResourceAnnotationsByBookedResource(bookedResourceById);
        List<LineLevelAnnotations> ls = this.getResourceAnnotations(bookedResourceById.getResource().getId());
        for (int i = 0; i < rs.size(); ++i) {
            int indexOf = ls.indexOf(rs.get(i).getLineLevelAnnotations());
            ls.get(indexOf).setSelected(true);
            ls.get(indexOf).setQuantity(rs.get(i).getQuantity());
            ls.get(indexOf).setComment(rs.get(i).getComment());
            ls.get(indexOf).setResourceAnnotations(rs.get(i).getId());
        }
        Collections.sort(ls, new LineLevelAnnotations.AnnotationsComparator());
        return ls;
    }

    public List<ResourcesResponse> getResourcesWithSublocation(String sortBy, String orderBy, String status, int page, int maxResults, User user, String ipAddress, SearchDTO searchDTO) {
        this.auditService.logViewActivity(ipAddress, user, "VIEW RESOURCE");
        List<SearchDTO.SearchItem> searchItems = null;
        if (searchDTO != null) {
            searchItems = searchDTO.getSearchItems();
        }
        return this.resourceDAO.findResourceListWithSublocation(sortBy, orderBy, status, page, maxResults, searchItems);
    }

    public ResourcesResponse getResourceDetail(int resourceId, User user, String ipAddress) {
        Resource resource = this.resourceDAO.findResourceById(resourceId);
        this.auditService.logResourceActivity(ipAddress, resource, user, "VIEW RESOURCE", null, null);
        return this.resourceDAO.findResourceDetail(resource);
    }

    public List<ResourcesResponse> getResourceAlternates(int resourceId, String sortBy, String orderBy, int page, int maxResults) {
        Resource resource = this.resourceDAO.findResourceById(resourceId);
        return this.resourceDAO.findResourceAlternatesByResource(resource, sortBy, orderBy, page, maxResults);
    }

    public StatusAndMessageResponseDTO updateResource(ModifyResourceRequest modifyResourceRequest, User user, String ipAddress) {
        StatusAndMessageResponseDTO responseDto = new StatusAndMessageResponseDTO();
        int resourceId = modifyResourceRequest.getResourceId();
        int sublocationId = modifyResourceRequest.getSublocationId();
        boolean activate = modifyResourceRequest.getActivate();
        Resource resource = this.resourceDAO.findResourceById(resourceId);
        Sublocation sublocation = this.resourceDAO.findSublocationById(sublocationId);
        ResourceSublocation resourceSublocation = this.resourceDAO.findUniqueResourceSublocationByResource(resource);
        if (Strings.isNullOrEmpty((String)modifyResourceRequest.getResourceName())) {
            responseDto.setSuccessful(false);
            responseDto.setMessage("You must specify a name for this resource.");
            return responseDto;
        }
        String resourceName = modifyResourceRequest.getResourceName().trim().concat(" - ").concat(sublocation.getName());
        Resource resourceSameName = this.resourceDAO.findResourceByName(resourceName);
        if (resourceSameName != null && resourceSameName.getId() != resourceId) {
            responseDto.setSuccessful(false);
            responseDto.setMessage("There exists a resource of the same name.");
            return responseDto;
        }
        Pattern p = Pattern.compile("[- a-zA-Z0-9,/\\(\\)]+");
        Matcher m = p.matcher(resourceName);
        if (!m.matches()) {
            responseDto.setSuccessful(false);
            responseDto.setMessage("Resource name must contain only the following characters: a-z A-Z 0-9 , - ( ) / and whitespace, and cannot be empty");
            return responseDto;
        }
        if (resourceSublocation == null) {
            responseDto.setSuccessful(false);
            responseDto.setMessage("There is no Sub-Location associated with this resource");
            return responseDto;
        }
        String oldName = resource.getName();
        String oldSublocation = resourceSublocation.getSublocation().getName();
        String oldActive = String.valueOf(resourceSublocation.isActive());
        resource.setName(resourceName);
        resourceSublocation.setSublocation(sublocation);
        if (activate) {
            resourceSublocation.setActive(true);
        }
        this.resourceDAO.updateEntity(resource);
        this.resourceDAO.updateEntity(resourceSublocation);
        StringBuilder deltaBuilder = new StringBuilder();
        MiscUtil.appendIfDifferentStrings(deltaBuilder, oldName, resourceName, "name");
        MiscUtil.appendIfDifferentStrings(deltaBuilder, oldSublocation, sublocation.getName(), "sublocation");
        MiscUtil.appendIfDifferentStrings(deltaBuilder, oldActive, String.valueOf(resourceSublocation.isActive()), "isActive");
        String deltaString = deltaBuilder.toString();
        this.auditService.logResourceActivity(ipAddress, resource, user, "UPDATE RESOURCE", deltaString, null);
        responseDto.setSuccessful(true);
        return responseDto;
    }

    public BooleanResultDTO changeResourceStatus(int resourceId, int sublocationId, boolean activate) {
        ResourceSublocation resourceSublocation = this.resourceDAO.findResourceSublocation(resourceId, sublocationId);
        BooleanResultDTO result = new BooleanResultDTO();
        if (resourceSublocation != null) {
            resourceSublocation.setActive(activate);
            this.resourceDAO.updateEntity(resourceSublocation);
            result.setResult(true);
        } else {
            result.setResult(false);
        }
        return result;
    }

    public ResourcesBooleanResponseDTO activateResources(ResourceIdsRequestDTO resources) {
        ArrayList<ResourceSublocation> resourceList = new ArrayList<ResourceSublocation>();
        ResourcesBooleanResponseDTO resourcesBooleanResponseDTO = new ResourcesBooleanResponseDTO(true);
        if (MiscUtil.isNullOrEmpty(resources.getResourceIds())) {
            resourcesBooleanResponseDTO.setResult(false);
            resourcesBooleanResponseDTO.setErrorMsg("No resources specified to be activated.");
            return resourcesBooleanResponseDTO;
        }
        for (Integer id : resources.getResourceIds()) {
            Resource resource = this.resourceDAO.findResourceById(id);
            if (resource == null || resource.getSublocations().isEmpty()) {
                resourcesBooleanResponseDTO.setResult(false);
                resourcesBooleanResponseDTO.setErrorMsg("Not all resources specified were able to be found.");
                return resourcesBooleanResponseDTO;
            }
            resourceList.addAll(resource.getSublocations().stream().map(sublocation -> this.resourceDAO.findResourceSublocation(resource.getId(), sublocation.getId())).collect(Collectors.toList()));
        }
        resourcesBooleanResponseDTO.setResourcesResponses(this.generateResourceResponseList(resourceList));
        return resourcesBooleanResponseDTO;
    }

    public BooleanResultDTO addAnnotations(AnnotationsIdRequestDTO dto, User user, String remoteHost) {
        Resource resource = this.resourceDAO.findResourceById(dto.getResourceId());
        ArrayList<LineLevelAnnotations> list = new ArrayList<LineLevelAnnotations>();
        BooleanResultDTO resultDTO = new BooleanResultDTO();
        if (resource == null) {
            resultDTO.setResult(false);
            resultDTO.setErrorMsg("Unable to find specified resource.");
            return resultDTO;
        }
        for (Integer lineLevelId : dto.getAnnotationIds()) {
            LineLevelAnnotations lineLevelAnnotations = this.resourceDAO.findLineLevelAnnotationsById(lineLevelId);
            list.add(lineLevelAnnotations);
            if (lineLevelAnnotations != null) continue;
            resultDTO.setResult(false);
            resultDTO.setErrorMsg("Not all specified annotations exist. Please try again.");
            return resultDTO;
        }
        for (ResourceAnnotation resourceAnnotation1 : this.resourceDAO.findResourcesAnnotationsByResource(resource)) {
            list.remove(resourceAnnotation1.getLineLevelAnnotations());
        }
        if (list.size() > 0) {
            for (LineLevelAnnotations annotation : list) {
                ResourceAnnotation resourceAnnotation = new ResourceAnnotation();
                resourceAnnotation.setResource(resource);
                resourceAnnotation.setLineLevelAnnotations(annotation);
                this.resourceDAO.createEntity(resourceAnnotation);
            }
            this.auditService.logResourceActivity(remoteHost, resource, user, "RESOURCE ANNOTATIONS ADDED", null, null);
        }
        resultDTO.setResult(true);
        return resultDTO;
    }

    private List<ResourcesResponse> generateResourceResponseList(List<ResourceSublocation> resourceList) {
        ArrayList<ResourcesResponse> resourcesResponseList = new ArrayList<ResourcesResponse>();
        for (ResourceSublocation resourceSublocation : resourceList) {
            resourceSublocation.setActive(true);
            this.resourceDAO.updateEntity(resourceSublocation);
            resourcesResponseList.add(new ResourcesResponse(resourceSublocation));
        }
        return resourcesResponseList;
    }
}

