/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import org.apache.commons.lang.StringUtils;

public class ExternalSubjectQueryBuilder {
    static final int MAX_RECORDS = 50;
    private String lastName;
    private String firstName;
    private String birthdate;
    private String genderCode;
    private String mrn;
    private String puid;
    private String mrnSite;
    private String puidSite;

    public ExternalSubjectQueryBuilder lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public ExternalSubjectQueryBuilder firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public ExternalSubjectQueryBuilder birthdate(String birthdate) {
        this.birthdate = birthdate;
        return this;
    }

    public ExternalSubjectQueryBuilder genderCode(String genderCode) {
        this.genderCode = genderCode;
        return this;
    }

    public ExternalSubjectQueryBuilder mrn(String mrn) {
        this.mrn = mrn;
        return this;
    }

    public ExternalSubjectQueryBuilder puid(String puid) {
        this.puid = puid;
        return this;
    }

    public ExternalSubjectQueryBuilder mrnSite(String mrnSite) {
        this.mrnSite = mrnSite;
        return this;
    }

    public ExternalSubjectQueryBuilder puidSite(String puidSite) {
        this.puidSite = puidSite;
        return this;
    }

    public String nameAndMrnToEmpiSearchParameter(String name, String mrn) {
        String result = mrn;
        if ((result == null || result.isEmpty()) && name != null && !name.isEmpty()) {
            result = name;
        }
        return result;
    }

    public String build() {
        String site;
        String subjectLastAndFirstName = this.lastName + ", " + this.firstName;
        StringBuilder queryBuilder = new StringBuilder("<?xml version=\"1.0\"?><Query ");
        String subjectMrnOrPuId = null;
        if (this.puid != null) {
            subjectMrnOrPuId = this.puid;
            site = this.puidSite;
        } else {
            subjectMrnOrPuId = this.mrn;
            site = this.mrnSite;
        }
        queryBuilder.append("Search=\"").append(this.nameAndMrnToEmpiSearchParameter(subjectLastAndFirstName, subjectMrnOrPuId)).append("\"");
        if (StringUtils.isNotBlank((String)this.birthdate)) {
            queryBuilder.append(" Age=\"").append(this.birthdate).append("\"");
        }
        if (StringUtils.isNotBlank((String)this.genderCode)) {
            queryBuilder.append(" Sex=\"").append(this.genderCode).append("\"");
        }
        if (StringUtils.isNotBlank((String)site)) {
            queryBuilder.append(" Site=\"").append(site).append("\"");
        }
        queryBuilder.append(" Max=\"").append(50).append("\"");
        queryBuilder.append(" />");
        return queryBuilder.toString();
    }
}

