/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.web;

import com.sun.jersey.spi.resource.Singleton;
import edu.harvard.catalyst.scheduler.dto.AssignResourceAlternativesDTO;
import edu.harvard.catalyst.scheduler.dto.BooleanResultDTO;
import edu.harvard.catalyst.scheduler.dto.GetResourcesDTO;
import edu.harvard.catalyst.scheduler.dto.SearchDTO;
import edu.harvard.catalyst.scheduler.dto.SublocationClosureIntervalDTO;
import edu.harvard.catalyst.scheduler.dto.request.AddOrModifyRestrictionRequestDTO;
import edu.harvard.catalyst.scheduler.dto.request.AnnotationsIdRequestDTO;
import edu.harvard.catalyst.scheduler.dto.request.BooleanRequest;
import edu.harvard.catalyst.scheduler.dto.request.CreateResourceRequestDTO;
import edu.harvard.catalyst.scheduler.dto.request.ModifyResourceRequest;
import edu.harvard.catalyst.scheduler.dto.request.ResourceIdsRequestDTO;
import edu.harvard.catalyst.scheduler.dto.request.ResourceScheduleRequest;
import edu.harvard.catalyst.scheduler.dto.response.AnnotationsNamesQuantityCommentResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.AnnotationsNamesResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.CreateResourceResponse;
import edu.harvard.catalyst.scheduler.dto.response.ResourceScheduleResponse;
import edu.harvard.catalyst.scheduler.dto.response.ResourcesBooleanResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.ResourcesResponse;
import edu.harvard.catalyst.scheduler.dto.response.ResponseWithCount;
import edu.harvard.catalyst.scheduler.dto.response.SimpleResourceListResponse;
import edu.harvard.catalyst.scheduler.dto.response.StatusAndMessageResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.SublocationClosureIntervalResponse;
import edu.harvard.catalyst.scheduler.entity.InstitutionRoleType;
import edu.harvard.catalyst.scheduler.entity.LineLevelAnnotations;
import edu.harvard.catalyst.scheduler.entity.Resource;
import edu.harvard.catalyst.scheduler.entity.SublocationClosureInterval;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.security.AuthorizedRoles;
import edu.harvard.catalyst.scheduler.service.ResourceService;
import edu.harvard.catalyst.scheduler.web.SecuredResource;
import java.util.List;
import javax.servlet.ServletContext;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/resource")
@Singleton
@Component
public class ResourceResource
extends SecuredResource {
    private ResourceService resourceService;
    @Context
    private ServletContext servletContext;

    @Autowired
    public ResourceResource(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    ResourceResource() {
    }

    @GET
    @Path(value="/getResourceAnnotations")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getResourceAnnotations(@QueryParam(value="resourceId") int resourceId) {
        List<LineLevelAnnotations> resourcesAnnotations = this.getResourceLineLevelAnnotationses(resourceId);
        GetResourcesDTO getResourcesDTO = new GetResourcesDTO();
        getResourcesDTO.setResourceAnnotationsValues(resourcesAnnotations);
        return this.gson.toJson((Object)getResourcesDTO);
    }

    @GET
    @Path(value="/getSelectedAnnotations")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getSelectedAnnotations(@QueryParam(value="selectedAnnotations") String annotations, @QueryParam(value="mode") String mode, @QueryParam(value="resourceId") int resourceId) {
        List<LineLevelAnnotations> selectedResourcesAnnotations = this.getSelectedResourceLineLevelAnnotationses(annotations, mode, resourceId);
        GetResourcesDTO getResourcesDTO = new GetResourcesDTO();
        getResourcesDTO.setAnnotationsStore(selectedResourcesAnnotations);
        return this.gson.toJson((Object)getResourcesDTO);
    }

    public List<LineLevelAnnotations> getSelectedResourceLineLevelAnnotationses(String annotations, String mode, int resourceId) {
        return this.resourceService.getSelectedResourceAnnotations(annotations, mode, resourceId);
    }

    @GET
    @Path(value="/getBookedResourceAnnotations")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getBookedResourceAnnotations(@QueryParam(value="resourceId") int templateResourceId) {
        List<LineLevelAnnotations> selectedResourcesAnnotations = this.resourceService.getBookedResourceAnnotations(templateResourceId);
        GetResourcesDTO getResourcesDTO = new GetResourcesDTO();
        getResourcesDTO.setAnnotationsStore(selectedResourcesAnnotations);
        return this.gson.toJson((Object)getResourcesDTO);
    }

    @POST
    @Path(value="/createSublocationClosureInterval")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER})
    public String createSublocationClosureInterval(@FormParam(value="data") String data) {
        SublocationClosureIntervalDTO sublocationClosureIntervalDTO = (SublocationClosureIntervalDTO)this.gson.fromJson(data, SublocationClosureIntervalDTO.class);
        SublocationClosureInterval interval = this.resourceService.createSublocationClosureInterval(sublocationClosureIntervalDTO, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)interval);
    }

    @POST
    @Path(value="/assignResourceAlternatives")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER})
    public String assignResourceAlternatives(@FormParam(value="data") String data) {
        AssignResourceAlternativesDTO assignResourceAlternativesDTO = (AssignResourceAlternativesDTO)this.gson.fromJson(data, AssignResourceAlternativesDTO.class);
        BooleanResultDTO result = this.resourceService.addResourceAlternatives(assignResourceAlternativesDTO, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)result);
    }

    @POST
    @Path(value="/deleteSublocationClosureInterval")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER})
    public String deleteSublocationClosureInterval(@FormParam(value="data") String data) {
        SublocationClosureIntervalDTO sublocationClosureIntervalDTO = (SublocationClosureIntervalDTO)this.gson.fromJson(data, SublocationClosureIntervalDTO.class);
        BooleanResultDTO result = this.resourceService.deleteSublocationClosureInterval(sublocationClosureIntervalDTO, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)result);
    }

    @GET
    @Path(value="/getRoomResources")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getRoomResources(@QueryParam(value="sublocation") String sublocations) {
        List<Resource> resources = this.resourceService.getRoomResources(sublocations);
        return this.gson.toJson(resources);
    }

    @GET
    @Path(value="/getNursingResources")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getNursingResources(@QueryParam(value="sublocation") String sublocations) {
        List<Resource> resources = this.resourceService.getNursingResources(this.getRemoteHost(), this.getUser(), sublocations);
        return this.gson.toJson(resources);
    }

    @GET
    @Path(value="/getNutritionResources")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getNutritionResources(@QueryParam(value="sublocation") String sublocations) {
        List<Resource> resources = this.resourceService.getNutritionResources(this.getRemoteHost(), this.getUser(), sublocations);
        return this.gson.toJson(resources);
    }

    @GET
    @Path(value="/getResourcesData")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getResourcesData(@QueryParam(value="sortBy") String sortBy, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="status") String status, @QueryParam(value="page") int page, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="search") String searchJson) {
        SearchDTO searchDTO = (SearchDTO)this.gson.fromJson(searchJson, SearchDTO.class);
        List<ResourcesResponse> resources = this.getResourceData(sortBy, orderBy, status, page, maxResults, this.getUser(), this.getRemoteHost(), searchDTO);
        return this.gson.toJson(resources);
    }

    List<ResourcesResponse> getResourceData(String sortBy, String orderBy, String status, int page, int maxResults, User user, String ipAddress, SearchDTO searchDTO) {
        return this.resourceService.getResourcesWithSublocation(sortBy, orderBy, status, page, maxResults, user, ipAddress, searchDTO);
    }

    @GET
    @Path(value="/getResourceSchedules")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getResourceSchedules(@QueryParam(value="resourceId") int resourceId, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="page") int page, @QueryParam(value="maxResults") int maxResults) {
        List<ResourceScheduleResponse> resourceSchedules = this.getResourcesSchedule(resourceId, false, sortBy, orderBy, page, maxResults);
        return this.gson.toJson(resourceSchedules);
    }

    List<ResourceScheduleResponse> getResourcesSchedule(int resourceId, boolean override, String sortBy, String orderBy, int page, int maxResults) {
        return this.resourceService.getResourceSchedules(resourceId, override, sortBy, orderBy, page, maxResults);
    }

    @GET
    @Path(value="/getDefaultSchedule")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getDefaultSchedule(@QueryParam(value="id") int id) {
        ResourceScheduleResponse resourceSchedules = this.getDefaultScheduleById(id);
        return this.gson.toJson((Object)resourceSchedules);
    }

    ResourceScheduleResponse getDefaultScheduleById(int id) {
        return this.resourceService.getResourceDefaultSchedule(id);
    }

    @GET
    @Path(value="/getResourceDetail")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getResourceDetail(@QueryParam(value="resourceId") int resourceId) {
        ResourcesResponse resource = this.loadResourceDetail(resourceId, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)resource);
    }

    ResourcesResponse loadResourceDetail(int resourceId, User user, String ipAddress) {
        return this.resourceService.getResourceDetail(resourceId, user, ipAddress);
    }

    @GET
    @Path(value="/getResourceAlternates")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getResourceAlternates(@QueryParam(value="resourceId") int resourceId, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="page") int page, @QueryParam(value="maxResults") int maxResults) {
        List<ResourcesResponse> resourceAlternates = this.loadResourceAlternateList(resourceId, sortBy, orderBy, page, maxResults);
        ResponseWithCount response = new ResponseWithCount();
        if (resourceAlternates.size() > 0) {
            response.setCount(resourceAlternates.get(0).getTotalCount());
        } else {
            response.setCount(0L);
        }
        response.setJsonData(this.gson.toJson(resourceAlternates));
        return this.gson.toJson((Object)response);
    }

    List<ResourcesResponse> loadResourceAlternateList(int resourceId, String sortBy, String orderBy, int page, int maxResults) {
        return this.resourceService.getResourceAlternates(resourceId, sortBy, orderBy, page, maxResults);
    }

    @GET
    @Path(value="/getAlternateResources")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getAlternateResources(@QueryParam(value="resourceId") int resourceId, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="page") int page, @QueryParam(value="maxResults") int maxResults) {
        List<ResourcesResponse> resources = this.loadAddAlternateResources(resourceId, sortBy, orderBy, page, maxResults);
        return this.gson.toJson(resources);
    }

    List<ResourcesResponse> loadAddAlternateResources(int resourceId, String sortBy, String orderBy, int page, int maxResults) {
        return this.resourceService.getAlternateResources(resourceId, sortBy, orderBy, page, maxResults);
    }

    @GET
    @Path(value="/getTemporaryAdjustments")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getTemporaryAdjustments(@QueryParam(value="resourceId") int resourceId, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="page") int page, @QueryParam(value="maxResults") int maxResults) {
        List<ResourceScheduleResponse> resourceSchedules = this.getResourcesSchedule(resourceId, true, sortBy, orderBy, page, maxResults);
        return this.gson.toJson(resourceSchedules);
    }

    @GET
    @Path(value="/getSublocationClosureIntervals")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER})
    public String getSublocationClosureIntervals(@QueryParam(value="sortBy") String sortBy, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="page") int page, @QueryParam(value="maxResults") int maxResults) {
        List<SublocationClosureIntervalResponse> sublocationClosureIntervals = this.loadSublocationIntervals(sortBy, orderBy, page, maxResults);
        return this.gson.toJson(sublocationClosureIntervals);
    }

    List<SublocationClosureIntervalResponse> loadSublocationIntervals(String sortBy, String orderBy, int page, int maxResults) {
        return this.resourceService.getSublocationClosureIntervals(sortBy, orderBy, page, maxResults);
    }

    @POST
    @Path(value="/modifyResource")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER})
    public String updateResource(@FormParam(value="data") String data) {
        ModifyResourceRequest modifyResourceRequest = (ModifyResourceRequest)this.gson.fromJson(data, ModifyResourceRequest.class);
        StatusAndMessageResponseDTO result = this.resourceService.updateResource(modifyResourceRequest, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)result);
    }

    @POST
    @Path(value="/createResource")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER})
    public String createResource(@FormParam(value="data") String data) {
        CreateResourceRequestDTO createResourceRequestDTO = (CreateResourceRequestDTO)this.gson.fromJson(data, CreateResourceRequestDTO.class);
        CreateResourceResponse result = this.resourceService.createResource(createResourceRequestDTO, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)result);
    }

    @GET
    @Path(value="/getResourceAnnotationsNames")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getResourceAnnotationsNames(@QueryParam(value="resourceId") int resourceId) {
        List<LineLevelAnnotations> resourcesAnnotations = this.getResourceLineLevelAnnotationses(resourceId);
        AnnotationsNamesResponseDTO resultDTO = AnnotationsNamesResponseDTO.fromAnnotationsList(resourcesAnnotations);
        return this.gson.toJson((Object)resultDTO);
    }

    public List<LineLevelAnnotations> getResourceLineLevelAnnotationses(int resourceId) {
        return this.resourceService.getResourceAnnotations(resourceId);
    }

    @GET
    @Path(value="/getSelectedAnnotationsNQC")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getSelectedAnnotationsNQC(@QueryParam(value="selectedAnnotations") String annotations, @QueryParam(value="mode") String mode, @QueryParam(value="resourceId") int resourceId) {
        List<LineLevelAnnotations> selectedResourcesAnnotations = this.getSelectedResourceLineLevelAnnotationses(annotations, mode, resourceId);
        AnnotationsNamesQuantityCommentResponseDTO resultDTO = AnnotationsNamesQuantityCommentResponseDTO.fromAnnotationsList(selectedResourcesAnnotations);
        return this.gson.toJson((Object)resultDTO);
    }

    @POST
    @Path(value="/addDefaultAvailability")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER})
    public String addDefaultAvailability(@FormParam(value="data") String data) {
        ResourceScheduleRequest dto = (ResourceScheduleRequest)this.gson.fromJson(data, ResourceScheduleRequest.class);
        BooleanRequest result = this.resourceService.addDefaultAvailability(dto, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)result);
    }

    @POST
    @Path(value="/updateDefaultAvailability")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER})
    public String updateDefaultAvailability(@FormParam(value="data") String data) {
        ResourceScheduleRequest dto = (ResourceScheduleRequest)this.gson.fromJson(data, ResourceScheduleRequest.class);
        BooleanRequest result = this.resourceService.updateDefaultAvailability(dto, this.getUser(), this.getRemoteHost(), this.getContextRealPath());
        return this.gson.toJson((Object)result);
    }

    @GET
    @Path(value="/deleteDefaultSchedule")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER})
    public String deleteDefaultSchedule(@QueryParam(value="id") int id) {
        BooleanRequest result = this.resourceService.deleteDefaultAvailability(id, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)result);
    }

    @POST
    @Path(value="/addTemporaryAdjustment")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER})
    public String addTemporaryAdjustment(@FormParam(value="data") String data) {
        ResourceScheduleRequest dto = (ResourceScheduleRequest)this.gson.fromJson(data, ResourceScheduleRequest.class);
        BooleanRequest result = this.resourceService.addTemporaryAdjustment(dto, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)result);
    }

    @POST
    @Path(value="/updateTemporaryAdjustment")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER})
    public String updateTemporaryAdjustment(@FormParam(value="data") String data) {
        ResourceScheduleRequest dto = (ResourceScheduleRequest)this.gson.fromJson(data, ResourceScheduleRequest.class);
        BooleanRequest result = this.resourceService.updateTemporaryAdjustment(dto, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)result);
    }

    @GET
    @Path(value="/deleteTemporaryAdjustment")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER})
    public String deleteTemporaryAdjustment(@QueryParam(value="id") int id) {
        BooleanRequest result = this.resourceService.deleteTemporaryAdjustment(id, this.getUser(), this.getRemoteHost(), this.getContextRealPath());
        return this.gson.toJson((Object)result);
    }

    @GET
    @Path(value="/removeResourceAlternative")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER})
    public String removeResourceAlternative(@QueryParam(value="resourceId") int resourceId, @QueryParam(value="alternateResourceId") int alternateResourceId) {
        BooleanRequest result = this.resourceService.deleteResourceAlternative(resourceId, alternateResourceId, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)result);
    }

    @GET
    @Path(value="/changeResourceStatus")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER})
    public String changeResourceStatus(@QueryParam(value="resourceId") int resourceId, @QueryParam(value="sublocationId") int sublocationId, @QueryParam(value="active") boolean active) {
        BooleanResultDTO result = this.resourceService.changeResourceStatus(resourceId, sublocationId, active);
        return this.gson.toJson((Object)result);
    }

    @POST
    @Path(value="/activateResources")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER})
    public String activateResources(@FormParam(value="data") String data) {
        ResourceIdsRequestDTO dto = (ResourceIdsRequestDTO)this.gson.fromJson(data, ResourceIdsRequestDTO.class);
        ResourcesBooleanResponseDTO result = this.resourceService.activateResources(dto);
        return this.gson.toJson((Object)result);
    }

    @GET
    @Path(value="/getResourcesAvailableForGenderBlockRestriction")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getResourcesAvailableForGenderBlockRestriction(@QueryParam(value="resourceId") int resourceId) {
        List<Resource> resources = this.resourceService.getResourcesAvailableForGenderBlockRestriction(resourceId);
        SimpleResourceListResponse resultDTO = SimpleResourceListResponse.fromResourcesList(resources);
        return this.gson.toJson((Object)resultDTO);
    }

    @GET
    @Path(value="/removeRestriction")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER})
    public String removeRestriction(@QueryParam(value="resourceId") int resourceId) {
        BooleanRequest result = this.resourceService.deleteRestriction(resourceId, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)result);
    }

    @POST
    @Path(value="/addRestriction")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER})
    public String addRestriction(@FormParam(value="data") String data) {
        AddOrModifyRestrictionRequestDTO requestDto = (AddOrModifyRestrictionRequestDTO)this.gson.fromJson(data, AddOrModifyRestrictionRequestDTO.class);
        BooleanRequest result = this.resourceService.addRestriction(requestDto, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)result);
    }

    @POST
    @Path(value="/modifyRestriction")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER})
    public String modifyRestriction(@FormParam(value="data") String data) {
        AddOrModifyRestrictionRequestDTO requestDto = (AddOrModifyRestrictionRequestDTO)this.gson.fromJson(data, AddOrModifyRestrictionRequestDTO.class);
        BooleanRequest result = this.resourceService.modifyRestriction(requestDto, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)result);
    }

    @GET
    @Path(value="/getAllResourceNames")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER})
    public String getAllResourceNames() {
        List<String> names = this.resourceService.getAllResourceNames(this.getUser(), this.getRemoteHost());
        return this.gson.toJson(names);
    }

    @POST
    @Path(value="/addAnnotations")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER})
    public String addAnnotations(@FormParam(value="data") String data) {
        AnnotationsIdRequestDTO dto = (AnnotationsIdRequestDTO)this.gson.fromJson(data, AnnotationsIdRequestDTO.class);
        BooleanResultDTO result = this.resourceService.addAnnotations(dto, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)result);
    }

    String getContextRealPath() {
        return this.servletContext.getRealPath("/WEB-INF");
    }
}

