/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.importSubjectMrns;

import com.opencsv.CSVReader;
import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.persistence.SubjectDAO;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.Key;
import java.sql.SQLException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class ImportSubjectMrns {
    private static final Logger LOG = Logger.getLogger(ImportSubjectMrns.class);
    private final SubjectDAO subjectDAO;
    private int idIndex;
    private int mrnIndex;
    private int siteIndex;
    private int statusIndex;
    private int puidIndex;
    private boolean clobberMrns;

    @Autowired
    public ImportSubjectMrns(SubjectDAO subjectDAO, @Qualifier(value="encryptionKeyBatch") Key key) {
        this.subjectDAO = subjectDAO;
        SubjectDataEncryptor.setEncryptionKey((Key)key);
    }

    public static void main(String[] args) throws SQLException, IOException {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("spring-epic-import-subject-mrns.xml");
        ImportSubjectMrns importSubjectMrns = (ImportSubjectMrns)context.getBean("importSubjectMrns");
        if (args.length != 7) {
            System.err.println("Usage: ImportSubjectMrns <path-to-csv> <idIndex(zero-based)> <mrnIndex> <siteIndex> <statusIndex> <puidIndex> <true|false");
        }
        String csvFilename = args[0];
        importSubjectMrns.clobberMrns = Boolean.parseBoolean(args[6]);
        importSubjectMrns.loadIndices(Integer.valueOf(args[1]), Integer.valueOf(args[2]), Integer.valueOf(args[3]), Integer.valueOf(args[4]), Integer.valueOf(args[5]));
        CSVReader csvReader = new CSVReader((Reader)new FileReader(csvFilename));
        importSubjectMrns.loopThroughCsv(csvReader);
    }

    void loopThroughCsv(CSVReader csvReader) throws SQLException, IOException {
        CharSequence[] nextLine;
        int rowNumber = -1;
        int numSuccess = 0;
        LOG.info((Object)("T/F: We will clobber DB MRNs with CSV values? " + this.clobberMrns));
        while ((nextLine = csvReader.readNext()) != null) {
            block9: {
                LOG.info((Object)("Processing row: " + ++rowNumber));
                int maxIndex = this.getMaxIndex();
                if (nextLine.length <= maxIndex) {
                    LOG.error((Object)("CSV input row number " + rowNumber + " has " + nextLine.length + " values instead of at least " + (maxIndex + 1) + ": " + String.join((CharSequence)", ", nextLine)));
                    continue;
                }
                String subjectIdString = nextLine[this.idIndex].trim();
                try {
                    SubjectMrn subjectMrn;
                    int id = Integer.valueOf(subjectIdString);
                    String mrn = this.delegateEncrypt(((String)nextLine[this.mrnIndex]).trim());
                    String site = ((String)nextLine[this.siteIndex]).trim();
                    String status = ((String)nextLine[this.statusIndex]).trim();
                    String puid = this.delegateEncrypt(((String)nextLine[this.puidIndex]).trim());
                    Subject subject = this.subjectDAO.findById(id);
                    if (null == subject) {
                        LOG.error((Object)("Row: " + rowNumber + ". No subject found with id: " + id));
                        continue;
                    }
                    Set previousSubjectMrns = subject.getSubjectMrnSet();
                    int numPrevious = previousSubjectMrns.size();
                    if (numPrevious > 1) {
                        LOG.error((Object)("Row: " + rowNumber + ". This subject id: " + subjectIdString + ", has >1 previous MRN!!"));
                        continue;
                    }
                    String previousPuid = subject.getPuid();
                    if (numPrevious == 1) {
                        subjectMrn = (SubjectMrn)previousSubjectMrns.stream().findFirst().get();
                        if (!subjectMrn.getMrn().equals(mrn) && !this.clobberMrns) {
                            LOG.error((Object)("Row: " + rowNumber + ". This subject's MRN-code differs between the DB and the CSV!!"));
                            continue;
                        }
                        subjectMrn.setMrn(mrn);
                        subjectMrn.setSite(site);
                        subjectMrn.setStatus(status);
                        this.subjectDAO.updateEntity((BaseEntity)subjectMrn);
                    } else {
                        subjectMrn = new SubjectMrn(subject, mrn, site, status);
                        this.subjectDAO.createEntity((BaseEntity)subjectMrn);
                    }
                    if (puid.equalsIgnoreCase(previousPuid)) break block9;
                    subject.setPuid(puid);
                    this.subjectDAO.updateEntity((BaseEntity)subject);
                }
                catch (NumberFormatException e) {
                    LOG.error((Object)("Row: " + rowNumber + ". Invalid subject id: " + subjectIdString));
                    continue;
                }
            }
            ++numSuccess;
        }
        LOG.info((Object)(numSuccess + " successes out of " + ++rowNumber + " data rows"));
        csvReader.close();
    }

    String delegateEncrypt(String input) {
        return SubjectDataEncryptor.encrypt((String)input);
    }

    public int getIdIndex() {
        return this.idIndex;
    }

    public int getMrnIndex() {
        return this.mrnIndex;
    }

    public int getSiteIndex() {
        return this.siteIndex;
    }

    public int getStatusIndex() {
        return this.statusIndex;
    }

    public void setIdIndex(int idIndex) {
        this.idIndex = idIndex;
    }

    public void setMrnIndex(int mrnIndex) {
        this.mrnIndex = mrnIndex;
    }

    public void setSiteIndex(int siteIndex) {
        this.siteIndex = siteIndex;
    }

    public void setStatusIndex(int statusIndex) {
        this.statusIndex = statusIndex;
    }

    public int getPuidIndex() {
        return this.puidIndex;
    }

    public void setPuidIndex(int puidIndex) {
        this.puidIndex = puidIndex;
    }

    public void setClobberMrns(boolean clobberMrns) {
        this.clobberMrns = clobberMrns;
    }

    int getMaxIndex() {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        treeSet.add(this.idIndex);
        treeSet.add(this.mrnIndex);
        treeSet.add(this.siteIndex);
        treeSet.add(this.statusIndex);
        treeSet.add(this.puidIndex);
        return (Integer)treeSet.last();
    }

    void loadIndices(int id, int mrn, int site, int status, int puid) {
        this.idIndex = id;
        this.mrnIndex = mrn;
        this.siteIndex = site;
        this.statusIndex = status;
        this.puidIndex = puid;
    }
}

