/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.dto.CsvAbleDTO;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class StaffAuditSubjectViewsReportDTO
implements CsvAbleDTO {
    private Integer subjectId;
    private Integer userId;
    private String subjectFirstName;
    private String subjectMiddleName;
    private String subjectLastName;
    private String mrn;
    private String actionPerformed;
    private Date date;
    private String ipAddress;
    private String userFirstName;
    private String userMiddleName;
    private String userLastName;
    private String ecommons;

    public Integer getSubjectId() {
        return this.subjectId;
    }

    public void setSubjectId(Integer subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectFirstName() {
        return this.subjectFirstName;
    }

    public void setSubjectFirstName(String subjectFirstName) {
        this.subjectFirstName = subjectFirstName;
    }

    public String getSubjectMiddleName() {
        return this.subjectMiddleName;
    }

    public void setSubjectMiddleName(String subjectMiddleName) {
        this.subjectMiddleName = subjectMiddleName;
    }

    public String getSubjectLastName() {
        return this.subjectLastName;
    }

    public void setSubjectLastName(String subjectLastName) {
        this.subjectLastName = subjectLastName;
    }

    public String getMrn() {
        return this.mrn;
    }

    public void setMrn(String mrn) {
        this.mrn = mrn;
    }

    public String getActionPerformed() {
        return this.actionPerformed;
    }

    public void setActionPerformed(String actionPerformed) {
        this.actionPerformed = actionPerformed;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getUserFirstName() {
        return this.userFirstName;
    }

    public void setUserFirstName(String userFirstName) {
        this.userFirstName = userFirstName;
    }

    public String getUserMiddleName() {
        return this.userMiddleName;
    }

    public void setUserMiddleName(String userMiddleName) {
        this.userMiddleName = userMiddleName;
    }

    public String getUserLastName() {
        return this.userLastName;
    }

    public void setUserLastName(String userLastName) {
        this.userLastName = userLastName;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public String getEcommons() {
        return this.ecommons;
    }

    public void setEcommons(String ecommons) {
        this.ecommons = ecommons;
    }

    @Override
    public String toCsvHeaders() {
        return "Subject Name,MRN,Action Performed,Date,IP Address,User,User ID";
    }

    @Override
    public List<String> toCsvRows(List<?> dtoList) {
        ArrayList result = Lists.newArrayList();
        int previousSubjectId = -1;
        boolean firstHeader = true;
        for (Object object : dtoList) {
            StaffAuditSubjectViewsReportDTO d = (StaffAuditSubjectViewsReportDTO)object;
            ArrayList columns = Lists.newArrayList();
            int currentSubjectId = d.subjectId;
            if (currentSubjectId != previousSubjectId) {
                if (!firstHeader) {
                    result.add(" \n");
                }
                result.add(this.toCsvHeaders() + "\n");
                columns.add(MiscUtil.q(MiscUtil.fullName(d.subjectFirstName, d.subjectMiddleName, d.subjectLastName)));
                firstHeader = false;
            } else {
                columns.add("");
            }
            previousSubjectId = currentSubjectId;
            columns.add(MiscUtil.q(d.mrn));
            columns.add(MiscUtil.q(d.actionPerformed));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.date)));
            columns.add(MiscUtil.q(d.ipAddress));
            columns.add(MiscUtil.q(MiscUtil.fullName(d.userFirstName, d.userMiddleName, d.userLastName)));
            columns.add(MiscUtil.q(d.ecommons));
            String rows = Joiner.on((String)",").join((Iterable)columns);
            result.add(rows + "\n");
        }
        return result;
    }
}

