/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.fakeSubjects;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.security.Key;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.sql.DataSource;
import org.apache.commons.cli.ParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class FakeSubjects {
    private static Map<Integer, String> stateIdToCityMap = FakeSubjects.generateStateIdToCityMap();
    private static List<String> firstNames;
    private static List<String> lastNames;
    private static int firstNameCount;
    private static int lastNameCount;
    private static List<Integer> ethnicityIds;
    private static List<Integer> raceIds;
    private static List<Integer> genderIds;
    private final DataSource dataSource;

    private static Map<Integer, String> generateStateIdToCityMap() {
        HashMap mapToPopulate = Maps.newHashMap();
        mapToPopulate.put(1, "Boston");
        mapToPopulate.put(43, "Austin");
        mapToPopulate.put(32, "New York City");
        mapToPopulate.put(14, "Chicago");
        mapToPopulate.put(6, "Los Angeles");
        mapToPopulate.put(43, "Houston");
        mapToPopulate.put(47, "Seattle");
        mapToPopulate.put(11, "Atlanta");
        return mapToPopulate;
    }

    @Autowired
    public FakeSubjects(DataSource dataSource, @Qualifier(value="encryptionKeyFake") Key key) {
        this.dataSource = dataSource;
        SubjectDataEncryptor.setEncryptionKey((Key)key);
    }

    public static void main(String[] args) throws ParseException, SQLException {
        Integer numSubjects = new Integer(args[0]);
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("spring-fake-subjects.xml");
        FakeSubjects fakeSubjects = (FakeSubjects)context.getBean("fakeSubjects");
        fakeSubjects.run(numSubjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(int numSubjects) throws SQLException {
        int numFaked = 0;
        try (Connection connection = this.dataSource.getConnection();){
            String createSubjectString = "insert into subject ( mrn, first_name, middle_name, last_name, full_name, ethnicity, birthdate, race, gender, street_address1, street_address2, city, state, zip, comment, subject_scheduler_id, country, primary_contact_number, secondary_contact_number, created_date, secure, active )  values ( ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            PreparedStatement statement = connection.prepareStatement(createSubjectString);
            for (int i = 1; i <= numSubjects; ++i) {
                this.insertQuery(statement, i);
                ++numFaked;
            }
        }
        finally {
            System.out.println("Succeeded to create " + numFaked + " fake Subjects, out of " + numSubjects + " desired");
        }
    }

    private Date randomDateOfBirth() {
        Calendar gc = Calendar.getInstance();
        gc.add(1, -1);
        int year = this.randBetween(1900, gc.get(1));
        gc.set(1, year);
        int dayOfYear = this.randBetween(1, gc.getActualMaximum(6));
        gc.set(6, dayOfYear);
        return new Date(gc.getTimeInMillis());
    }

    public int randBetween(int start, int end) {
        return start + (int)Math.round(Math.random() * (double)(end - start));
    }

    private void insertQuery(PreparedStatement statement, int index) throws SQLException {
        Random random = new Random();
        ArrayList keys = Lists.newArrayList(stateIdToCityMap.keySet());
        Integer stateId = (Integer)keys.get(random.nextInt(keys.size()));
        String cityName = stateIdToCityMap.get(stateId);
        Date birthDate = this.randomDateOfBirth();
        Timestamp createStamp = new Timestamp(Calendar.getInstance().getTimeInMillis());
        Integer ethnicity = ethnicityIds.get(random.nextInt(ethnicityIds.size()));
        Integer race = raceIds.get(random.nextInt(raceIds.size()));
        Integer gender = genderIds.get(random.nextInt(genderIds.size()));
        Integer state = new Integer(stateId);
        Integer country = new Integer(29);
        String city = SubjectDataEncryptor.encrypt((String)cityName);
        String middleName = SubjectDataEncryptor.encrypt((String)"");
        String primaryContactNumber = SubjectDataEncryptor.encrypt((String)"555-111-1111");
        String secondaryContactNumber = SubjectDataEncryptor.encrypt((String)"666-111-1111");
        String streetAddress1 = SubjectDataEncryptor.encrypt((String)"123 Main St");
        String streetAddress2 = SubjectDataEncryptor.encrypt((String)"");
        String zip = SubjectDataEncryptor.encrypt((String)"01234");
        String subjectSchedulerId = SubjectDataEncryptor.encrypt((String)("SchedulerID" + index));
        String first = firstNames.get(random.nextInt(firstNameCount)).toUpperCase();
        String last = lastNames.get(random.nextInt(lastNameCount)).toUpperCase();
        String full = first + " " + last;
        String firstName = SubjectDataEncryptor.encrypt((String)first);
        String lastName = SubjectDataEncryptor.encrypt((String)last);
        String fullName = SubjectDataEncryptor.encrypt((String)full);
        String mrn = SubjectDataEncryptor.encrypt((String)("000" + index));
        statement.setString(1, mrn);
        statement.setString(2, firstName);
        statement.setString(3, middleName);
        statement.setString(4, lastName);
        statement.setString(5, fullName);
        statement.setInt(6, ethnicity);
        statement.setDate(7, birthDate);
        statement.setInt(8, race);
        statement.setInt(9, gender);
        statement.setString(10, streetAddress1);
        statement.setString(11, streetAddress2);
        statement.setString(12, city);
        statement.setInt(13, state);
        statement.setString(14, zip);
        statement.setString(15, "");
        statement.setString(16, subjectSchedulerId);
        statement.setInt(17, country);
        statement.setString(18, primaryContactNumber);
        statement.setString(19, secondaryContactNumber);
        statement.setTimestamp(20, createStamp);
        statement.setBoolean(21, true);
        statement.setBoolean(22, true);
        statement.executeUpdate();
    }

    static {
        ethnicityIds = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4});
        raceIds = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8});
        genderIds = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6});
        firstNames = Lists.newArrayList((Object[])new String[]{"Alma", "Bobby", "Carly", "Donny", "Edna", "Fanny", "Greg", "Helen", "Ingrid", "Jacob", "Kim", "Loyd", "Melnea", "Ned", "Orenthal", "Peter", "Quick", "Robert", "Suzy", "Tommy", "Ursula", "Veronica", "Wilson", "Xerxes", "Yemi", "Zooey", "Artie", "Billie", "Christina", "Deb", "Earl", "Fred", "Gina", "Huck", "Ilias", "Jenny", "Karl", "Lana", "Manny", "Nana", "Oby", "Patty", "Quiz", "Rita", "Stan", "Tammy", "Urie", "Vincent", "Wynona", "Burger", "Ray", "Sandy", "Andrea", "Louann", "Zora", "Tom", "Jean", "Scott", "Emma", "Betsy", "Rachel", "Alan"});
        lastNames = Lists.newArrayList((Object[])new String[]{"Apple", "Boyle", "Cart", "Dove", "Everage", "Farber", "Gumble", "Hayes", "India", "Jones", "Lamp", "Moses", "Needham", "Opp", "Pointer", "Quiet", "Redford", "Sandor", "Twotone", "Underwood", "White", "Xerlop", "Young", "Ziskin", "Ashford", "Blue", "Crawford", "Docker", "Easton", "Flinstone", "Grant", "Howe", "Inwood", "Jewel", "Kamp", "Luz", "Morgan", "Nickle", "Osman", "Park", "Quorum", "Rudner", "Smith", "Tent", "Udeen", "Voss", "West", "King", "Croc", "Smyth", "Small", "Sweet", "Sound", "Thompson", "Grey", "Harlow", "Frost", "Grae", "Summers", "Smithee"});
        firstNameCount = firstNames.size();
        lastNameCount = lastNames.size();
    }
}

