/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.asyncqueue;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.asyncqueue.AsyncQueue;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.utils.DebugPoint;

public abstract class AsyncQueueRecord<R>
implements Cacheable {
    private static final Logger LOGGER = Grizzly.logger(AsyncQueue.class);
    protected Connection connection;
    protected Object message;
    protected R currentResult;
    protected CompletionHandler completionHandler;
    protected boolean isRecycled = false;
    protected DebugPoint recycleTrack;

    public AsyncQueueRecord(Connection connection, Object message, R currentResult, CompletionHandler completionHandler) {
        this.set(connection, message, currentResult, completionHandler);
    }

    protected final void set(Connection connection, Object message, R currentResult, CompletionHandler completionHandler) {
        this.checkRecycled();
        this.connection = connection;
        this.message = message;
        this.currentResult = currentResult;
        this.completionHandler = completionHandler;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public final <T> T getMessage() {
        this.checkRecycled();
        return (T)this.message;
    }

    public final void setMessage(Object message) {
        this.checkRecycled();
        this.message = message;
    }

    public final R getCurrentResult() {
        this.checkRecycled();
        return this.currentResult;
    }

    public void notifyFailure(Throwable e) {
        if (this.completionHandler != null) {
            this.completionHandler.failed(e);
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, LogMessages.FINE_GRIZZLY_ASYNCQUEUE_ERROR_NOCALLBACK_ERROR(e));
        }
    }

    public final void notifyIncomplete() {
        if (this.completionHandler != null) {
            this.completionHandler.updated(this.currentResult);
        }
    }

    protected final void checkRecycled() {
        if (Grizzly.isTrackingThreadCache() && this.isRecycled) {
            DebugPoint track = this.recycleTrack;
            if (track != null) {
                throw new IllegalStateException("AsyncReadQueueRecord has been recycled at: " + track);
            }
            throw new IllegalStateException("AsyncReadQueueRecord has been recycled");
        }
    }
}

