/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memory;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.memory.HeapMemoryManager;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.nio.SelectionKeyHandler;

class MemoryManagerInitializer {
    private static final String PROP = "org.glassfish.grizzly.DEFAULT_MEMORY_MANAGER";
    private static final Logger LOGGER = Grizzly.logger(MemoryManagerInitializer.class);

    MemoryManagerInitializer() {
    }

    static MemoryManager initManager() {
        String className = System.getProperty(PROP);
        if (className != null) {
            try {
                Class<?> mmClass = Class.forName(className, true, SelectionKeyHandler.class.getClassLoader());
                return (MemoryManager)mmClass.newInstance();
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "Unable to load or create a new instance of MemoryManager {0}.  Cause: {1}", new Object[]{className, e.getMessage()});
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.toString(), e);
                }
                return new HeapMemoryManager();
            }
        }
        return new HeapMemoryManager();
    }
}

