/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import edu.harvard.catalyst.hccrc.core.util.RichList;
import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.entity.Study;
import edu.harvard.catalyst.scheduler.entity.StudySubject;
import edu.harvard.catalyst.scheduler.entity.Subject;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.function.Function;

public final class GetStudySubjectsResponse {
    private final Long totalCount;
    final List<StudySubject1> studySubject1s;
    public static final Comparator<StudySubject> StudySubjectLastNameComparatorDesc = GetStudySubjectsResponse.invert(GetStudySubjectsResponse.ignoreCaseAndCompareVia(Subject::getLastName));
    public static final Comparator<StudySubject> StudySubjectMRNComparatorDesc = GetStudySubjectsResponse.invert(GetStudySubjectsResponse.ignoreCaseAndCompareVia(Subject::getMrn));
    public static final Comparator<StudySubject> StudySubjectFirstNameComparatorDesc = GetStudySubjectsResponse.invert(GetStudySubjectsResponse.ignoreCaseAndCompareVia(Subject::getFirstName));
    public static final Comparator<StudySubject> StudySubjectContactComparatorDesc = GetStudySubjectsResponse.invert(GetStudySubjectsResponse.compareVia(Subject::getPrimaryContactNumber));
    public static final Comparator<StudySubject> StudySubjectBirthdateComparatorDesc = GetStudySubjectsResponse.invert(GetStudySubjectsResponse.compareVia(Subject::getBirthdate));
    public static final Comparator<StudySubject> StudySubjectCityComparatorDesc = GetStudySubjectsResponse.invert(GetStudySubjectsResponse.ignoreCaseAndCompareVia(Subject::getCity));
    public static final Comparator<StudySubject> StudySubjectLastNameComparatorAsc = GetStudySubjectsResponse.ignoreCaseAndCompareVia(Subject::getLastName);
    public static final Comparator<StudySubject> StudySubjectMRNComparatorAsc = GetStudySubjectsResponse.ignoreCaseAndCompareVia(Subject::getMrn);
    public static final Comparator<StudySubject> StudySubjectFirstNameComparatorAsc = GetStudySubjectsResponse.ignoreCaseAndCompareVia(Subject::getFirstName);
    public static final Comparator<StudySubject> StudySubjectContactComparatorAsc = GetStudySubjectsResponse.compareVia(Subject::getPrimaryContactNumber);
    public static final Comparator<StudySubject> StudySubjectBirthdateComparatorAsc = GetStudySubjectsResponse.compareVia(Subject::getBirthdate);
    public static final Comparator<StudySubject> StudySubjectCityComparatorAsc = GetStudySubjectsResponse.ignoreCaseAndCompareVia(Subject::getCity);

    private GetStudySubjectsResponse(List<StudySubject1> studySubject1s, Long totalCount) {
        this.totalCount = totalCount;
        this.studySubject1s = studySubject1s;
    }

    public static GetStudySubjectsResponse createGetStudiesSubjectsResponse(List<StudySubject> studySubjects, Long total) {
        List studySubject1List = RichList.enrich(studySubjects).map(ss -> new StudySubject1((StudySubject)ss)).toList();
        return new GetStudySubjectsResponse(studySubject1List, total);
    }

    private static final <F extends Comparable<F>> Comparator<StudySubject> compareVia(Function<Subject, F> field) {
        return (o1, o2) -> {
            Comparable field1 = (Comparable)field.apply(o1.getSubject());
            Comparable field2 = (Comparable)field.apply(o2.getSubject());
            return field1.compareTo(field2);
        };
    }

    private static final Comparator<StudySubject> ignoreCaseAndCompareVia(Function<Subject, String> field) {
        return (o1, o2) -> {
            String field1 = (String)field.apply(o1.getSubject());
            String field2 = (String)field.apply(o2.getSubject());
            return field1.compareToIgnoreCase(field2);
        };
    }

    private static final Comparator<StudySubject> invert(Comparator<StudySubject> c) {
        return (o1, o2) -> c.compare((StudySubject)o2, (StudySubject)o1);
    }

    static final class StudySubject1 {
        private final Integer id;
        private final Integer studyId;
        private final Integer subjectId;
        private final String subjectMRN;
        private final String subjectLastName;
        private final String subjectFirstName;
        private final Date subjectDOB;
        private final String subjectCity;
        private final String subjectPrimaryContact;
        private final boolean subjectStatus;

        StudySubject1(StudySubject studySubject) {
            if (studySubject == null) {
                SchedulerRuntimeException.logAndThrow("StudySubject should not be null!");
            }
            Study study = studySubject.getStudy();
            Subject subject = studySubject.getSubject();
            if (study == null) {
                SchedulerRuntimeException.logAndThrow("Study should not be null!");
            }
            if (subject == null) {
                SchedulerRuntimeException.logAndThrow("Subject should not be null!");
            }
            this.id = studySubject.getId();
            this.studyId = study.getId();
            this.subjectId = subject.getId();
            this.subjectMRN = subject.getMrn();
            this.subjectLastName = subject.getLastName();
            this.subjectFirstName = subject.getFirstName();
            this.subjectDOB = subject.getBirthdate();
            this.subjectCity = subject.getCity();
            this.subjectPrimaryContact = subject.getPrimaryContactNumber();
            this.subjectStatus = studySubject.getActive();
        }
    }
}

