/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.entity.reporttemplate;

import edu.harvard.catalyst.scheduler.entity.reporttemplate.Field;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.TemplateCategoryField;
import java.util.List;
import java.util.stream.Collectors;

public enum FieldSortType {
    Default{

        @Override
        public String sortOrderByPhrase(String sortScalarColumn, String joinTable, String orderBy) {
            return FieldSortType.sortOrderByPhraseUseBareScalarColumn(sortScalarColumn, orderBy);
        }
    }
    ,
    InnerJoinShortStringDB{

        @Override
        public void sortFromTableAddition(String joinedTable, List<String> fromTables) {
            FieldSortType.sortFromTableAdditionManyShortDBs(joinedTable, fromTables);
        }

        @Override
        public void sortWhereClauseAddition(String joinedTable, String lhsColumn, List<String> whereClauses) {
            FieldSortType.sortWhereClauseAdditionManyShortDBs(joinedTable, lhsColumn, whereClauses);
        }
    }
    ,
    UserStaff{

        @Override
        public String postProcessQueryForSort(String query, TemplateCategoryField tcf) {
            return FieldSortType.postProcessQueryForSortUserStaff(query, tcf);
        }

        @Override
        public String sortOrderByPhrase(String sortScalarColumn, String joinTable, String orderBy) {
            return FieldSortType.sortOrderByPhraseUseScalarColumnName(sortScalarColumn, orderBy);
        }
    }
    ,
    StudyFundingSource{

        @Override
        public String postProcessQueryForSort(String query, TemplateCategoryField tcf) {
            return FieldSortType.postProcessQueryForSortStudyFundingSource(query, tcf);
        }

        @Override
        public String sortOrderByPhrase(String sortScalarColumn, String joinTable, String orderBy) {
            return FieldSortType.sortOrderByPhraseUseScalarColumnName(sortScalarColumn, orderBy);
        }
    }
    ,
    LeftJoinShortStringDb{

        @Override
        public List<String> postProcessFromTablesForSort(List<String> fromTables, TemplateCategoryField tcf) {
            return FieldSortType.postProcessFromTablesForSortLeftJoinDb(fromTables, tcf);
        }
    }
    ,
    LeftJoinShortStringDbStudy("(INNER JOIN study s)", "$1 left join institution institution on s.institution = institution.id"){

        @Override
        public List<String> postProcessFromTablesForSort(List<String> fromTables, TemplateCategoryField tcf) {
            return FieldSortType.postProcessFromTablesForSortLeftJoinDb(fromTables, tcf);
        }
    }
    ,
    TemplateResourceSublocation("(left join template_resource tr on tr.visit_template = vt.id)", "$1 left join resource resource_trs on tr.resource = resource_trs.id   left join resource_sublocation resource_sublocation_trs on resource_sublocation_trs.resource = resource_trs.id   left join sublocation sublocation_trs on resource_sublocation_trs.sublocation = sublocation_trs.id "){

        @Override
        public String sortOrderByPhrase(String sortScalarColumn, String joinTable, String orderBy) {
            return "sublocation_trs.name " + orderBy;
        }
    }
    ,
    TemplateResourceResource("(left join template_resource tr on tr.visit_template = vt.id)", "$1 left join resource_trr resource on tr.resource = resource_trr.id"){

        @Override
        public String sortOrderByPhrase(String sortScalarColumn, String joinTable, String orderBy) {
            return "resource_trr.name " + orderBy;
        }
    };

    private String replacementRhs;
    private String replacementLhs;

    public void sortFromTableAddition(String joinedTable, List<String> fromTables) {
    }

    public void sortWhereClauseAddition(String joinedTable, String lhsColumn, List<String> whereClauses) {
    }

    public String sortOrderByPhrase(String sortScalarColumn, String joinTable, String orderBy) {
        return FieldSortType.sortOrderByPhraseUseJoinColumn(joinTable, orderBy);
    }

    private static void sortFromTableAdditionManyShortDBs(String joinedTable, List<String> fromTables) {
        String joinTableFrom = joinedTable + " " + joinedTable;
        fromTables.add(0, joinTableFrom);
    }

    private static void sortWhereClauseAdditionManyShortDBs(String joinedTable, String lhsColumn, List<String> whereClauses) {
        String joinCondition = lhsColumn + "=" + joinedTable + ".id";
        whereClauses.add(joinCondition);
    }

    private static String sortOrderByPhraseUseJoinColumn(String joinTable, String orderBy) {
        return joinTable + ".name " + orderBy;
    }

    private static String sortOrderByPhraseUseBareScalarColumn(String sortScalarColumn, String orderBy) {
        return sortScalarColumn + " " + orderBy;
    }

    private static String sortOrderByPhraseUseScalarColumnName(String sortScalarColumn, String orderBy) {
        return sortScalarColumn + ".name " + orderBy;
    }

    private FieldSortType() {
        this("(.*)", "$1");
    }

    private FieldSortType(String replacementLhs, String replacementRhs) {
        this.replacementLhs = replacementLhs;
        this.replacementRhs = replacementRhs;
    }

    public String postProcessQueryForSort(String query, TemplateCategoryField tcf) {
        return query.replaceAll(this.replacementLhs, this.replacementRhs);
    }

    public List<String> postProcessFromTablesForSort(List<String> fromTables, TemplateCategoryField tcf) {
        return fromTables;
    }

    private static String postProcessQueryForSortUserStaff(String query, TemplateCategoryField tcf) {
        String userFkTable = tcf.getField().getColumn();
        String userTableSuffix = tcf.getSuffix();
        String studyFkTable = Field.getUserSuffixToJoinColumn().get(userTableSuffix);
        String intermediateJoinTable = userFkTable + "_u" + userTableSuffix;
        String myReplacementLhs = "left join user u" + userTableSuffix + " on s." + studyFkTable + " = u" + userTableSuffix + ".id";
        String myReplacementRhs = " left join " + userFkTable + " " + intermediateJoinTable + " on u" + userTableSuffix + "." + userFkTable + " = " + intermediateJoinTable + ".id ";
        String result = FieldSortType.applyChangeIfNotAlreadyPresent(query, myReplacementLhs, myReplacementRhs);
        return result;
    }

    private static String postProcessQueryForSortStudyFundingSource(String query, TemplateCategoryField tcf) {
        String studyFkTable = tcf.getField().getColumn();
        String studyTableSuffix = tcf.getSuffix();
        String oneToFour = studyTableSuffix.replaceAll("_f", "");
        String intermediateJoinTable = studyFkTable + "_sfs" + studyTableSuffix;
        String myReplacementLhs = "left join study_funding_source_cai sfs" + studyTableSuffix + " on \\(sfs" + studyTableSuffix + ".study = s.id and sfs" + studyTableSuffix + ".one_to_four = " + oneToFour + "\\)";
        String myReplacementRhs = " left join " + studyFkTable + " " + intermediateJoinTable + " on sfs" + studyTableSuffix + "." + studyFkTable + " = " + intermediateJoinTable + ".id";
        String result = FieldSortType.applyChangeIfNotAlreadyPresent(query, myReplacementLhs, myReplacementRhs);
        return result;
    }

    private static List<String> postProcessFromTablesForSortLeftJoinDb(List<String> fromTables, TemplateCategoryField tcf) {
        String table = tcf.getField().getTable();
        String tableAlias = Field.getTableAlias(table);
        String fkColumn = tcf.getField().getColumn();
        String joinedTable = Field.getFkFieldToTable(fkColumn);
        return fromTables.stream().map(t -> FieldSortType.applyChangeIfNotAlreadyPresent(t, table + " " + tableAlias, " left join " + joinedTable + " " + fkColumn + " on " + fkColumn + ".id = " + tableAlias + "." + fkColumn)).collect(Collectors.toList());
    }

    public static String applyChangeIfNotAlreadyPresent(String enclosingString, String lhs, String rhs) {
        if (enclosingString.matches(".*" + lhs + ".*" + rhs + ".*")) {
            return enclosingString;
        }
        return enclosingString.replaceAll("(" + lhs + ")", "$1" + rhs);
    }
}

