/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.persistence;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.hccrc.core.util.Pair;
import edu.harvard.catalyst.hccrc.core.util.Pairs;
import edu.harvard.catalyst.hccrc.core.util.RichList;
import edu.harvard.catalyst.scheduler.dto.response.BookedResourcesResponse;
import edu.harvard.catalyst.scheduler.dto.response.BookedVisitsResponse;
import edu.harvard.catalyst.scheduler.dto.response.CalendarVisitsResponse;
import edu.harvard.catalyst.scheduler.dto.response.GetStudySubjectsResponse;
import edu.harvard.catalyst.scheduler.dto.response.OverbookTimelineDataResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.VisitCommentsResponse;
import edu.harvard.catalyst.scheduler.entity.AppointmentOverrideReason;
import edu.harvard.catalyst.scheduler.entity.AppointmentStatus;
import edu.harvard.catalyst.scheduler.entity.AppointmentStatusReason;
import edu.harvard.catalyst.scheduler.entity.BookedResource;
import edu.harvard.catalyst.scheduler.entity.BookedVisit;
import edu.harvard.catalyst.scheduler.entity.CancellationStatus;
import edu.harvard.catalyst.scheduler.entity.Comments;
import edu.harvard.catalyst.scheduler.entity.Resource;
import edu.harvard.catalyst.scheduler.entity.ResourceSchedule;
import edu.harvard.catalyst.scheduler.entity.ResourceType;
import edu.harvard.catalyst.scheduler.entity.Study;
import edu.harvard.catalyst.scheduler.entity.StudySubject;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.Sublocation;
import edu.harvard.catalyst.scheduler.entity.SublocationClosureInterval;
import edu.harvard.catalyst.scheduler.entity.TemplateResource;
import edu.harvard.catalyst.scheduler.entity.TemplateResourceAnnotations;
import edu.harvard.catalyst.scheduler.entity.TemplateResourceGroup;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.entity.VisitTemplate;
import edu.harvard.catalyst.scheduler.entity.VisitType;
import edu.harvard.catalyst.scheduler.persistence.HqlClauses;
import edu.harvard.catalyst.scheduler.persistence.SiteDAO;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class AppointmentDAO
extends SiteDAO {
    public static final Integer SCHEDULE_ID = 1;
    private static final Integer CHECKIN_ID = 2;
    private static final Integer CHECKOUT_ID = 3;
    private static final Integer CANCEL_ID = 4;

    static boolean isAllDay(boolean homeView, String visitType) {
        return homeView && visitType.contains("Inpatient");
    }

    public List<SublocationClosureInterval> findSublocationSchedule(Sublocation sublocations, Date startDate, Date endDate) {
        String findSublocationClosure = "select s FROM SublocationClosureInterval s where s.sublocation = :sublocation AND  ((:startTime between s.startTime and s.endTime)  or (:endTime between s.startTime and s.endTime)  or (s.startTime >= :startTime and s.endTime <= :endTime))";
        Query query = this.newQuery("select s FROM SublocationClosureInterval s where s.sublocation = :sublocation AND  ((:startTime between s.startTime and s.endTime)  or (:endTime between s.startTime and s.endTime)  or (s.startTime >= :startTime and s.endTime <= :endTime))");
        query.setParameter("sublocation", (Object)sublocations);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        List list = query.list();
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public boolean isSublocationClosed(Sublocation sublocations, Date startDate, Date endDate) {
        String findSublocationClosure = "select s FROM SublocationClosureInterval s where s.sublocation = :sublocation AND  ((:startTime >= s.startTime and :startTime < s.endTime)  or (:endTime > s.startTime and :endTime <= s.endTime)  or (s.startTime >= :startTime and s.endTime <= :endTime))";
        Query query = this.newQuery("select s FROM SublocationClosureInterval s where s.sublocation = :sublocation AND  ((:startTime >= s.startTime and :startTime < s.endTime)  or (:endTime > s.startTime and :endTime <= s.endTime)  or (s.startTime >= :startTime and s.endTime <= :endTime))");
        query.setParameter("sublocation", (Object)sublocations);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        List list = query.list();
        return !list.isEmpty();
    }

    public List<BookedResource> findOverbookConflictResourcesByVisitStatus(Resource resource, Date startDate, Date endDate) {
        String findBookedResource = "select br FROM BookedResource br, BookedVisit bv where  br.bookedVisit = bv.id and bv.appointmentStatus IN (1,2) and br.resource = :resource  and ((:startTime >= br.scheduledStartTime and :startTime < br.scheduledEndTime)  or (:endTime > br.scheduledStartTime and :endTime <= br.scheduledEndTime)  or (br.scheduledStartTime >= :startTime and br.scheduledEndTime <= :endTime)) ORDER BY br.scheduledStartTime";
        Query query = this.newQuery("select br FROM BookedResource br, BookedVisit bv where  br.bookedVisit = bv.id and bv.appointmentStatus IN (1,2) and br.resource = :resource  and ((:startTime >= br.scheduledStartTime and :startTime < br.scheduledEndTime)  or (:endTime > br.scheduledStartTime and :endTime <= br.scheduledEndTime)  or (br.scheduledStartTime >= :startTime and br.scheduledEndTime <= :endTime)) ORDER BY br.scheduledStartTime");
        query.setParameter("resource", (Object)resource);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        return query.list();
    }

    public List<OverbookTimelineDataResponseDTO> getOverbookTimelineData(Date startDate, Date endDate, ResourceType resourceType, List<Integer> sublocations, String orderBy, User user) {
        Object[] columnsArray = new String[]{"resource.id", "resource.name", "bvStart", "bvEnd", "visit_template.name", "user.last_name", "study.local_id", "brStart", "brEnd", "bvId", "subject.first_name", "subject.last_name"};
        String columnSqlList = Joiner.on((String)", ").join(columnsArray);
        String filterBy = sublocations.isEmpty() ? " " : " and resource_sublocation.sublocation IN (" + Joiner.on((String)",").join(sublocations) + ") ";
        String findBookedResource = "SELECT " + columnSqlList + " " + "FROM resource_sublocation, resource " + "LEFT OUTER JOIN (select br.resource, br.id, br.booked_visit, booked_visit.visit_template, booked_visit.id bvId," + "booked_visit.scheduled_start_time AS bvStart, booked_visit.scheduled_end_time AS bvEnd, br.scheduled_start_time AS brStart, " + "br.scheduled_end_time AS brEnd," + "booked_visit.study, booked_visit.appointment_status, s.principal_investigator, su.id subjectId " + "from booked_resource br, booked_visit, study s, study_subject ss, subject su WHERE br.booked_visit = booked_visit.id " + "and booked_visit.study = s.id and booked_visit.study_subject = ss.id and ss.subject = su.id " + "and booked_visit.appointment_status IN (1,2) and  " + "((:startTime between br.scheduled_start_time  " + "                 and br.scheduled_end_time)  " + "                 or (:endTime between br.scheduled_start_time " + "                 and br.scheduled_end_time)  " + "                 or (br.scheduled_start_time > :startTime and  " + "                 br.scheduled_end_time < :endTime)) ) AS bookedData ON resource.id = bookedData.resource " + "                LEFT OUTER JOIN study ON bookedData.study = study.id " + "                LEFT OUTER JOIN subject ON bookedData.subjectId = subject.id " + "                LEFT OUTER JOIN visit_template ON bookedData.visit_template = visit_template.id " + "                LEFT OUTER JOIN user ON bookedData.principal_investigator = user.id " + "                where resource_sublocation.resource = resource.id and resource.type IN (:resourceType) " + filterBy + "                ORDER BY resource.name " + orderBy + ", bookedData.brStart";
        System.out.println("Running SQL: '" + findBookedResource + "'");
        SQLQuery query = this.newSqlQuery(findBookedResource);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        query.setParameter("resourceType", (Object)resourceType.getName());
        for (Object column : columnsArray) {
            query.addScalar((String)column);
        }
        List resultRows = query.list();
        long selectedMinutes = startDate.getTime() / 60000L;
        List<Date> selectedDates = DateUtility.dateInterval(startDate, endDate);
        Session session = this.session();
        Ref<Integer> previousResource = new Ref<Integer>(0);
        Function<Object[], OverbookTimelineDataResponseDTO> toOverbookTimelineDataResponseDTO = resultRow -> {
            Integer resource = (Integer)resultRow[0];
            String resourceName = (String)resultRow[1];
            Date scheduledStartTime = (Date)resultRow[7];
            Date scheduledEndTime = (Date)resultRow[8];
            Integer bookedVisitId = (Integer)resultRow[9];
            boolean hasBookedVisitId = bookedVisitId != null;
            boolean isNewResource = !resource.equals(previousResource.get());
            boolean notStudyStaff = !user.isStudyStaff();
            boolean hasBookedVisitIdAndNotStudyStaff = hasBookedVisitId && notStudyStaff;
            boolean hasBookedVisitIdAndIsNewResource = hasBookedVisitId && isNewResource;
            int rowCount = hasBookedVisitIdAndIsNewResource ? this.getResourceCount(resource, startDate, endDate) : 0;
            long sixtySecondsInMillis = Duration.ofSeconds(60L).toMillis();
            String rooms = hasBookedVisitId ? AppointmentDAO.findRoomString(bookedVisitId, session) : "";
            long startTime = hasBookedVisitId ? scheduledStartTime.getTime() / sixtySecondsInMillis : 0L;
            long endTime = hasBookedVisitId ? scheduledEndTime.getTime() / sixtySecondsInMillis : 0L;
            String piName = hasBookedVisitIdAndNotStudyStaff ? (String)resultRow[5] : "";
            String localId = hasBookedVisitIdAndNotStudyStaff ? (String)resultRow[6] : "";
            String visit = hasBookedVisitIdAndNotStudyStaff ? (String)resultRow[4] : "";
            String subjectFirstName = hasBookedVisitIdAndNotStudyStaff ? SubjectDataEncryptor.decrypt((String)resultRow[10]) : "";
            String subjectLastName = hasBookedVisitIdAndNotStudyStaff ? SubjectDataEncryptor.decrypt((String)resultRow[11]) : "";
            String visitHoverStartTime = DateUtility.format(DateUtility.dateTime(), (Date)resultRow[2]);
            String visitHoverEndTime = DateUtility.format(DateUtility.dateTime(), (Date)resultRow[3]);
            String resourceHoverStartTime = DateUtility.format(DateUtility.dateTime(), (Date)resultRow[7]);
            String resourceHoverEndTime = DateUtility.format(DateUtility.dateTime(), (Date)resultRow[8]);
            String alternateResources = isNewResource ? this.findAlternateResourcesString(resource) : "";
            ArrayList<Map<String, String>> defaultResourceSchedule = isNewResource ? this.getDefaultResourceSchedule(selectedDates, resource) : new ArrayList();
            ArrayList<Map<String, String>> temporaryResourceSchedule = isNewResource ? this.getTemporaryResourceSchedule(startDate, endDate, resource) : new ArrayList<Map<String, String>>();
            OverbookTimelineDataResponseDTO overbookTimeLineData = new OverbookTimelineDataResponseDTO(resource, resourceName, rooms, visitHoverStartTime, visitHoverEndTime, resourceHoverStartTime, resourceHoverEndTime, visit, piName, localId, subjectFirstName, subjectLastName, startTime, endTime, selectedMinutes, defaultResourceSchedule, temporaryResourceSchedule, alternateResources, rowCount);
            previousResource.set(resource);
            return overbookTimeLineData;
        };
        return RichList.enrich((List)resultRows).map(toOverbookTimelineDataResponseDTO).toList();
    }

    private List<Map<String, String>> getDefaultResourceSchedule(List<Date> selectedDates, Integer resource) {
        List dayOfWeeks = RichList.enrich(selectedDates).map(date -> DateUtility.getDayOfTheWeek(date)).toList();
        List defaultSchedules = RichList.enrich((List)dayOfWeeks).flatMapList(day -> this.findResourceScheduleByResource(resource, (Integer)day, false)).toList();
        Function<ResourceSchedule, Map> toDefaultScheduleMap = schedule -> Pairs.toMap((Pair[])new Pair[]{Pair.pair((Object)"defaultScheduleTime", (Object)(DateUtility.retrieveDayOfWeek(schedule.getDayOfWeek()) + ": " + DateUtility.format(DateUtility.clockHourMin(), schedule.getStartTime()) + " - " + DateUtility.format(DateUtility.clockHourMin(), schedule.getEndTime()))), Pair.pair((Object)"defaultScheduleQuantity", (Object)String.valueOf(schedule.getQuantity()))});
        return RichList.enrich((List)defaultSchedules).map(toDefaultScheduleMap).toList();
    }

    private List<Map<String, String>> getTemporaryResourceSchedule(Date startDate, Date endDate, Integer resource) {
        List<ResourceSchedule> exceptionSchedules = this.findExceptionSchedule(resource, startDate, endDate, true);
        Function<ResourceSchedule, Map> toExceptionScheduleMap = schedule -> Pairs.toMap((Pair[])new Pair[]{Pair.pair((Object)"exceptionScheduleTime", (Object)(DateUtility.format(DateUtility.dateTime(), schedule.getStartTime()) + " - " + DateUtility.format(DateUtility.dateTime(), schedule.getEndTime()))), Pair.pair((Object)"exceptionScheduleQuantity", (Object)String.valueOf(schedule.getQuantity()))});
        return RichList.enrich(exceptionSchedules).map(toExceptionScheduleMap).toList();
    }

    private int getResourceCount(int resource, Date startDate, Date endDate) {
        String findResourceCount = "SELECT br FROM BookedResource br, BookedVisit bv, Resource r  WHERE r.id = :resource AND br.resource = r.id and br.bookedVisit = bv.id and bv.appointmentStatus IN (1,2) and     ((:startTime between br.scheduledStartTime                   and br.scheduledEndTime)                   or (:endTime between br.scheduledStartTime                  and br.scheduledEndTime)                   or (br.scheduledStartTime > :startTime and                   br.scheduledEndTime < :endTime)) ORDER BY br.scheduledStartTime ";
        Query query = this.newQuery("SELECT br FROM BookedResource br, BookedVisit bv, Resource r  WHERE r.id = :resource AND br.resource = r.id and br.bookedVisit = bv.id and bv.appointmentStatus IN (1,2) and     ((:startTime between br.scheduledStartTime                   and br.scheduledEndTime)                   or (:endTime between br.scheduledStartTime                  and br.scheduledEndTime)                   or (br.scheduledStartTime > :startTime and                   br.scheduledEndTime < :endTime)) ORDER BY br.scheduledStartTime ");
        query.setParameter("resource", (Object)resource);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        List dateRangeList = query.list();
        return this.isOverlappingDates(dateRangeList);
    }

    public int isOverlappingDates(List<BookedResource> dateRangeList) {
        int rowCount = 0;
        Date latestEndTimeRow1 = dateRangeList.get(0).getScheduledEndTime();
        Date latestEndTimeRow2 = dateRangeList.get(0).getScheduledEndTime();
        for (int index1 = 1; index1 < dateRangeList.size(); ++index1) {
            Date startDate = dateRangeList.get(index1).getScheduledStartTime();
            Date endDate = dateRangeList.get(index1).getScheduledEndTime();
            if (startDate.getTime() >= latestEndTimeRow1.getTime()) {
                latestEndTimeRow1 = endDate;
                if (rowCount != 0) continue;
                latestEndTimeRow2 = endDate;
                continue;
            }
            if (startDate.getTime() < latestEndTimeRow1.getTime() && startDate.getTime() < latestEndTimeRow2.getTime()) {
                latestEndTimeRow2 = endDate;
                ++rowCount;
                continue;
            }
            if (startDate.getTime() >= latestEndTimeRow2.getTime()) {
                latestEndTimeRow2 = endDate;
                continue;
            }
            if (startDate.getTime() >= latestEndTimeRow2.getTime()) continue;
            latestEndTimeRow2 = endDate;
            ++rowCount;
        }
        return rowCount;
    }

    public List<ResourceSchedule> findExceptionSchedule(Integer resourceId, Date startDate, Date endDate, boolean override) {
        Resource resource = this.findById(Resource.class, resourceId);
        String findExceptionSchedule = "SELECT s FROM ResourceSchedule s WHERE s.resource = :resource AND  s.override = :override  AND  ((:startTime between s.startTime and s.endTime)  or (:endTime between s.startTime and s.endTime)  or (s.startTime >= :startTime and s.endTime <= :endTime)) ORDER BY s.startTime";
        Query query = this.session().createQuery("SELECT s FROM ResourceSchedule s WHERE s.resource = :resource AND  s.override = :override  AND  ((:startTime between s.startTime and s.endTime)  or (:endTime between s.startTime and s.endTime)  or (s.startTime >= :startTime and s.endTime <= :endTime)) ORDER BY s.startTime");
        query.setParameter("resource", (Object)resource);
        query.setParameter("override", (Object)override);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        return query.list();
    }

    public String findAlternateResourcesString(Integer resourceId) {
        Resource resource = this.findById(Resource.class, resourceId);
        String hql = "select ra.alternateResource.name from ResourceAlternate ra where ra.sourceResource = :resource order by ra.alternateResource.name";
        Query query = this.newQuery("select ra.alternateResource.name from ResourceAlternate ra where ra.sourceResource = :resource order by ra.alternateResource.name");
        query.setParameter("resource", (Object)resource);
        List list = query.list();
        return Joiner.on((String)", ").join((Iterable)list);
    }

    public List<ResourceSchedule> findResourceScheduleByResource(Integer resourceId, Integer dayOfWeek, boolean override) {
        Resource resource = this.findById(Resource.class, resourceId);
        Criteria crit = this.newCriteria(ResourceSchedule.class);
        crit.add((Criterion)Restrictions.eq((String)"resource", (Object)resource));
        crit.add((Criterion)Restrictions.eq((String)"dayOfWeek", (Object)dayOfWeek));
        crit.add((Criterion)Restrictions.eq((String)"override", (Object)override));
        crit.addOrder(Order.asc((String)"startTime"));
        return crit.list();
    }

    public TemplateResource findTemplateResourceById(int id) {
        return this.findById(TemplateResource.class, id);
    }

    public CancellationStatus findCancellationStatusById(int id) {
        return this.findById(CancellationStatus.class, id);
    }

    public AppointmentStatus findScheduledStatus() {
        Criteria crit = this.newCriteria(AppointmentStatus.class);
        crit.add((Criterion)Restrictions.eq((String)"id", (Object)SCHEDULE_ID));
        return (AppointmentStatus)crit.uniqueResult();
    }

    public TemplateResourceGroup findTemplateResourceGroup(TemplateResource templateResource) {
        VisitTemplate visit = templateResource.getVisitTemplate();
        String groupId = templateResource.getGroupId();
        Criteria criteria = this.newCriteria(TemplateResourceGroup.class);
        criteria.add((Criterion)Restrictions.eq((String)"visit", (Object)visit));
        criteria.add((Criterion)Restrictions.eq((String)"templateResource", (Object)templateResource));
        criteria.add((Criterion)Restrictions.eq((String)"groupId", (Object)groupId));
        List result = criteria.list();
        return (TemplateResourceGroup)result.get(0);
    }

    public List<TemplateResourceGroup> findTrgListByGroupId(String group) {
        Criteria criteria = this.newCriteria(TemplateResourceGroup.class);
        criteria.add((Criterion)Restrictions.eq((String)"groupId", (Object)group));
        return criteria.list();
    }

    public List<TemplateResourceAnnotations> findTemplateResourceAnnotationsByTemplateResource(TemplateResource templateResource) {
        Criteria criteria = this.newCriteria(TemplateResourceAnnotations.class);
        criteria.add((Criterion)Restrictions.eq((String)"templateResource", (Object)templateResource));
        return criteria.list();
    }

    public AppointmentStatus findCheckedInStatus() {
        Criteria crit = this.newCriteria(AppointmentStatus.class);
        crit.add((Criterion)Restrictions.eq((String)"id", (Object)CHECKIN_ID));
        return (AppointmentStatus)crit.uniqueResult();
    }

    public AppointmentStatus findCheckedOutStatus() {
        Criteria crit = this.newCriteria(AppointmentStatus.class);
        crit.add((Criterion)Restrictions.eq((String)"id", (Object)CHECKOUT_ID));
        return (AppointmentStatus)crit.uniqueResult();
    }

    public AppointmentStatus findCancelledStatus() {
        Criteria crit = this.newCriteria(AppointmentStatus.class);
        crit.add((Criterion)Restrictions.eq((String)"id", (Object)CANCEL_ID));
        return (AppointmentStatus)crit.uniqueResult();
    }

    public List<BookedResource> findBookedResourcesByBookedVisit(BookedVisit bookedVisit) {
        String findBookedVisit = "SELECT a FROM BookedResource a WHERE  a.bookedVisit = :bookedVisit order by a.scheduledStartTime";
        Query query = this.newQuery("SELECT a FROM BookedResource a WHERE  a.bookedVisit = :bookedVisit order by a.scheduledStartTime");
        query.setParameter("bookedVisit", (Object)bookedVisit);
        return query.list();
    }

    public Date findLatestBookedResourcesByBookedVisit(BookedVisit bookedVisit) {
        String findBookedVisit = "SELECT a.scheduledEndTime FROM BookedResource a WHERE  a.bookedVisit = :bookedVisit order by a.scheduledEndTime DESC";
        Query query = this.newQuery("SELECT a.scheduledEndTime FROM BookedResource a WHERE  a.bookedVisit = :bookedVisit order by a.scheduledEndTime DESC");
        query.setParameter("bookedVisit", (Object)bookedVisit);
        query.setFirstResult(0);
        query.setMaxResults(1);
        return (Date)query.uniqueResult();
    }

    public boolean findBookedResourcesByBookedVisit(TemplateResource templateResource) {
        String findBookedVisit = "SELECT a FROM BookedResource a WHERE  a.templateResource = :templateResource ";
        Query query = this.newQuery("SELECT a FROM BookedResource a WHERE  a.templateResource = :templateResource ");
        query.setParameter("templateResource", (Object)templateResource);
        return query.list().size() > 0;
    }

    public BookedResource findBookedResourceById(Integer id) {
        return this.findById(BookedResource.class, id);
    }

    public AppointmentOverrideReason findAppointmentOverrideReasonById(Integer id) {
        return this.findById(AppointmentOverrideReason.class, id);
    }

    public AppointmentStatusReason findAppointmentStatusReasonById(Integer id) {
        return this.findById(AppointmentStatusReason.class, id);
    }

    public List<VisitCommentsResponse.VisitComment> findAppointmentCommentsByVisit(BookedVisit visit) {
        Criteria criteria = this.newCriteria(Comments.class);
        criteria.add((Criterion)Restrictions.eq((String)"bookedVisit", (Object)visit));
        return VisitCommentsResponse.fromTemplateApprovalHistoryList(criteria.list());
    }

    public List<TemplateResource> getSingleFloatTemplateResources(VisitTemplate selectedVisit) {
        String findFloatTemplateResource = "SELECT tr FROM TemplateResource tr WHERE  tr.visitTemplate = :visit AND tr.floatable = true AND tr.groupId IS NULL ";
        Query query = this.newQuery("SELECT tr FROM TemplateResource tr WHERE  tr.visitTemplate = :visit AND tr.floatable = true AND tr.groupId IS NULL ");
        query.setParameter("visit", (Object)selectedVisit);
        return query.list();
    }

    public List<TemplateResourceGroup> getTemplateResourceGroups(VisitTemplate selectedVisit, boolean isGrouped) {
        String findTemplateResourceGroups = "SELECT trg FROM TemplateResourceGroup trg WHERE  trg.visit = :visit AND trg.flexGroup = :flexGroup ";
        Query query = this.newQuery("SELECT trg FROM TemplateResourceGroup trg WHERE  trg.visit = :visit AND trg.flexGroup = :flexGroup ");
        query.setParameter("visit", (Object)selectedVisit);
        query.setParameter("flexGroup", (Object)isGrouped);
        return query.list();
    }

    public BookedResource findOrderedBookedResource(BookedVisit bookedVisit, String columnSort, String orderBy) {
        String findBookedVisit = "SELECT a FROM BookedResource a WHERE  a.bookedVisit = :bookedVisit order by " + columnSort + " " + orderBy;
        Query query = this.newQuery(findBookedVisit);
        query.setParameter("bookedVisit", (Object)bookedVisit);
        query.setFirstResult(0);
        query.setMaxResults(1);
        List brs = query.list();
        return (BookedResource)brs.get(0);
    }

    public List<BookedResource> findRoomBookedResourcesByBookedVisit(int bookedVisit) {
        String findBookedVisit = "SELECT a FROM BookedResource a, Resource r, BookedVisit bv  WHERE  a.bookedVisit = bv.id and bv.id = :bookedVisit and a.resource = r.id and r.resourceType = 'Room'";
        Query query = this.newQuery("SELECT a FROM BookedResource a, Resource r, BookedVisit bv  WHERE  a.bookedVisit = bv.id and bv.id = :bookedVisit and a.resource = r.id and r.resourceType = 'Room'");
        query.setParameter("bookedVisit", (Object)bookedVisit);
        return query.list();
    }

    public List<BookedResourcesResponse> getBookedResourcesListByBookedVisit(int bookedVisit, String sortBy, String orderBy, int page, int maxResults) {
        String sortOn = sortBy;
        if (sortBy.equalsIgnoreCase("br.scheduled_start_time")) {
            sortOn = " br.scheduled_start_time " + orderBy + ", br.scheduled_end_time ";
        } else if (sortBy.equalsIgnoreCase("br.scheduled_end_time")) {
            sortOn = " br.scheduled_end_time " + orderBy + ", br.scheduled_start_time ";
        }
        String findBookedVisit = "SELECT br.id, r.name, group_concat(lla.name separator ', '), br.scheduled_start_time, br.scheduled_end_time  FROM booked_visit bv, resource r, booked_resource br  LEFT OUTER JOIN override_booked_resource_annotations obra ON obra.booked_resource = br.id  LEFT OUTER JOIN line_level_annotations lla ON obra.line_level_annotations = lla.id  WHERE br.booked_visit = bv.id and bv.id = :bookedVisit and br.resource = r.id  group by br.id order by " + sortOn + " " + orderBy;
        SQLQuery query = this.newSqlQuery(findBookedVisit);
        query.setParameter("bookedVisit", (Object)bookedVisit);
        int offSet = (page - 1) * maxResults;
        query.setFirstResult(offSet);
        query.setMaxResults(maxResults);
        List resultRows = query.list();
        ArrayList<BookedResourcesResponse> bookedResourcesResponseDTOs = new ArrayList<BookedResourcesResponse>();
        Long total = this.findBookedResourcesCount(bookedVisit);
        for (Object[] row : resultRows) {
            Integer bookedResource = (Integer)row[0];
            String resourceName = (String)row[1];
            String annotations = (String)row[2];
            Date scheduledStartTime = (Date)row[3];
            Date scheduledEndTime = (Date)row[4];
            BookedResourcesResponse bookedResourcesResponseDTO = new BookedResourcesResponse(bookedResource, resourceName, annotations, scheduledStartTime, scheduledEndTime, "", "", "", total, false);
            bookedResourcesResponseDTOs.add(bookedResourcesResponseDTO);
        }
        return bookedResourcesResponseDTOs;
    }

    Long findBookedResourcesCount(int bookedVisit) {
        String findCount = "SELECT count(br.id) FROM BookedResource br  WHERE br.bookedVisit.id = :bookedVisit";
        Query query = this.newQuery("SELECT count(br.id) FROM BookedResource br  WHERE br.bookedVisit.id = :bookedVisit").setParameter("bookedVisit", (Object)bookedVisit);
        return (Long)query.uniqueResult();
    }

    public static String findRoomString(int visit, Session session) {
        String hql = "select br.resource.name from BookedResource br where br.bookedVisit.id = :visit and br.resource.resourceType = 'Room' order by br.resource.name ASC";
        Query query = session.createQuery("select br.resource.name from BookedResource br where br.bookedVisit.id = :visit and br.resource.resourceType = 'Room' order by br.resource.name ASC");
        query.setParameter("visit", (Object)visit);
        List list = query.list();
        return Joiner.on((String)", ").join((Iterable)list);
    }

    public boolean canUserSeeBookedVisit(User user, Integer bookedVisitId) {
        boolean result = true;
        if (user.isStudyStaff()) {
            Query query = this.newQuery("select bv from Study s, StudyUser su, BookedVisit bv  where s.id = su.study    and :user = su.user    and bv.study = s.id    and bv.id = :bvId    and su.active=true    and s.studyStatus !=3");
            query.setParameter("user", (Object)user);
            query.setParameter("bvId", (Object)bookedVisitId);
            BookedVisit bookedVisit = (BookedVisit)query.uniqueResult();
            if (bookedVisit == null) {
                result = false;
            }
        }
        return result;
    }

    public List<CalendarVisitsResponse> getCalendarBookedVisits(String filterString, Date startDate, Date endDate, boolean homeView, List<Study> studies, boolean isStudyStaff) {
        boolean filterStringIsPresent;
        if (isStudyStaff && (studies == null || studies.isEmpty())) {
            return Lists.newArrayList();
        }
        String columnSqlList = CalendarBookedVisitsColumn.columnSqlList;
        List<String> columns = CalendarBookedVisitsColumn.columns;
        String findBookedVisit = this.getCalendatBookedVisitsQuery(columnSqlList);
        boolean bl = filterStringIsPresent = filterString != null && !filterString.isEmpty();
        if (filterStringIsPresent) {
            findBookedVisit = findBookedVisit + " and sublocation.name = :sublocation ";
        }
        if (isStudyStaff) {
            findBookedVisit = findBookedVisit + " and booked_visit.study IN (:studies) ";
        }
        findBookedVisit = findBookedVisit + " GROUP BY booked_visit.id ";
        Session session = this.session();
        SQLQuery query = session.createSQLQuery(findBookedVisit);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        if (filterStringIsPresent) {
            query.setParameter("sublocation", (Object)filterString);
        }
        query.setParameter("dayBeforeDate", (Object)this.getDayBeforeYesterday());
        if (isStudyStaff) {
            query.setParameterList("studies", studies);
        }
        for (String column : columns) {
            query.addScalar(column);
        }
        return AppointmentDAO.getCalendarVisitsDTOs(homeView, (Query)query, session);
    }

    public List<CalendarVisitsResponse> findBookedVisitsByResource(String resource, List<Study> studies, Date startDate, Date endDate, boolean homeView) {
        String columnSqlList = CalendarBookedVisitsColumn.columnSqlList;
        List<String> columns = CalendarBookedVisitsColumn.columns;
        String findBookedVisit = this.getCalendatBookedVisitsQuery(columnSqlList);
        if (studies != null && !studies.isEmpty()) {
            findBookedVisit = findBookedVisit + " and booked_visit.study in (:studies)";
        }
        findBookedVisit = findBookedVisit + " and resource.name = :resource GROUP BY booked_visit.id ";
        Session session = this.session();
        SQLQuery query = session.createSQLQuery(findBookedVisit);
        if (studies != null && !studies.isEmpty()) {
            query.setParameterList("studies", studies);
        }
        query.setParameter("resource", (Object)resource);
        query.setParameter("dayBeforeDate", (Object)this.getDayBeforeYesterday());
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        for (String column : columns) {
            query.addScalar(column);
        }
        return AppointmentDAO.getCalendarVisitsDTOs(homeView, (Query)query, session);
    }

    public List<CalendarVisitsResponse> findBookedVisitsByApppointmentStatus(int appointmentStatusId, Date startDate, Date endDate, boolean homeView, List<Study> studies, boolean isStudyStaff) {
        String columnSqlList = CalendarBookedVisitsColumn.columnSqlList;
        List<String> columns = CalendarBookedVisitsColumn.columns;
        String findBookedVisit = "SELECT " + columnSqlList + " " + "FROM " + "booked_visit, " + "booked_resource, " + "resource, " + "appointment_status, " + "study_subject, " + "subject, " + "visit_template, " + "sublocation, " + "study LEFT OUTER JOIN user ON user.id = study.principal_investigator " + "WHERE " + "booked_resource.booked_visit = booked_visit.id and " + "booked_resource.resource = resource.id and " + "booked_visit.visit_template = visit_template.id and " + "booked_visit.appointment_status = appointment_status.id and " + "booked_visit.study_subject = study_subject.id and " + "study_subject.subject = subject.id and " + "booked_visit.study = study.id and " + "visit_template.sublocation = sublocation.id and " + " appointment_status.id IN (:appointmentStatus) " + " and ((:startTime between booked_visit.scheduled_start_time and booked_visit.scheduled_end_time) " + " or (:endTime between booked_visit.scheduled_start_time and booked_visit.scheduled_end_time) " + " or (booked_visit.scheduled_start_time >= :startTime and booked_visit.scheduled_end_time <= :endTime))";
        if (studies != null && !studies.isEmpty()) {
            findBookedVisit = findBookedVisit + " and booked_visit.study in (:studies)";
        }
        if (CANCEL_ID.equals(appointmentStatusId)) {
            findBookedVisit = findBookedVisit + " and (booked_visit.cancel_date >= :twoDaysAgo)";
        }
        findBookedVisit = findBookedVisit + " GROUP BY booked_visit.id ";
        Session session = this.session();
        SQLQuery query = session.createSQLQuery(findBookedVisit);
        query.setParameter("appointmentStatus", (Object)appointmentStatusId);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        if (isStudyStaff) {
            query.setParameterList("studies", studies);
        }
        if (CANCEL_ID.equals(appointmentStatusId)) {
            Date twoDaysAgo = this.getDayBeforeYesterday();
            query.setParameter("twoDaysAgo", (Object)twoDaysAgo);
        }
        for (String column : columns) {
            query.addScalar(column);
        }
        return AppointmentDAO.getCalendarVisitsDTOs(homeView, (Query)query, session);
    }

    public List<CalendarVisitsResponse> findAllBookedVisitsByStudy(List<Study> study, Date startDate, Date endDate, boolean homeView) {
        String columnSqlList = CalendarBookedVisitsColumn.columnSqlList;
        List<String> columns = CalendarBookedVisitsColumn.columns;
        String findBookedVisit = this.getCalendatBookedVisitsQuery(columnSqlList) + " and booked_visit.study in (:study)  GROUP BY booked_visit.id ";
        Session session = this.session();
        SQLQuery query = session.createSQLQuery(findBookedVisit);
        query.setParameterList("study", study);
        query.setParameter("dayBeforeDate", (Object)this.getDayBeforeYesterday());
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        for (String column : columns) {
            query.addScalar(column);
        }
        return AppointmentDAO.getCalendarVisitsDTOs(homeView, (Query)query, session);
    }

    public List<CalendarVisitsResponse> findAllBookedVisitsByStudySubject(List<StudySubject> studySubject, Date startDate, Date endDate, boolean homeView) {
        String columnSqlList = CalendarBookedVisitsColumn.columnSqlList;
        List<String> columns = CalendarBookedVisitsColumn.columns;
        String findBookedVisit = this.getCalendatBookedVisitsQuery(columnSqlList) + " and booked_visit.study_subject in (:studySubjects) GROUP BY booked_visit.id ";
        Session session = this.session();
        SQLQuery query = session.createSQLQuery(findBookedVisit);
        query.setParameterList("studySubjects", studySubject);
        query.setParameter("dayBeforeDate", (Object)this.getDayBeforeYesterday());
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        for (String column : columns) {
            query.addScalar(column);
        }
        return AppointmentDAO.getCalendarVisitsDTOs(homeView, (Query)query, session);
    }

    static List<CalendarVisitsResponse> getCalendarVisitsDTOs(boolean homeView, Query query, Session session) {
        List resultRows = query.list();
        Function<Object[], CalendarVisitsResponse> toCalendarVisitsResponse = resultRow -> {
            Integer eventId = (Integer)resultRow[0];
            String appointmentStatus = (String)resultRow[1];
            String localId = (String)resultRow[2];
            String userLastName = (String)resultRow[3];
            String piLastName = userLastName != null ? userLastName : "";
            String visitName = (String)resultRow[4];
            String subjectLastName = SubjectDataEncryptor.decrypt((String)resultRow[5]);
            String scheduledStartTime = DateUtility.format(DateUtility.dateHourMinSec(), (Date)resultRow[6]);
            String scheduledEndTime = DateUtility.format(DateUtility.dateHourMinSec(), (Date)resultRow[7]);
            String visitType = VisitType.valueOf((String)resultRow[8]).getName();
            String rooms = AppointmentDAO.findRoomString(eventId, session);
            boolean allDay = AppointmentDAO.isAllDay(homeView, visitType);
            return new CalendarVisitsResponse(eventId, visitName, piLastName, rooms, localId, subjectLastName, appointmentStatus, scheduledStartTime, scheduledEndTime, allDay, visitType.contains("Inpatient"));
        };
        return RichList.enrich((List)resultRows).map(toCalendarVisitsResponse).toList();
    }

    private String getCalendatBookedVisitsQuery(String columnSqlList) {
        return "SELECT " + columnSqlList + " " + "FROM " + "booked_visit, " + "booked_resource, " + "resource, " + "appointment_status, " + "study_subject, " + "subject, " + "visit_template, " + "sublocation, " + "study LEFT OUTER JOIN user ON user.id = study.principal_investigator " + "WHERE " + "booked_resource.booked_visit = booked_visit.id and " + "booked_resource.resource = resource.id and " + "booked_visit.visit_template = visit_template.id and " + "booked_visit.appointment_status = appointment_status.id and " + "booked_visit.study_subject = study_subject.id and " + "study_subject.subject = subject.id and " + "booked_visit.study = study.id and " + "visit_template.sublocation = sublocation.id and " + " ((appointment_status.id IN (1,2,3)) OR (appointment_status.id = 4 AND booked_visit.cancel_date > :dayBeforeDate)) " + " and ((:startTime between booked_visit.scheduled_start_time and booked_visit.scheduled_end_time) " + " or (:endTime between booked_visit.scheduled_start_time and booked_visit.scheduled_end_time) " + " or (booked_visit.scheduled_start_time >= :startTime and booked_visit.scheduled_end_time <= :endTime))";
    }

    public List<BookedVisitsResponse> getOnlyTodaysBookedVisits(Date startDate, Date endDate, String sortBy, String orderBy, int page, int maxResults) {
        String findBookedVisit = "select bv.id, bv.visitTemplate.name, bv.study.irb, bv.study.catalystId, bv.study.localId,  bv.studySubject.subject.firstName, bv.studySubject.subject.lastName, bv.studySubject.subject.mrn, bv.appointmentStatus.name, bv.scheduledStartTime, bv.scheduledEndTime FROM BookedVisit bv, Study s where bv.study = s.id and ((bv.appointmentStatus IN (1,2,3))  OR (bv.appointmentStatus = 4 AND bv.cancelDate > :dayBeforeYesterday)) and  ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))  order by " + sortBy + " " + orderBy;
        Query query = this.newQuery(findBookedVisit);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        query.setParameter("dayBeforeYesterday", (Object)this.getDayBeforeYesterday());
        return this.getBookedVisitsResponses(page - 1, maxResults, query);
    }

    public List<BookedVisitsResponse> getOnlyTodaysBookedVisitsByStudy(List<Study> study, Date startDate, Date endDate, String sortBy, String orderBy, int page, int maxResults) {
        String findBookedVisit = "select bv.id, bv.visitTemplate.name, bv.study.irb, bv.study.catalystId, bv.study.localId,  bv.studySubject.subject.firstName, bv.studySubject.subject.lastName, bv.studySubject.subject.mrn, bv.appointmentStatus.name, bv.scheduledStartTime, bv.scheduledEndTime FROM BookedVisit bv where bv.study IN (:studies) and ((bv.appointmentStatus IN (1,2,3))  OR (bv.appointmentStatus = 4 AND bv.cancelDate > :dayBeforeDate))  and ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime)) order by " + sortBy + " " + orderBy;
        Query query = this.newQuery(findBookedVisit);
        query.setParameterList("studies", study);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        query.setParameter("dayBeforeDate", (Object)this.getDayBeforeYesterday());
        return this.getBookedVisitsResponses(page - 1, maxResults, query);
    }

    public List<BookedVisitsResponse> findAllBookedVisitsByStudyStaff(List<Study> study, String sortBy, String orderBy, int page, int maxResults, boolean initialLoad, Date fromDate, Date toDate) {
        int ofPage;
        String findBookedVisit = "select bv.id, bv.visitTemplate.name, bv.study.irb, bv.study.catalystId, bv.study.localId,  bv.studySubject.subject.firstName, bv.studySubject.subject.lastName, bv.studySubject.subject.mrn, bv.appointmentStatus.name, bv.scheduledStartTime, bv.scheduledEndTime FROM BookedVisit bv where bv.study in (:study) and ((bv.appointmentStatus IN (1,2,3))  OR (bv.appointmentStatus = 4 AND bv.cancelDate > :dayBeforeDate)) ";
        if (!initialLoad && fromDate != null) {
            findBookedVisit = findBookedVisit + " and ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))";
        }
        findBookedVisit = findBookedVisit + " ORDER BY " + sortBy + " " + orderBy;
        Query query = this.newQuery(findBookedVisit);
        query.setParameterList("study", study);
        query.setParameter("dayBeforeDate", (Object)this.getDayBeforeYesterday());
        if (initialLoad) {
            ofPage = (int)((this.getBookedVisitRowOffsetByStudy(study, toDate, sortBy, orderBy) + 1L) / (long)maxResults);
        } else {
            if (fromDate != null) {
                query.setParameter("startTime", (Object)fromDate);
                query.setParameter("endTime", (Object)toDate);
            }
            ofPage = page - 1;
        }
        return this.getBookedVisitsResponses(ofPage, maxResults, query);
    }

    public List<BookedVisitsResponse> getAllBookedVisits(String sortBy, String orderBy, int page, int maxResults, boolean initialLoad, Date fromDate, Date toDate) {
        int ofPage;
        String findBookedVisit = "select bv.id, bv.visitTemplate.name, bv.study.irb, bv.study.catalystId, bv.study.localId,  bv.studySubject.subject.firstName, bv.studySubject.subject.lastName, bv.studySubject.subject.mrn, bv.appointmentStatus.name, bv.scheduledStartTime, bv.scheduledEndTime FROM BookedVisit bv where ((bv.appointmentStatus IN (1,2,3))  OR (bv.appointmentStatus = 4 AND bv.cancelDate > :dayBeforeDate)) ";
        if (!initialLoad && fromDate != null) {
            findBookedVisit = findBookedVisit + " and ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))";
        }
        findBookedVisit = findBookedVisit + " ORDER BY " + sortBy + " " + orderBy;
        Query query = this.newQuery(findBookedVisit);
        query.setParameter("dayBeforeDate", (Object)this.getDayBeforeYesterday());
        if (initialLoad) {
            ofPage = (int)((this.getBookedVisitRowOffset(toDate, sortBy, orderBy) + 1L) / (long)maxResults);
        } else {
            if (fromDate != null) {
                query.setParameter("startTime", (Object)fromDate);
                query.setParameter("endTime", (Object)toDate);
            }
            ofPage = page - 1;
        }
        return this.getBookedVisitsResponses(ofPage, maxResults, query);
    }

    private Long getBookedVisitRowOffset(Date toDate, String sortBy, String orderBy) {
        String findBookedVisitOffset = "SELECT COUNT(bv) FROM BookedVisit bv WHERE (((bv.appointmentStatus IN (1,2,3))  OR (bv.appointmentStatus = 4 AND bv.cancelDate > :dayBeforeDate)) AND bv.scheduledStartTime < (:today))  ORDER BY " + sortBy + " " + orderBy;
        Query query = this.newQuery(findBookedVisitOffset);
        query.setParameter("today", (Object)toDate);
        query.setParameter("dayBeforeDate", (Object)this.getDayBeforeYesterday());
        return (Long)query.uniqueResult();
    }

    private Long getBookedVisitRowOffsetByStudy(List<Study> studyList, Date toDate, String sortBy, String orderBy) {
        String findBookedVisitOffset = "SELECT COUNT(bv) FROM BookedVisit bv WHERE (((bv.appointmentStatus IN (1,2,3))  OR (bv.appointmentStatus = 4 AND bv.cancelDate > :dayBeforeDate)) AND bv.study IN (:studies) AND bv.scheduledStartTime < (:today))  ORDER BY " + sortBy + " " + orderBy;
        Query query = this.newQuery(findBookedVisitOffset);
        query.setParameter("today", (Object)toDate);
        query.setParameterList("studies", studyList);
        query.setParameter("dayBeforeDate", (Object)this.getDayBeforeYesterday());
        return (Long)query.uniqueResult();
    }

    private Long getBookedVisitRowOffsetByStudySubject(List<StudySubject> studySubjectList, Date toDate, String sortBy, String orderBy) {
        String findBookedVisitOffset = "SELECT COUNT(bv) FROM BookedVisit bv WHERE (((bv.appointmentStatus IN (1,2,3))  OR (bv.appointmentStatus = 4 AND bv.cancelDate > :dayBeforeDate)) AND bv.studySubject IN (:studySubjects) AND bv.scheduledStartTime < (:today))  ORDER BY " + sortBy + " " + orderBy;
        Query query = this.newQuery(findBookedVisitOffset);
        query.setParameter("today", (Object)toDate);
        query.setParameterList("studySubjects", studySubjectList);
        query.setParameter("dayBeforeDate", (Object)this.getDayBeforeYesterday());
        return (Long)query.uniqueResult();
    }

    public List<BookedVisitsResponse> getBookedVisitsListByStudy(List<Study> study, String sortBy, String orderBy, int page, int maxResults, boolean initialLoad, Date fromDate, Date toDate) {
        if (study.size() > 0) {
            int ofPage;
            String findBookedVisit = "select bv.id, bv.visitTemplate.name, bv.study.irb, bv.study.catalystId, bv.study.localId,  bv.studySubject.subject.firstName, bv.studySubject.subject.lastName, bv.studySubject.subject.mrn, bv.appointmentStatus.name, bv.scheduledStartTime, bv.scheduledEndTime FROM BookedVisit bv where bv.study in (:study) and ((bv.appointmentStatus IN (1,2,3)) OR (bv.appointmentStatus = 4 AND bv.cancelDate > :dayBeforeDate)) ";
            if (!initialLoad && fromDate != null) {
                findBookedVisit = findBookedVisit + " and ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))";
            }
            findBookedVisit = findBookedVisit + " ORDER BY " + sortBy + " " + orderBy;
            Query query = this.newQuery(findBookedVisit);
            query.setParameter("dayBeforeDate", (Object)this.getDayBeforeYesterday());
            query.setParameterList("study", study);
            if (initialLoad) {
                ofPage = (int)((this.getBookedVisitRowOffsetByStudy(study, toDate, sortBy, orderBy) + 1L) / (long)maxResults);
            } else {
                if (fromDate != null) {
                    query.setParameter("startTime", (Object)fromDate);
                    query.setParameter("endTime", (Object)toDate);
                }
                ofPage = page - 1;
            }
            return this.getBookedVisitsResponses(ofPage, maxResults, query);
        }
        return null;
    }

    public List<BookedVisitsResponse> getBookedVisitsListBySubject(List<Subject> subject, String sortBy, String orderBy, int page, int maxResults, boolean initialLoad, Date fromDate, Date toDate) {
        ArrayList<StudySubject> totalStudySubjectList = new ArrayList<StudySubject>();
        for (Subject subs : subject) {
            List<StudySubject> studySubjectListBySubject = this.findStudySubjectBySubject(subs);
            totalStudySubjectList.addAll(studySubjectListBySubject);
        }
        return this.getListOfBookedVisitBySubjects(totalStudySubjectList, sortBy, orderBy, page, maxResults, initialLoad, fromDate, toDate);
    }

    public List<BookedVisitsResponse> getBookedVisitsListBySubjectAndStudy(List<Study> studies, List<Subject> subject, String sortBy, String orderBy, int page, int maxResults, boolean initialLoad, Date fromDate, Date toDate) {
        List totalStudySubjectList = RichList.enrich(subject).flatMap(subs -> RichList.enrich((List)studies).flatMap(study -> RichList.enrich(this.findStudySubjectBySubjectAndStudy((Subject)subs, (Study)study)))).toList();
        return this.getListOfBookedVisitBySubjects(totalStudySubjectList, sortBy, orderBy, page, maxResults, initialLoad, fromDate, toDate);
    }

    public List<StudySubject> findStudySubjectBySubject(Subject subject) {
        Criteria crit = this.newCriteria(StudySubject.class).add((Criterion)Restrictions.eq((String)"subject", (Object)subject));
        return crit.list();
    }

    public List<StudySubject> findStudySubjectBySubjectAndStudy(Subject subject, Study study) {
        Criteria crit = this.newCriteria(StudySubject.class);
        crit.add((Criterion)Restrictions.eq((String)"subject", (Object)subject));
        crit.add((Criterion)Restrictions.eq((String)"study", (Object)study));
        return crit.list();
    }

    public List<BookedVisitsResponse> getListOfBookedVisitBySubjects(List<StudySubject> studySubjects, String sortBy, String orderBy, int page, int maxResults, boolean initialLoad, Date fromDate, Date toDate) {
        if (studySubjects != null && !studySubjects.isEmpty()) {
            int ofPage;
            boolean hasFromDate;
            String findBookedVisit = "select bv.id, bv.visitTemplate.name, bv.study.irb, bv.study.catalystId, bv.study.localId,  bv.studySubject.subject.firstName, bv.studySubject.subject.lastName, bv.studySubject.subject.mrn, bv.appointmentStatus.name, bv.scheduledStartTime, bv.scheduledEndTime FROM BookedVisit bv where bv.studySubject in(:studySubjects) and ((bv.appointmentStatus IN (1,2,3)) OR (bv.appointmentStatus = 4 AND bv.cancelDate > :dayBeforeDate)) ";
            boolean bl = hasFromDate = fromDate != null;
            if (!initialLoad && hasFromDate) {
                findBookedVisit = findBookedVisit + " and ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))";
            }
            findBookedVisit = findBookedVisit + " ORDER BY " + sortBy + " " + orderBy;
            Query query = this.newQuery(findBookedVisit);
            query.setParameter("dayBeforeDate", (Object)this.getDayBeforeYesterday());
            query.setParameterList("studySubjects", studySubjects);
            if (initialLoad) {
                ofPage = (int)((this.getBookedVisitRowOffsetByStudySubject(studySubjects, toDate, sortBy, orderBy) + 1L) / (long)maxResults);
            } else {
                if (hasFromDate) {
                    query.setParameter("startTime", (Object)fromDate);
                    query.setParameter("endTime", (Object)toDate);
                }
                ofPage = page - 1;
            }
            return this.getBookedVisitsResponses(ofPage, maxResults, query);
        }
        return null;
    }

    private List<BookedVisitsResponse> getBookedVisitsResponses(int page, int maxResults, Query query) {
        Long total = query.list().size();
        int offset = page * maxResults;
        query.setFirstResult(offset);
        query.setMaxResults(maxResults);
        List resultRows = query.list();
        Function<Object[], BookedVisitsResponse> toBookedVisitsResponse = resultRow -> {
            Integer bvId = (Integer)resultRow[0];
            String visitName = (String)resultRow[1];
            String irb = (String)resultRow[2];
            String catId = (String)resultRow[3];
            String localId = (String)resultRow[4];
            String subjectFirstName = SubjectDataEncryptor.decrypt((String)resultRow[5]);
            String subjectLastName = SubjectDataEncryptor.decrypt((String)resultRow[6]);
            String subjectMrn = SubjectDataEncryptor.decrypt((String)resultRow[7]);
            String apptStatusName = (String)resultRow[8];
            Date scheduledStartTime = (Date)resultRow[9];
            Date scheduledEndTime = (Date)resultRow[10];
            return new BookedVisitsResponse(bvId, visitName, irb, catId, localId, subjectLastName + ", " + subjectFirstName, subjectMrn, apptStatusName, scheduledStartTime, scheduledEndTime, total, page);
        };
        return RichList.enrich((List)resultRows).map(toBookedVisitsResponse).toList();
    }

    public boolean findConflictingBookedVisitsBySubject(Integer subject, Date startDate, Date endDate) {
        String findBookedVisit = "SELECT bv.id FROM BookedVisit bv, Subject s, StudySubject ss WHERE   bv.studySubject = ss.id AND ss.subject = s.id AND s.id = :subject   AND bv.appointmentStatus IN (1,2)  AND (   (:startTime >= bv.scheduledStartTime AND :startTime < bv.scheduledEndTime)  or (:endTime > bv.scheduledStartTime AND :endTime <= bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime AND bv.scheduledEndTime <= :endTime) )";
        Query query = this.newQuery("SELECT bv.id FROM BookedVisit bv, Subject s, StudySubject ss WHERE   bv.studySubject = ss.id AND ss.subject = s.id AND s.id = :subject   AND bv.appointmentStatus IN (1,2)  AND (   (:startTime >= bv.scheduledStartTime AND :startTime < bv.scheduledEndTime)  or (:endTime > bv.scheduledStartTime AND :endTime <= bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime AND bv.scheduledEndTime <= :endTime) )");
        query.setParameter("subject", (Object)subject);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        return query.list().size() == 0;
    }

    public BookedVisit findBookedVisitById(int id) {
        BookedVisit bv = this.findById(BookedVisit.class, id);
        if (bv != null) {
            StudySubject studySubject = bv.getStudySubject();
            SubjectDataEncryptor.decryptSubjectWithinStudySubject(studySubject);
        }
        return bv;
    }

    public GetStudySubjectsResponse getAllStudySubjectsByStudy(Study study, Optional<String> nullableFilterString, Integer ofPage, Integer ofMaxResults, String ofSortBy, String ofOrderBy, Boolean ofWantAll) {
        String filterString = nullableFilterString.orElse("");
        boolean filterStringIsPresent = !filterString.isEmpty();
        List<StudySubject> resultRows = this.findStudySubjectsByStudyClausically(study, ofWantAll);
        List<StudySubject> finalList = RichList.enrich(resultRows).map(studySubject -> {
            SubjectDataEncryptor.decryptSubjectWithinStudySubject(studySubject);
            return studySubject;
        }).filter(studySubject -> {
            Subject decryptedSubject = studySubject.getSubject();
            boolean matches = decryptedSubject.getMrn().contains(filterString.toUpperCase()) || decryptedSubject.getLastName().contains(filterString.toUpperCase());
            return filterStringIsPresent && matches;
        }).toList();
        List<StudySubject> resultRowsToSort = filterStringIsPresent ? finalList : resultRows;
        int total = resultRowsToSort.size();
        this.sortStudySubjectData(ofSortBy, ofOrderBy, resultRowsToSort);
        List<StudySubject> filteredRows = this.paginateStudySubjectData(ofPage, ofMaxResults, resultRowsToSort, total);
        return GetStudySubjectsResponse.createGetStudiesSubjectsResponse(filteredRows, Long.valueOf(total));
    }

    private List<StudySubject> paginateStudySubjectData(Integer ofPage, Integer ofMaxResults, List<StudySubject> resultRows, int total) {
        int offset = (ofPage - 1) * ofMaxResults;
        List<StudySubject> filteredRows = offset + ofMaxResults <= total ? resultRows.subList(offset, offset + ofMaxResults) : (offset + ofMaxResults > total ? resultRows.subList(offset, total) : new ArrayList<StudySubject>());
        return filteredRows;
    }

    private void sortStudySubjectData(String ofSortBy, String ofOrderBy, List<StudySubject> resultRows) {
        if (ofOrderBy.equalsIgnoreCase("ASC")) {
            this.sortStudySubjectAscending(ofSortBy, resultRows);
        } else if (ofOrderBy.equalsIgnoreCase("DESC")) {
            this.sortStudySubjectDescending(ofSortBy, resultRows);
        }
    }

    private void sortStudySubjectDescending(String ofSortBy, List<StudySubject> resultRows) {
        if (ofSortBy.equalsIgnoreCase("lastName")) {
            Collections.sort(resultRows, GetStudySubjectsResponse.StudySubjectLastNameComparatorDesc);
        } else if (ofSortBy.equalsIgnoreCase("mrn")) {
            Collections.sort(resultRows, GetStudySubjectsResponse.StudySubjectMRNComparatorDesc);
        } else if (ofSortBy.equalsIgnoreCase("firstName")) {
            Collections.sort(resultRows, GetStudySubjectsResponse.StudySubjectFirstNameComparatorDesc);
        } else if (ofSortBy.equalsIgnoreCase("primaryContactNumber")) {
            Collections.sort(resultRows, GetStudySubjectsResponse.StudySubjectContactComparatorDesc);
        } else if (ofSortBy.equalsIgnoreCase("birthdate")) {
            Collections.sort(resultRows, GetStudySubjectsResponse.StudySubjectBirthdateComparatorDesc);
        } else if (ofSortBy.equalsIgnoreCase("city")) {
            Collections.sort(resultRows, GetStudySubjectsResponse.StudySubjectCityComparatorDesc);
        }
    }

    private void sortStudySubjectAscending(String ofSortBy, List<StudySubject> resultRows) {
        if (ofSortBy.equalsIgnoreCase("lastName")) {
            Collections.sort(resultRows, GetStudySubjectsResponse.StudySubjectLastNameComparatorAsc);
        } else if (ofSortBy.equalsIgnoreCase("mrn")) {
            Collections.sort(resultRows, GetStudySubjectsResponse.StudySubjectMRNComparatorAsc);
        } else if (ofSortBy.equalsIgnoreCase("firstName")) {
            Collections.sort(resultRows, GetStudySubjectsResponse.StudySubjectFirstNameComparatorAsc);
        } else if (ofSortBy.equalsIgnoreCase("primaryContactNumber")) {
            Collections.sort(resultRows, GetStudySubjectsResponse.StudySubjectContactComparatorAsc);
        } else if (ofSortBy.equalsIgnoreCase("birthdate")) {
            Collections.sort(resultRows, GetStudySubjectsResponse.StudySubjectBirthdateComparatorAsc);
        } else if (ofSortBy.equalsIgnoreCase("city")) {
            Collections.sort(resultRows, GetStudySubjectsResponse.StudySubjectCityComparatorAsc);
        }
    }

    public List<StudySubject> findStudySubjectsByStudyClausically(Study study, Boolean ofWantAll) {
        String findStudySubjects = "SELECT ss FROM StudySubject ss, Subject su ";
        HqlClauses.WhereBuilder builder = HqlClauses.whereBuilder();
        builder.equalTo(Optional.of(":study"), "ss.study").equalTo(Optional.of("ss.subject"), "su.id").equalTo(Optional.of("true"), "su.active");
        if (!ofWantAll.booleanValue()) {
            builder.equalTo(Optional.of("true"), "ss.active");
        }
        String whereClause = builder.build();
        findStudySubjects = findStudySubjects + whereClause;
        Query mainQuery = this.newQuery(findStudySubjects).setParameter("study", (Object)study);
        return mainQuery.list();
    }

    public Date getDayBeforeYesterday() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -2);
        return new Date(calendar.getTimeInMillis());
    }

    public List<BookedResource> findBookedResources(Resource sharedResource) {
        String findBookedResources = "SELECT br FROM BookedVisit bv, BookedResource br, AppointmentStatus ap WHERE   br.bookedVisit = bv.id AND bv.appointmentStatus = ap.id AND br.resource = :resource   AND bv.appointmentStatus IN (1,2) ";
        Query query = this.newQuery("SELECT br FROM BookedVisit bv, BookedResource br, AppointmentStatus ap WHERE   br.bookedVisit = bv.id AND bv.appointmentStatus = ap.id AND br.resource = :resource   AND bv.appointmentStatus IN (1,2) ").setParameter("resource", (Object)sharedResource);
        return query.list();
    }

    private static final class CalendarBookedVisitsColumn {
        static final List<String> columns = Arrays.asList("booked_visit.id", "appointment_status.name", "study.local_id", "user.last_name", "booked_visit.name", "subject.last_name", "booked_visit.scheduled_start_time", "booked_visit.scheduled_end_time", "booked_visit.type");
        static final String columnSqlList = Joiner.on((String)", ").join(columns);

        private CalendarBookedVisitsColumn() {
        }
    }

    private static final class Ref<A> {
        private A a;

        Ref(A a) {
            this.a = a;
        }

        A get() {
            return this.a;
        }

        void set(A a) {
            this.a = a;
        }
    }
}

