/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.persistence;

import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.dto.response.SubjectDetailResponse;
import edu.harvard.catalyst.scheduler.dto.response.SubjectsResponse;
import edu.harvard.catalyst.scheduler.entity.InstitutionRole;
import edu.harvard.catalyst.scheduler.entity.StudySubject;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.persistence.SubjectDAO;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class EpicSubjectDAO
extends SubjectDAO {
    private static final Logger LOG = Logger.getLogger(SchedulerRuntimeException.class);

    void refreshSubjectsFromEpic() {
    }

    void refreshSubjectsFromEpic(int id) {
    }

    @Override
    public SubjectsResponse getSubjectsList(String filterString, int maxResults, int page, String sortBy, String orderBy) {
        this.refreshSubjectsFromEpic();
        return super.getSubjectsList(filterString, maxResults, page, sortBy, orderBy);
    }

    @Override
    public List<Subject> findAllSubjects() {
        this.refreshSubjectsFromEpic();
        return super.findAllSubjects();
    }

    @Override
    public SubjectsResponse getStudyStaffSubjects(String lastName, String mrn, String bday, String subjectSchedulerId, String sortBy, String orderBy, String ipAddress, User user) {
        this.refreshSubjectsFromEpic();
        return super.getStudyStaffSubjects(lastName, mrn, bday, subjectSchedulerId, sortBy, orderBy, ipAddress, user);
    }

    @Override
    public Subject findBySubjectId(int id) {
        this.refreshSubjectsFromEpic(id);
        return super.findBySubjectId(id);
    }

    @Override
    public SubjectDetailResponse getSubjectDataById(int subjectId) {
        this.refreshSubjectsFromEpic(subjectId);
        return super.getSubjectDataById(subjectId);
    }

    @Override
    public StudySubject findStudySubjectById(Integer id) {
        this.refreshSubjectsFromEpic();
        return super.findStudySubjectById(id);
    }

    @Override
    public List<Subject> filterSubjectByLastNames(String lastName) {
        this.refreshSubjectsFromEpic();
        return super.filterSubjectByLastNames(lastName);
    }

    @Override
    public List<Subject> getSubjectByLastName(String lastName, InstitutionRole institutionRole) {
        this.refreshSubjectsFromEpic();
        return super.getSubjectByLastName(lastName, institutionRole);
    }

    @Override
    public List<Subject> filterSubjectsByMRN(String mrn, InstitutionRole institutionRole) {
        this.refreshSubjectsFromEpic();
        return super.filterSubjectsByMRN(mrn, institutionRole);
    }

    @Override
    public List<SubjectsResponse> findSubjectByLastNameMrnBdate(String lastName, String medicalRecordNumber, Date birthDate, String schedulerId) {
        this.refreshSubjectsFromEpic();
        return super.findSubjectByLastNameMrnBdate(lastName, medicalRecordNumber, birthDate, schedulerId);
    }

    @Override
    public List<Subject> findSubjectByLastNames(String lastName) {
        this.refreshSubjectsFromEpic();
        return super.findSubjectByLastNames(lastName);
    }

    @Override
    public boolean checkMrn(String mrn) {
        this.refreshSubjectsFromEpic();
        return super.checkMrn(mrn);
    }

    @Override
    public boolean checkSubjectSchedulerId(String subjectSchedulerId) {
        this.refreshSubjectsFromEpic();
        return super.checkSubjectSchedulerId(subjectSchedulerId);
    }

    private String complainUnsupported(String methodName) {
        String unsupported = methodName + " unsupported in Epic Subject Mode";
        LOG.info((Object)unsupported);
        return unsupported;
    }

    @Override
    public void createSubject(Subject entity) {
        throw new UnsupportedOperationException(this.complainUnsupported("createSubject"));
    }

    @Override
    public void editSubject(Subject entity) {
        throw new UnsupportedOperationException(this.complainUnsupported("editSubject"));
    }
}

