/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.persistence;

import edu.harvard.catalyst.hccrc.core.util.ListUtils;
import java.util.Optional;
import org.hibernate.criterion.Order;

public enum SortStrategy {
    ASCENDING(1, "ASC"){

        @Override
        public Order makeOrder(String columnName) {
            return Order.asc((String)columnName);
        }
    }
    ,
    DESCENDING(2, "DESC"){

        @Override
        public Order makeOrder(String columnName) {
            return Order.desc((String)columnName);
        }
    };

    public final int sortId;
    public final String orderTerm;

    public boolean isAscending() {
        return this == ASCENDING;
    }

    public boolean isDescending() {
        return this == DESCENDING;
    }

    private SortStrategy(int sortId, String orderTerm) {
        this.sortId = sortId;
        this.orderTerm = orderTerm;
    }

    public final String makeHqlOrderBySubClause(String columnName) {
        return " ORDER BY " + columnName + " " + this.orderTerm;
    }

    public abstract Order makeOrder(String var1);

    public static Optional<SortStrategy> fromOptionalId(Optional<String> idString) {
        return idString.flatMap(SortStrategy::fromIdString);
    }

    public static Optional<SortStrategy> fromIdString(String idString) {
        return ListUtils.enrich((Object[])SortStrategy.values()).find(strategy -> String.valueOf(strategy.sortId).equals(idString));
    }
}

