/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.hccrc.core;

import edu.harvard.catalyst.hccrc.core.HccrcUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.saml.SAMLCredential;
import org.springframework.security.saml.userdetails.SAMLUserDetailsService;

public class SamlUserDetailsService
implements SAMLUserDetailsService {
    private HccrcUserService userService;

    @Autowired
    public SamlUserDetailsService(HccrcUserService userService) {
        this.userService = userService;
    }

    public Object loadUserBySAML(SAMLCredential samlCredential) throws UsernameNotFoundException {
        String username = samlCredential.getNameID().getValue();
        UserDetails user = this.userService.findUserByName(username);
        if (user == null) {
            user = this.userService.handleNonExistentUser(username, username);
        }
        return user;
    }
}

