/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.hccrc.core.util;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.runtime.AbstractFunction0;
import scala.runtime.AbstractFunction1;
import scala.runtime.AbstractPartialFunction;

public final class ScalaFunctionWrappers {
    public static <A> Function0<A> asScalaBlock(Supplier<? extends A> f) {
        return new ScalaFunction0Adapter<A>(f);
    }

    public static <A> Function0<Void> asScalaBlock(Runnable f) {
        return new ScalaFunction0RunnableAdapter(f);
    }

    public static <A, B> Function1<A, B> asScalaFunction(Function<? super A, ? extends B> f) {
        return new ScalaFunction1Adapter<A, B>(f);
    }

    public static <A, B> PartialFunction<A, B> asScalaPartialFunction(Function<? super A, ? extends B> f) {
        return new ScalaPartialFunctionAdapter<A, B>(f);
    }

    public static <A> Function1<A, Boolean> asScalaPredicate(Predicate<? super A> p) {
        return ScalaFunctionWrappers.asScalaFunction(p::test);
    }

    private static final class ScalaPartialFunctionAdapter<A, B>
    extends AbstractPartialFunction<A, B> {
        private final Function<? super A, ? extends B> delegate;

        public ScalaPartialFunctionAdapter(Function<? super A, ? extends B> delegate) {
            this.delegate = delegate;
        }

        public B apply(A arg) {
            return this.delegate.apply(arg);
        }

        public boolean isDefinedAt(A arg) {
            return true;
        }
    }

    private static final class ScalaFunction1Adapter<A, B>
    extends AbstractFunction1<A, B> {
        private final Function<? super A, ? extends B> delegate;

        public ScalaFunction1Adapter(Function<? super A, ? extends B> delegate) {
            this.delegate = delegate;
        }

        public B apply(A arg) {
            return this.delegate.apply(arg);
        }
    }

    private static final class ScalaFunction0RunnableAdapter
    extends AbstractFunction0<Void> {
        private final Runnable delegate;

        public ScalaFunction0RunnableAdapter(Runnable delegate) {
            this.delegate = delegate;
        }

        public Void apply() {
            this.delegate.run();
            return null;
        }
    }

    private static final class ScalaFunction0Adapter<R>
    extends AbstractFunction0<R> {
        private final Supplier<? extends R> delegate;

        public ScalaFunction0Adapter(Supplier<? extends R> delegate) {
            this.delegate = delegate;
        }

        public R apply() {
            return this.delegate.get();
        }
    }
}

