/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.hccrc.core.util;

import edu.harvard.catalyst.hccrc.core.util.QuietRunnable;
import edu.harvard.catalyst.hccrc.core.util.QuietSupplier;
import edu.harvard.catalyst.hccrc.core.util.ScalaFunctionWrappers;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try$;

public final class Try<A> {
    private final scala.util.Try<A> delegate;

    Try(scala.util.Try<A> delegate) {
        this.delegate = delegate;
    }

    scala.util.Try<A> getDelegate() {
        return this.delegate;
    }

    public static <A> Try<A> of(A initial) {
        return new Try<A>(new Success(initial));
    }

    public static <A> Try<A> attempt(QuietSupplier<? extends A> block) {
        return new Try<A>(Try.companion().apply(ScalaFunctionWrappers.asScalaBlock(block)));
    }

    public static Try<Void> attempt(QuietRunnable block) {
        return new Try<Void>(Try.companion().apply(ScalaFunctionWrappers.asScalaBlock(block)));
    }

    public <B> Try<B> map(Function<? super A, ? extends B> f) {
        return new Try<A>(this.delegate.map(ScalaFunctionWrappers.asScalaFunction(f)));
    }

    public <B> Try<B> flatMap(Function<? super A, ? extends Try<B>> f) {
        return new Try<A>(this.delegate.flatMap(ScalaFunctionWrappers.asScalaFunction(Try.returnsDelegate(f))));
    }

    public Try<A> filter(Predicate<? super A> p) {
        return new Try<A>(this.delegate.filter(ScalaFunctionWrappers.asScalaFunction(p::test)));
    }

    public A get() {
        return (A)this.delegate.get();
    }

    public A orElse(A defaultValue) {
        return this.delegate.isSuccess() ? this.get() : defaultValue;
    }

    public A orElseGet(Supplier<? extends A> defaultValue) {
        return this.delegate.isSuccess() ? this.get() : defaultValue.get();
    }

    public Optional<Throwable> asFailure() {
        if (this.delegate.isSuccess()) {
            return Optional.empty();
        }
        return Optional.of(((Failure)this.delegate).exception());
    }

    public Optional<A> asSuccess() {
        if (this.delegate.isFailure()) {
            return Optional.empty();
        }
        return Optional.of(this.get());
    }

    public Optional<A> toOptional() {
        return this.asSuccess();
    }

    public boolean isFailure() {
        return this.delegate.isFailure();
    }

    public boolean isSuccess() {
        return this.delegate.isSuccess();
    }

    public Try<A> recover(Function<? super Throwable, ? extends A> recoveryFn) {
        return new Try<A>(this.delegate.recover(ScalaFunctionWrappers.asScalaPartialFunction(recoveryFn)));
    }

    public Try<A> recoverWith(Function<? super Throwable, ? extends Try<A>> recoveryFn) {
        return new Try<A>(this.delegate.recoverWith(ScalaFunctionWrappers.asScalaPartialFunction(Try.returnsDelegate(recoveryFn))));
    }

    private static final <X, Y> Function<X, scala.util.Try<Y>> returnsDelegate(Function<? super X, ? extends Try<Y>> f) {
        return x -> ((Try)f.apply((Object)x)).getDelegate();
    }

    private static final Try$ companion() {
        return Try$.MODULE$;
    }

    public String toString() {
        return "Try [delegate=" + this.delegate + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Try other = (Try)obj;
        return !(this.delegate == null ? other.delegate != null : !this.delegate.equals(other.delegate));
    }
}

