/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ReadHandler;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServerProbe;
import org.glassfish.grizzly.http.server.HttpServerProbeNotifier;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.ServerFilterConfiguration;
import org.glassfish.grizzly.http.server.SuspendStatus;
import org.glassfish.grizzly.http.server.util.HtmlHelper;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.monitoring.jmx.AbstractJmxMonitoringConfig;
import org.glassfish.grizzly.monitoring.jmx.JmxMonitoringAware;
import org.glassfish.grizzly.monitoring.jmx.JmxMonitoringConfig;
import org.glassfish.grizzly.monitoring.jmx.JmxObject;
import org.glassfish.grizzly.utils.DelayedExecutor;

public class HttpServerFilter
extends BaseFilter
implements JmxMonitoringAware<HttpServerProbe> {
    private static final Logger LOGGER = Grizzly.logger(HttpHandler.class);
    private final Attribute<Request> httpRequestInProcessAttr;
    final Attribute<Boolean> reregisterForReadAttr;
    private final DelayedExecutor.DelayQueue<Response> suspendedResponseQueue;
    private volatile HttpHandler httpHandler;
    private final ServerFilterConfiguration config;
    protected final AbstractJmxMonitoringConfig<HttpServerProbe> monitoringConfig = new AbstractJmxMonitoringConfig<HttpServerProbe>(HttpServerProbe.class){

        public JmxObject createManagementObject() {
            return HttpServerFilter.this.createJmxManagementObject();
        }
    };

    public HttpServerFilter(ServerFilterConfiguration config, DelayedExecutor delayedExecutor) {
        this.config = config;
        this.suspendedResponseQueue = Response.createDelayQueue(delayedExecutor);
        this.httpRequestInProcessAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("HttpServerFilter.Request");
        this.reregisterForReadAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("HttpServerFilter.reregisterForReadAttr");
    }

    public HttpHandler getHttpHandler() {
        return this.httpHandler;
    }

    public void setHttpHandler(HttpHandler httpHandler) {
        this.httpHandler = httpHandler;
    }

    public ServerFilterConfiguration getConfiguration() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        block20: {
            Object message = ctx.getMessage();
            Connection connection = ctx.getConnection();
            if (HttpPacket.isHttp((Object)message)) {
                HttpContent httpContent = (HttpContent)message;
                Request handlerRequest = (Request)this.httpRequestInProcessAttr.get((AttributeStorage)connection);
                if (handlerRequest == null) {
                    HttpRequestPacket request = (HttpRequestPacket)httpContent.getHttpHeader();
                    HttpResponsePacket response = request.getResponse();
                    handlerRequest = Request.create();
                    handlerRequest.parameters.setLimit(this.config.getMaxRequestParameters());
                    this.httpRequestInProcessAttr.set((AttributeStorage)connection, (Object)handlerRequest);
                    Response handlerResponse = Response.create();
                    handlerRequest.initialize(handlerResponse, request, ctx, this);
                    SuspendStatus suspendStatus = handlerResponse.initialize(handlerRequest, response, ctx, this.suspendedResponseQueue, this);
                    HttpServerProbeNotifier.notifyRequestReceive(this, connection, handlerRequest);
                    boolean wasSuspended = false;
                    try {
                        ctx.setMessage((Object)handlerResponse);
                        if (!this.config.isPassTraceRequest() && request.getMethod() == Method.TRACE) {
                            this.onTraceRequest(handlerRequest, handlerResponse);
                        } else {
                            HttpHandler httpHandlerLocal = this.httpHandler;
                            if (httpHandlerLocal != null) {
                                httpHandlerLocal.doHandle(handlerRequest, handlerResponse);
                            }
                        }
                    }
                    catch (Exception t) {
                        handlerRequest.getRequest().getProcessingState().setError(true);
                        if (!response.isCommitted()) {
                            ByteBuffer b = HtmlHelper.getExceptionErrorPage("Internal Server Error", "Grizzly/2.0", t);
                            handlerResponse.reset();
                            handlerResponse.setStatus(HttpStatus.INTERNAL_SERVER_ERROR_500);
                            handlerResponse.setContentType("text/html");
                            handlerResponse.setCharacterEncoding("UTF-8");
                            MemoryManager mm = ctx.getMemoryManager();
                            Buffer buf = Buffers.wrap((MemoryManager)mm, (ByteBuffer)b);
                            handlerResponse.getOutputBuffer().writeBuffer(buf);
                        }
                    }
                    catch (Throwable t) {
                        LOGGER.log(Level.WARNING, "Unexpected error", t);
                        throw new IllegalStateException(t);
                    }
                    finally {
                        wasSuspended = suspendStatus.getAndInvalidate();
                    }
                    if (!wasSuspended) {
                        return this.afterService(ctx, connection, handlerRequest, handlerResponse);
                    }
                    return ctx.getSuspendAction();
                }
                try {
                    if (!handlerRequest.getInputBuffer().append(httpContent)) {
                        NextAction action = ctx.getSuspendAction();
                        ctx.completeAndRecycle();
                        NextAction nextAction = action;
                        return nextAction;
                    }
                    break block20;
                }
                finally {
                    httpContent.recycle();
                }
            }
            if (Boolean.TRUE.equals(this.reregisterForReadAttr.remove((AttributeStorage)ctx))) {
                ctx.suspend();
                return ctx.getForkAction();
            }
            Response response = (Response)message;
            Request request = response.getRequest();
            return this.afterService(ctx, connection, request, response);
        }
        return ctx.getStopAction();
    }

    public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
        ReadHandler handler;
        Connection c = ctx.getConnection();
        Request request = (Request)this.httpRequestInProcessAttr.get((AttributeStorage)c);
        if (request != null && (handler = request.getInputBuffer().getReadHandler()) != null) {
            handler.onError(error);
        }
    }

    public JmxMonitoringConfig<HttpServerProbe> getMonitoringConfig() {
        return this.monitoringConfig;
    }

    protected JmxObject createJmxManagementObject() {
        return new org.glassfish.grizzly.http.server.jmx.HttpServerFilter(this);
    }

    protected void onTraceRequest(Request request, Response response) throws IOException {
        if (this.config.isTraceEnabled()) {
            HtmlHelper.writeTraceMessage(request, response);
        } else {
            response.setStatus(HttpStatus.METHOD_NOT_ALLOWED_405);
            response.setHeader(Header.Allow, "POST, GET, DELETE, OPTIONS, PUT, HEAD");
        }
    }

    private NextAction afterService(FilterChainContext ctx, Connection connection, Request request, Response response) throws IOException {
        this.httpRequestInProcessAttr.remove((AttributeStorage)connection);
        response.finish();
        request.onAfterService();
        HttpServerProbeNotifier.notifyRequestComplete(this, connection, response);
        HttpRequestPacket httpRequest = request.getRequest();
        boolean isBroken = httpRequest.isContentBroken();
        if (response.suspendState.get() != Response.SuspendState.CANCELLED) {
            response.recycle();
            request.recycle();
        }
        if (isBroken) {
            NextAction suspendNextAction = ctx.getSuspendAction();
            ctx.completeAndRecycle();
            return suspendNextAction;
        }
        return ctx.getStopAction();
    }
}

