/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.vote;

import org.aopalliance.intercept.MethodInvocation;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.AuthorizationServiceException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAclVoter
implements AccessDecisionVoter<MethodInvocation> {
    private Class<?> processDomainObjectClass;

    protected Object getDomainObjectInstance(MethodInvocation invocation) {
        Class<?>[] params = invocation.getMethod().getParameterTypes();
        Object[] args = invocation.getArguments();
        for (int i = 0; i < params.length; ++i) {
            if (!this.processDomainObjectClass.isAssignableFrom(params[i])) continue;
            return args[i];
        }
        throw new AuthorizationServiceException("MethodInvocation: " + invocation + " did not provide any argument of type: " + this.processDomainObjectClass);
    }

    public Class<?> getProcessDomainObjectClass() {
        return this.processDomainObjectClass;
    }

    public void setProcessDomainObjectClass(Class<?> processDomainObjectClass) {
        Assert.notNull(processDomainObjectClass, (String)"processDomainObjectClass cannot be set to null");
        this.processDomainObjectClass = processDomainObjectClass;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return MethodInvocation.class.isAssignableFrom(clazz);
    }
}

