/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.setup;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import org.springframework.mock.web.MockServletConfig;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MockMvcBuilder;
import org.springframework.test.web.servlet.MockMvcBuilderSupport;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.test.web.servlet.setup.PatternMappingFilterProxy;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMockMvcBuilder<Self extends DefaultMockMvcBuilder>
extends MockMvcBuilderSupport
implements MockMvcBuilder {
    private final WebApplicationContext webAppContext;
    private List<Filter> filters = new ArrayList<Filter>();
    private RequestBuilder defaultRequestBuilder;
    private final List<ResultMatcher> globalResultMatchers = new ArrayList<ResultMatcher>();
    private final List<ResultHandler> globalResultHandlers = new ArrayList<ResultHandler>();
    private Boolean dispatchOptions = Boolean.FALSE;

    protected DefaultMockMvcBuilder(WebApplicationContext webAppContext) {
        Assert.notNull((Object)webAppContext, (String)"WebApplicationContext is required");
        Assert.notNull((Object)webAppContext.getServletContext(), (String)"WebApplicationContext must have a ServletContext");
        this.webAppContext = webAppContext;
    }

    public final <T extends Self> T addFilters(Filter ... filters) {
        Assert.notNull((Object)filters, (String)"filters cannot be null");
        for (Filter f : filters) {
            Assert.notNull((Object)f, (String)"filters cannot contain null values");
            this.filters.add(f);
        }
        return (T)this;
    }

    public final <T extends Self> T addFilter(Filter filter, String ... urlPatterns) {
        Assert.notNull((Object)filter, (String)"filter cannot be null");
        Assert.notNull((Object)urlPatterns, (String)"urlPatterns cannot be null");
        if (urlPatterns.length > 0) {
            filter = new PatternMappingFilterProxy(filter, urlPatterns);
        }
        this.filters.add(filter);
        return (T)this;
    }

    public final <T extends Self> T defaultRequest(RequestBuilder requestBuilder) {
        this.defaultRequestBuilder = requestBuilder;
        return (T)this;
    }

    public final <T extends Self> T alwaysExpect(ResultMatcher resultMatcher) {
        this.globalResultMatchers.add(resultMatcher);
        return (T)this;
    }

    public final <T extends Self> T alwaysDo(ResultHandler resultHandler) {
        this.globalResultHandlers.add(resultHandler);
        return (T)this;
    }

    public final <T extends Self> T dispatchOptions(boolean dispatchOptions) {
        this.dispatchOptions = dispatchOptions;
        return (T)this;
    }

    @Override
    public final MockMvc build() {
        this.initWebAppContext(this.webAppContext);
        ServletContext servletContext = this.webAppContext.getServletContext();
        MockServletConfig mockServletConfig = new MockServletConfig(servletContext);
        Filter[] filterArray = this.filters.toArray(new Filter[this.filters.size()]);
        return super.createMockMvc(filterArray, mockServletConfig, this.webAppContext, this.defaultRequestBuilder, this.globalResultMatchers, this.globalResultHandlers, this.dispatchOptions);
    }

    protected void initWebAppContext(WebApplicationContext webAppContext) {
    }
}

