/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml.parser;

import java.io.Reader;
import java.io.Serializable;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.saml.parser.ParserPoolHolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class SAMLBase<T extends XMLObject, U>
implements Serializable {
    protected static final Logger log = LoggerFactory.getLogger(SAMLBase.class);
    protected Serializable serializedObject;
    protected transient U object;
    private int hashCode;

    protected SAMLBase(U object) {
        if (object == null) {
            throw new IllegalArgumentException("SAMLBase object can't be created with null object argument");
        }
        this.object = object;
        this.hashCode = object.hashCode();
    }

    public U getObject() {
        return this.object;
    }

    protected T unmarshallMessage(Reader messageStream) throws MessageDecodingException {
        log.debug("Parsing message stream into DOM document");
        try {
            Document messageDoc = this.getPool().parse(messageStream);
            Element messageElem = messageDoc.getDocumentElement();
            if (log.isTraceEnabled()) {
                log.trace("Unmarshalled message into DOM:\n{}", (Object)XMLHelper.nodeToString((Node)messageElem));
            }
            log.debug("Unmarshalling message DOM");
            Unmarshaller unmarshaller = Configuration.getUnmarshallerFactory().getUnmarshaller(messageElem);
            if (unmarshaller == null) {
                throw new MessageDecodingException("Unable to unmarshall message, no unmarshaller registered for message element " + XMLHelper.getNodeQName((Node)messageElem));
            }
            XMLObject message = unmarshaller.unmarshall(messageElem);
            log.debug("Message successfully unmarshalled");
            return (T)message;
        }
        catch (XMLParserException e) {
            log.error("Encountered error parsing message into its DOM representation", (Throwable)e);
            throw new MessageDecodingException("Encountered error parsing message into its DOM representation", (Exception)((Object)e));
        }
        catch (UnmarshallingException e) {
            log.error("Encountered error unmarshalling message from its DOM representation", (Throwable)e);
            throw new MessageDecodingException("Encountered error unmarshalling message from its DOM representation", (Exception)((Object)e));
        }
    }

    private ParserPool getPool() throws MessageDecodingException {
        return ParserPoolHolder.getPool();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SAMLBase that = (SAMLBase)o;
        if (this.serializedObject != null && that.serializedObject != null) {
            return this.serializedObject.equals(that.serializedObject);
        }
        return this.object != null && this.object.equals(that.object);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

