/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.commons.ssl.HostnameVerifier;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLException;
import org.opensaml.common.SAMLRuntimeException;
import org.opensaml.saml2.metadata.ArtifactResolutionService;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.SSODescriptor;
import org.opensaml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.SignableXMLObject;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureException;
import org.opensaml.xml.signature.Signer;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.signature.X509Data;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.saml.SAMLConstants;
import org.springframework.security.saml.key.KeyManager;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.MetadataManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLUtil {
    private static final Logger logger = LoggerFactory.getLogger(SAMLUtil.class);

    public static String getBindingForEndpoint(Endpoint endpoint) {
        String bindingName = endpoint.getBinding();
        if ("urn:oasis:names:tc:SAML:2.0:profiles:holder-of-key:SSO:browser".equals(bindingName)) {
            QName attributeName = SAMLConstants.WEBSSO_HOK_METADATA_ATT_NAME;
            String endpointLocation = endpoint.getUnknownAttributes().get((Object)attributeName);
            if (endpointLocation != null) {
                bindingName = endpointLocation;
            } else {
                throw new SAMLRuntimeException("Holder of Key profile endpoint doesn't contain attribute hoksso:ProtocolBinding");
            }
        }
        return bindingName;
    }

    public static SingleLogoutService getLogoutServiceForBinding(SSODescriptor descriptor, String binding) throws MetadataProviderException {
        List services = descriptor.getSingleLogoutServices();
        for (SingleLogoutService service : services) {
            if (!binding.equals(service.getBinding())) continue;
            return service;
        }
        logger.debug("No binding found for IDP with binding " + binding);
        throw new MetadataProviderException("Binding " + binding + " is not supported for this IDP");
    }

    public static String getLogoutBinding(IDPSSODescriptor idp, SPSSODescriptor sp) throws MetadataProviderException {
        List logoutServices = idp.getSingleLogoutServices();
        if (logoutServices.size() == 0) {
            throw new MetadataProviderException("IDP doesn't contain any SingleLogout endpoints");
        }
        String binding = null;
        block0: for (SingleLogoutService idpService : logoutServices) {
            for (SingleLogoutService spService : sp.getSingleLogoutServices()) {
                if (!idpService.getBinding().equals(spService.getBinding())) continue;
                binding = idpService.getBinding();
                break block0;
            }
        }
        if (binding == null) {
            binding = ((SingleLogoutService)idp.getSingleLogoutServices().iterator().next()).getBinding();
        }
        return binding;
    }

    public static IDPSSODescriptor getIDPSSODescriptor(EntityDescriptor idpEntityDescriptor) throws MessageDecodingException {
        IDPSSODescriptor idpSSODescriptor = idpEntityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        if (idpSSODescriptor == null) {
            logger.error("Could not find an IDPSSODescriptor in metadata.");
            throw new MessageDecodingException("Could not find an IDPSSODescriptor in metadata.");
        }
        return idpSSODescriptor;
    }

    public static AssertionConsumerService getConsumerService(SPSSODescriptor ssoDescriptor, Integer index) {
        if (index != null) {
            for (AssertionConsumerService service : ssoDescriptor.getAssertionConsumerServices()) {
                if (!index.equals(service.getIndex())) continue;
                logger.debug("Found assertionConsumerService with index {} and binding {}", (Object)index, (Object)service.getBinding());
                return service;
            }
            throw new SAMLRuntimeException("AssertionConsumerService with index " + index + " wasn't found for ServiceProvider " + ssoDescriptor.getID() + ", please check your metadata");
        }
        logger.debug("Index for AssertionConsumerService not specified, returning default");
        return ssoDescriptor.getDefaultAssertionConsumerService();
    }

    public static ArtifactResolutionService getArtifactResolutionService(IDPSSODescriptor idpssoDescriptor, int endpointIndex) throws MessageDecodingException {
        List artifactResolutionServices = idpssoDescriptor.getArtifactResolutionServices();
        if (artifactResolutionServices == null || artifactResolutionServices.size() == 0) {
            logger.error("Could not find any artifact resolution services in metadata.");
            throw new MessageDecodingException("Could not find any artifact resolution services in metadata.");
        }
        ArtifactResolutionService artifactResolutionService = null;
        for (ArtifactResolutionService ars : artifactResolutionServices) {
            if (ars.getIndex() != endpointIndex) continue;
            artifactResolutionService = ars;
            break;
        }
        if (artifactResolutionService == null) {
            throw new MessageDecodingException("Could not find artifact resolution service with index " + endpointIndex + " in IDP data.");
        }
        return artifactResolutionService;
    }

    public static boolean processFilter(String filterName, HttpServletRequest request) {
        return request.getRequestURI().contains(filterName);
    }

    public static boolean compare(byte[] hashID, String entityId) throws MetadataProviderException {
        try {
            MessageDigest sha1Digester = MessageDigest.getInstance("SHA-1");
            byte[] hashedEntityId = sha1Digester.digest(entityId.getBytes());
            for (int i = 0; i < hashedEntityId.length; ++i) {
                if (hashedEntityId[i] == hashID[i]) continue;
                return false;
            }
            return true;
        }
        catch (NoSuchAlgorithmException e) {
            throw new MetadataProviderException("SHA-1 message digest not available", (Exception)e);
        }
    }

    public static void verifyAlias(String alias, String entityId) throws MetadataProviderException {
        if (alias == null) {
            throw new MetadataProviderException("Alias for entity " + entityId + " is null");
        }
        if (alias.length() == 0) {
            throw new MetadataProviderException("Alias for entity " + entityId + " is empty");
        }
        if (!alias.matches("\\p{ASCII}*")) {
            throw new MetadataProviderException("Only ASCII characters can be used in the alias " + alias + " for entity " + entityId);
        }
    }

    public static List<String> getBase64EncodeCertificates(KeyInfo keyInfo) {
        LinkedList<String> certList = new LinkedList<String>();
        if (keyInfo == null) {
            return certList;
        }
        List x509Datas = keyInfo.getX509Datas();
        for (X509Data x509Data : x509Datas) {
            if (x509Data == null) continue;
            certList.addAll(SAMLUtil.getBase64EncodedCertificates(x509Data));
        }
        return certList;
    }

    public static List<String> getBase64EncodedCertificates(X509Data x509Data) {
        LinkedList<String> certList = new LinkedList<String>();
        if (x509Data == null) {
            return certList;
        }
        for (X509Certificate xmlCert : x509Data.getX509Certificates()) {
            if (xmlCert == null || xmlCert.getValue() == null) continue;
            certList.add(xmlCert.getValue());
        }
        return certList;
    }

    public static boolean isECPRequest(HttpServletRequest request) {
        String acceptHeader = request.getHeader("Accept");
        String paosHeader = request.getHeader("PAOS");
        return acceptHeader != null && paosHeader != null && acceptHeader.contains("application/vnd.paos+xml") && paosHeader.contains("urn:liberty:paos:2003-08") && paosHeader.contains("urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp");
    }

    public static <T extends Endpoint> T getEndpoint(List<T> endpoints, String messageBinding, String filterURL) throws SAMLException {
        for (Endpoint endpoint : endpoints) {
            String binding = SAMLUtil.getBindingForEndpoint(endpoint);
            if (!binding.equals(messageBinding)) continue;
            if (endpoint.getLocation().contains(filterURL)) {
                return (T)endpoint;
            }
            if (endpoint.getResponseLocation() == null || !endpoint.getResponseLocation().contains(filterURL)) continue;
            return (T)endpoint;
        }
        throw new SAMLException("Endpoint with message binding " + messageBinding + " and filter URL " + filterURL + " wasn't found");
    }

    public static IDPSSODescriptor getIDPDescriptor(MetadataManager metadata, String idpId) throws MetadataProviderException {
        if (!metadata.isIDPValid(idpId)) {
            logger.debug("IDP name of the authenticated user is not valid", (Object)idpId);
            throw new MetadataProviderException("IDP with name " + idpId + " wasn't found in the list of configured IDPs");
        }
        IDPSSODescriptor idpssoDescriptor = (IDPSSODescriptor)metadata.getRole(idpId, IDPSSODescriptor.DEFAULT_ELEMENT_NAME, "urn:oasis:names:tc:SAML:2.0:protocol");
        if (idpssoDescriptor == null) {
            throw new MetadataProviderException("Given IDP " + idpId + " doesn't contain any IDPSSODescriptor element");
        }
        return idpssoDescriptor;
    }

    public static Element marshallMessage(XMLObject message) throws MessageEncodingException {
        try {
            if (message.getDOM() != null) {
                logger.debug("XMLObject already had cached DOM, returning that element");
                return message.getDOM();
            }
            Marshaller marshaller = org.opensaml.xml.Configuration.getMarshallerFactory().getMarshaller(message);
            if (marshaller == null) {
                throw new MessageEncodingException("Unable to marshall message, no marshaller registered for message object: " + message.getElementQName());
            }
            Element messageElem = marshaller.marshall(message);
            if (logger.isTraceEnabled()) {
                logger.trace("Marshalled message into DOM:\n{}", (Object)XMLHelper.nodeToString((Node)messageElem));
            }
            return messageElem;
        }
        catch (MarshallingException e) {
            logger.error("Encountered error marshalling message to its DOM representation", (Throwable)e);
            throw new MessageEncodingException("Encountered error marshalling message into its DOM representation", (Exception)((Object)e));
        }
    }

    public static Element marshallAndSignMessage(SignableXMLObject signableMessage, Credential signingCredential, String signingAlgorithm, String keyInfoGenerator) throws MessageEncodingException {
        if (signingCredential != null && !signableMessage.isSigned()) {
            XMLObjectBuilder signatureBuilder = Configuration.getBuilderFactory().getBuilder(Signature.DEFAULT_ELEMENT_NAME);
            Signature signature = (Signature)signatureBuilder.buildObject(Signature.DEFAULT_ELEMENT_NAME);
            if (signingAlgorithm != null) {
                signature.setSignatureAlgorithm(signingAlgorithm);
            }
            signature.setSigningCredential(signingCredential);
            try {
                SecurityHelper.prepareSignatureParams((Signature)signature, (Credential)signingCredential, null, (String)keyInfoGenerator);
            }
            catch (SecurityException e) {
                throw new MessageEncodingException("Error preparing signature for signing", (Exception)((Object)e));
            }
            signableMessage.setSignature(signature);
            Element element = SAMLUtil.marshallMessage((XMLObject)signableMessage);
            try {
                Signer.signObject((Signature)signature);
            }
            catch (SignatureException e) {
                logger.error("Unable to sign protocol message", (Throwable)e);
                throw new MessageEncodingException("Unable to sign protocol message", (Exception)((Object)e));
            }
            return element;
        }
        return SAMLUtil.marshallMessage((XMLObject)signableMessage);
    }

    public static boolean isDateTimeSkewValid(int skewInSec, DateTime time) {
        return SAMLUtil.isDateTimeSkewValid(skewInSec, 0, time);
    }

    public static boolean isDateTimeSkewValid(int skewInSec, int forwardInterval, DateTime time) {
        long reference = System.currentTimeMillis();
        return time.isBefore(reference + (long)(skewInSec * 1000)) && time.isAfter(reference - (long)((skewInSec + forwardInterval) * 1000));
    }

    public static String getNCNameString(String value) {
        if (value == null) {
            return null;
        }
        String cleanValue = value.replaceAll("[^a-zA-Z0-9-_.]", "_");
        if (cleanValue.startsWith("-")) {
            cleanValue = "_" + cleanValue.substring(1);
        }
        return cleanValue;
    }

    public static javax.net.ssl.HostnameVerifier getHostnameVerifier(String hostnameVerificationType) {
        HostnameVerifier hostnameVerifier = "default".equalsIgnoreCase(hostnameVerificationType) ? HostnameVerifier.DEFAULT : ("defaultAndLocalhost".equalsIgnoreCase(hostnameVerificationType) ? HostnameVerifier.DEFAULT_AND_LOCALHOST : ("strict".equalsIgnoreCase(hostnameVerificationType) ? HostnameVerifier.STRICT : ("allowAll".equalsIgnoreCase(hostnameVerificationType) ? HostnameVerifier.ALLOW_ALL : HostnameVerifier.DEFAULT)));
        return hostnameVerifier;
    }

    public static String getMetadataAsString(MetadataManager metadataManager, KeyManager keyManager, EntityDescriptor descriptor, ExtendedMetadata extendedMetadata) throws MarshallingException {
        Element element;
        if (extendedMetadata == null) {
            try {
                extendedMetadata = metadataManager.getExtendedMetadata(descriptor.getEntityID());
            }
            catch (MetadataProviderException e) {
                logger.error("Unable to locate extended metadata", (Throwable)e);
                throw new MarshallingException("Unable to locate extended metadata", (Exception)((Object)e));
            }
        }
        try {
            if (extendedMetadata.isLocal() && extendedMetadata.isSignMetadata()) {
                Credential credential = keyManager.getCredential(extendedMetadata.getSigningKey());
                String signingAlgorithm = extendedMetadata.getSigningAlgorithm();
                String keyGenerator = extendedMetadata.getKeyInfoGeneratorName();
                element = SAMLUtil.marshallAndSignMessage((SignableXMLObject)descriptor, credential, signingAlgorithm, keyGenerator);
            } else {
                element = SAMLUtil.marshallMessage((XMLObject)descriptor);
            }
        }
        catch (MessageEncodingException e) {
            logger.error("Unable to marshall message", (Throwable)e);
            throw new MarshallingException("Unable to marshall message", (Exception)((Object)e));
        }
        return XMLHelper.nodeToString((Node)element);
    }
}

