/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.binding.artifact;

import java.util.Map;
import org.opensaml.saml2.binding.artifact.AbstractSAML2Artifact;
import org.opensaml.saml2.binding.artifact.SAML2ArtifactBuilder;
import org.opensaml.saml2.binding.artifact.SAML2ArtifactType0004;
import org.opensaml.saml2.binding.artifact.SAML2ArtifactType0004Builder;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.LazyMap;

public class SAML2ArtifactBuilderFactory {
    private Map<String, SAML2ArtifactBuilder> artifactBuilders = new LazyMap();

    public SAML2ArtifactBuilderFactory() {
        this.artifactBuilders.put(new String(SAML2ArtifactType0004.TYPE_CODE), new SAML2ArtifactType0004Builder());
    }

    public Map<String, SAML2ArtifactBuilder> getArtifactBuilders() {
        return this.artifactBuilders;
    }

    public SAML2ArtifactBuilder getArtifactBuilder(byte[] type) {
        return this.artifactBuilders.get(new String(type));
    }

    public AbstractSAML2Artifact buildArtifact(String base64Artifact) {
        return this.buildArtifact(Base64.decode((String)base64Artifact));
    }

    public AbstractSAML2Artifact buildArtifact(byte[] artifact) {
        if (artifact == null) {
            return null;
        }
        byte[] type = new byte[]{artifact[0], artifact[1]};
        SAML2ArtifactBuilder artifactBuilder = this.getArtifactBuilder(type);
        return artifactBuilder.buildArtifact(artifact);
    }
}

