/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.core.validator;

import org.opensaml.saml2.core.AuthzDecisionStatement;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

public class AuthzDecisionStatementSchemaValidator
implements Validator<AuthzDecisionStatement> {
    public void validate(AuthzDecisionStatement authzDS) throws ValidationException {
        this.validateResource(authzDS);
        this.validateDecision(authzDS);
        this.validateActions(authzDS);
    }

    protected void validateResource(AuthzDecisionStatement authzDS) throws ValidationException {
        if (DatatypeHelper.isEmpty((String)authzDS.getResource())) {
            throw new ValidationException("Resource required");
        }
    }

    protected void validateDecision(AuthzDecisionStatement authzDS) throws ValidationException {
        if (authzDS.getDecision() == null) {
            throw new ValidationException("Decision required");
        }
    }

    protected void validateActions(AuthzDecisionStatement authzDS) throws ValidationException {
        if (authzDS.getActions() == null || authzDS.getActions().size() < 1) {
            throw new ValidationException("One or more Actions required");
        }
    }
}

