/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml.trust;

import java.lang.ref.SoftReference;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.namespace.QName;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.saml2.metadata.provider.ObservableMetadataProvider;
import org.opensaml.security.MetadataCredentialResolver;
import org.opensaml.security.MetadataCriteria;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.criteria.UsageCriteria;
import org.opensaml.xml.security.x509.BasicPKIXValidationInformation;
import org.opensaml.xml.security.x509.PKIXValidationInformation;
import org.opensaml.xml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.saml.key.KeyManager;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.MetadataManager;

public class PKIXInformationResolver
implements PKIXValidationInformationResolver {
    private final Logger log = LoggerFactory.getLogger(MetadataCredentialResolver.class);
    private MetadataManager metadata;
    private Map<MetadataCacheKey, SoftReference<Collection<PKIXValidationInformation>>> cache;
    private ReadWriteLock rwlock;
    private MetadataCredentialResolver metadataResolver;
    private KeyManager keyManager;

    public PKIXInformationResolver(MetadataCredentialResolver metadataResolver, MetadataManager metadataProvider, KeyManager keyManager) {
        if (metadataProvider == null) {
            throw new IllegalArgumentException("Metadata provider may not be null");
        }
        this.metadataResolver = metadataResolver;
        this.metadata = metadataProvider;
        this.keyManager = keyManager;
        this.cache = new HashMap<MetadataCacheKey, SoftReference<Collection<PKIXValidationInformation>>>();
        this.rwlock = new ReentrantReadWriteLock();
        this.metadata.getObservers().add(new MetadataProviderObserver());
    }

    protected ReadWriteLock getReadWriteLock() {
        return this.rwlock;
    }

    protected Iterable<PKIXValidationInformation> resolveFromSource(CriteriaSet criteriaSet) throws SecurityException {
        this.checkCriteriaRequirements(criteriaSet);
        String entityID = ((EntityIDCriteria)criteriaSet.get(EntityIDCriteria.class)).getEntityID();
        MetadataCriteria mdCriteria = (MetadataCriteria)criteriaSet.get(MetadataCriteria.class);
        QName role = mdCriteria.getRole();
        String protocol = mdCriteria.getProtocol();
        UsageCriteria usageCriteria = (UsageCriteria)criteriaSet.get(UsageCriteria.class);
        UsageType usage = usageCriteria != null ? usageCriteria.getUsage() : UsageType.UNSPECIFIED;
        this.log.debug("Forcing on-demand metadata provider refresh if necessary");
        try {
            this.metadata.getMetadata();
        }
        catch (MetadataProviderException e) {
            // empty catch block
        }
        MetadataCacheKey cacheKey = new MetadataCacheKey(entityID, role, protocol, usage);
        Collection<PKIXValidationInformation> credentials = this.retrieveFromCache(cacheKey);
        if (credentials == null) {
            credentials = this.populateCredentials(criteriaSet);
            this.cacheCredentials(cacheKey, credentials);
        }
        return credentials;
    }

    protected Collection<PKIXValidationInformation> populateCredentials(CriteriaSet criteriaSet) throws SecurityException {
        ArrayList<X509Certificate> anchors = new ArrayList<X509Certificate>();
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>();
        this.populateMetadataAnchors(criteriaSet, anchors, crls);
        this.populateTrustedKeysAnchors(criteriaSet, anchors, crls);
        this.populateCRLs(criteriaSet, anchors, crls);
        BasicPKIXValidationInformation info = new BasicPKIXValidationInformation(anchors, crls, Integer.valueOf(this.getPKIXDepth()));
        return new ArrayList<PKIXValidationInformation>(Arrays.asList(info));
    }

    protected void checkCriteriaRequirements(CriteriaSet criteriaSet) {
        EntityIDCriteria entityCriteria = (EntityIDCriteria)criteriaSet.get(EntityIDCriteria.class);
        MetadataCriteria mdCriteria = (MetadataCriteria)criteriaSet.get(MetadataCriteria.class);
        if (entityCriteria == null) {
            throw new IllegalArgumentException("Entity criteria must be supplied");
        }
        if (mdCriteria == null) {
            throw new IllegalArgumentException("SAML metadata criteria must be supplied");
        }
        if (DatatypeHelper.isEmpty((String)entityCriteria.getEntityID())) {
            throw new IllegalArgumentException("Credential owner entity ID criteria value must be supplied");
        }
        if (mdCriteria.getRole() == null) {
            throw new IllegalArgumentException("Credential metadata role criteria value must be supplied");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<PKIXValidationInformation> retrieveFromCache(MetadataCacheKey cacheKey) {
        this.log.debug("Attempting to retrieve credentials from cache using index: {}", (Object)cacheKey);
        Lock readLock = this.getReadWriteLock().readLock();
        readLock.lock();
        this.log.trace("Read lock over cache acquired");
        try {
            SoftReference<Collection<PKIXValidationInformation>> reference;
            if (this.cache.containsKey(cacheKey) && (reference = this.cache.get(cacheKey)).get() != null) {
                this.log.debug("Retrieved credentials from cache using index: {}", (Object)cacheKey);
                Collection<PKIXValidationInformation> collection = reference.get();
                return collection;
            }
        }
        finally {
            readLock.unlock();
            this.log.trace("Read lock over cache released");
        }
        this.log.debug("Unable to retrieve credentials from cache using index: {}", (Object)cacheKey);
        return null;
    }

    protected void populateMetadataAnchors(CriteriaSet criteriaSet, Collection<X509Certificate> anchors, Collection<X509CRL> crls) throws SecurityException {
        String entityID = ((EntityIDCriteria)criteriaSet.get(EntityIDCriteria.class)).getEntityID();
        this.log.debug("Attempting to retrieve PKIX trust anchors from metadata configuration for entity: {}", (Object)entityID);
        Iterable metadataCredentials = this.metadataResolver.resolve(criteriaSet);
        for (Credential key : metadataCredentials) {
            if (key instanceof X509Credential) {
                X509Credential cred = (X509Credential)key;
                this.log.debug("Using key {} as a trust anchor", (Object)cred.getEntityCertificate().getSubjectDN());
                anchors.add(cred.getEntityCertificate());
                continue;
            }
            this.log.debug("Key {} is not of X509Credential type, skipping", (Object)key.getEntityId());
        }
    }

    protected void populateTrustedKeysAnchors(CriteriaSet criteriaSet, Collection<X509Certificate> anchors, Collection<X509CRL> crls) throws SecurityException {
        try {
            String entityID = ((EntityIDCriteria)criteriaSet.get(EntityIDCriteria.class)).getEntityID();
            this.log.debug("Attempting to retrieve credentials from metadata configuration for entity: {}", (Object)entityID);
            ExtendedMetadata extendedMetadata = this.metadata.getExtendedMetadata(entityID);
            Set<String> trustedKeys = extendedMetadata.getTrustedKeys() != null ? extendedMetadata.getTrustedKeys() : this.keyManager.getAvailableCredentials();
            for (String key : trustedKeys) {
                anchors.add(this.keyManager.getCertificate(key));
            }
        }
        catch (MetadataProviderException e) {
            throw new SecurityException("Error loading extended metadata", (Exception)((Object)e));
        }
    }

    protected void populateCRLs(CriteriaSet criteriaSet, Collection<X509Certificate> anchors, Collection<X509CRL> crls) throws SecurityException {
    }

    protected int getPKIXDepth() {
        return 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheCredentials(MetadataCacheKey cacheKey, Collection<PKIXValidationInformation> credentials) {
        Lock writeLock = this.getReadWriteLock().writeLock();
        writeLock.lock();
        this.log.trace("Write lock over cache acquired");
        try {
            this.cache.put(cacheKey, new SoftReference<Collection<PKIXValidationInformation>>(credentials));
            this.log.debug("Added new credential collection to cache with key: {}", (Object)cacheKey);
        }
        finally {
            writeLock.unlock();
            this.log.trace("Write lock over cache released");
        }
    }

    public Set<String> resolveTrustedNames(CriteriaSet criteriaSet) throws SecurityException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Method isn't supported");
    }

    public boolean supportsTrustedNameResolution() {
        return false;
    }

    public Iterable<PKIXValidationInformation> resolve(CriteriaSet criteria) throws SecurityException {
        return this.resolveFromSource(criteria);
    }

    public PKIXValidationInformation resolveSingle(CriteriaSet criteria) throws SecurityException {
        Iterator<PKIXValidationInformation> iterator = this.resolveFromSource(criteria).iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    protected class MetadataProviderObserver
    implements ObservableMetadataProvider.Observer {
        protected MetadataProviderObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEvent(MetadataProvider provider) {
            Lock writeLock = PKIXInformationResolver.this.getReadWriteLock().writeLock();
            writeLock.lock();
            PKIXInformationResolver.this.log.trace("Write lock over cache acquired");
            try {
                PKIXInformationResolver.this.cache.clear();
                PKIXInformationResolver.this.log.debug("Credential cache cleared");
            }
            finally {
                writeLock.unlock();
                PKIXInformationResolver.this.log.trace("Write lock over cache released");
            }
        }
    }

    protected class MetadataCacheKey {
        private String id;
        private QName role;
        private String protocol;
        private UsageType usage;

        protected MetadataCacheKey(String entityID, QName entityRole, String entityProtocol, UsageType entityUsage) {
            if (entityID == null) {
                throw new IllegalArgumentException("Entity ID may not be null");
            }
            if (entityRole == null) {
                throw new IllegalArgumentException("Entity role may not be null");
            }
            if (entityUsage == null) {
                throw new IllegalArgumentException("Credential usage may not be null");
            }
            this.id = entityID;
            this.role = entityRole;
            this.protocol = entityProtocol;
            this.usage = entityUsage;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MetadataCacheKey)) {
                return false;
            }
            MetadataCacheKey other = (MetadataCacheKey)obj;
            if (!this.id.equals(other.id) || !this.role.equals(other.role) || this.usage != other.usage) {
                return false;
            }
            return !(this.protocol == null ? other.protocol != null : !this.protocol.equals(other.protocol));
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.id.hashCode();
            result = 37 * result + this.role.hashCode();
            if (this.protocol != null) {
                result = 37 * result + this.protocol.hashCode();
            }
            result = 37 * result + this.usage.hashCode();
            return result;
        }

        public String toString() {
            return String.format("[%s,%s,%s,%s]", this.id, this.role, this.protocol, this.usage);
        }
    }
}

