/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.service.cleanup;

import edu.harvard.catalyst.scheduler.dto.Epic.EmpiSubjectDto;
import edu.harvard.catalyst.scheduler.entity.Subject;

public abstract class SubjectEmpiFieldMatcher {
    static final String versus = " (empi) vs (sched) ";
    static final String exactMatch = "Exact Match!";
    static final String partialMatch = "Partial Match";
    static final String noMatch = "No Match";
    static final int exactPercent = 100;
    static final int partialPercent = 50;
    static final int zeroPercent = 0;
    static final float heavy = 10.0f;
    static final float medium = 5.0f;
    final float weight;
    protected MatchInfo matchInfo;
    protected Subject schedulerSubject;
    protected EmpiSubjectDto.Patient empiSubject;

    SubjectEmpiFieldMatcher(float weight, Subject schedulerSubject, EmpiSubjectDto.Patient empiSubject) {
        this.weight = weight;
        this.schedulerSubject = schedulerSubject;
        this.empiSubject = empiSubject;
        this.matchInfo = new MatchInfo(empiSubject.getUid(), schedulerSubject.getId(), this.getClass().getSimpleName());
    }

    abstract MatchInfo computeMatchInfo(String var1);

    protected float weightedPoints(float points) {
        float result = points / 100.0f * this.weight;
        return result;
    }

    public static class MatchInfo {
        int empiUid;
        Integer subjectId;
        String matcherName;
        String comment;
        String matchLabel;
        Float points = Float.valueOf(0.0f);

        public MatchInfo(int empiUid, Integer subjectId, String matcherName) {
            this.empiUid = empiUid;
            this.subjectId = subjectId;
            this.matcherName = matcherName;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public void setMatcherName(String matcherName) {
            this.matcherName = matcherName;
        }

        public void setPoints(Float points) {
            this.points = points;
        }

        public Float getPoints() {
            return this.points;
        }

        public String getMatchLabel() {
            return this.matchLabel;
        }

        public void setMatchLabel(String matchLabel) {
            this.matchLabel = matchLabel;
        }
    }
}

