/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.entity;

import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.BookedVisit;
import edu.harvard.catalyst.scheduler.entity.Credential;
import edu.harvard.catalyst.scheduler.entity.Department;
import edu.harvard.catalyst.scheduler.entity.Division;
import edu.harvard.catalyst.scheduler.entity.FacultyRank;
import edu.harvard.catalyst.scheduler.entity.HasEmail;
import edu.harvard.catalyst.scheduler.entity.HasFirstName;
import edu.harvard.catalyst.scheduler.entity.HasLastName;
import edu.harvard.catalyst.scheduler.entity.Institution;
import edu.harvard.catalyst.scheduler.entity.InstitutionRole;
import edu.harvard.catalyst.scheduler.entity.Role;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.springframework.util.StringUtils;

@Entity
@Table(name="user")
public class User
extends BaseEntity
implements Serializable,
HasFirstName,
HasLastName,
HasEmail {
    public static final int STATUS_AUTHORIZED = 1;
    public static final int STATUS_NOT_FOUND = 0;
    public static final int STATUS_INVALID_PASSWORD = -1;
    public static final int STATUS_INACTIVE = -2;
    private static final long serialVersionUID = 8014584895711544530L;
    private String ecommonsId;
    private transient String password;
    private String firstName;
    private String middleName;
    private String lastName;
    private String primaryPhone;
    private String secondaryPhone;
    private String email;
    private String notificationEmail;
    private String fax;
    private String pager;
    private Division division;
    private Department department;
    private Institution institution;
    private InstitutionRole institutionRole;
    private Role role;
    private Credential credential;
    private FacultyRank facultyRank;
    private boolean active;
    private transient String salt;
    private int authStatus;
    private String sessionId;
    private Date lastLoginTime;
    private String previousLoginTime;
    private List<BookedVisit> bookedVisits;

    @Column(name="ecommons_id")
    @Basic(optional=false)
    public String getEcommonsId() {
        return this.ecommonsId;
    }

    public void setEcommonsId(String ecommonsId) {
        this.ecommonsId = ecommonsId;
    }

    @Column(name="password")
    @Basic(optional=false)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    @Column(name="first_name")
    @Basic(optional=false)
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Column(name="middle_name")
    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    @Override
    @Column(name="last_name")
    @Basic(optional=false)
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Column(name="primary_phone")
    public String getPrimaryPhone() {
        return this.primaryPhone;
    }

    public void setPrimaryPhone(String primaryPhone) {
        this.primaryPhone = primaryPhone;
    }

    @Column(name="secondary_phone")
    public String getSecondaryPhone() {
        return this.secondaryPhone;
    }

    public void setSecondaryPhone(String secondaryPhone) {
        this.secondaryPhone = secondaryPhone;
    }

    @Override
    @Column(name="email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Column(name="fax")
    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    @Column(name="pager")
    public String getPager() {
        return this.pager;
    }

    public void setPager(String pager) {
        this.pager = pager;
    }

    @JoinColumn(name="division", referencedColumnName="id")
    @ManyToOne(optional=true)
    public Division getDivision() {
        return this.division;
    }

    public void setDivision(Division division) {
        this.division = division;
    }

    @JoinColumn(name="department", referencedColumnName="id")
    @ManyToOne(optional=true)
    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    @JoinColumn(name="credential", referencedColumnName="id")
    @ManyToOne(optional=true)
    public Credential getCredential() {
        return this.credential;
    }

    public void setCredential(Credential credential) {
        this.credential = credential;
    }

    @JoinColumn(name="faculty_rank", referencedColumnName="id")
    @ManyToOne(optional=true)
    public FacultyRank getFacultyRank() {
        return this.facultyRank;
    }

    public void setFacultyRank(FacultyRank facultyRank) {
        this.facultyRank = facultyRank;
    }

    @JoinColumn(name="institution", referencedColumnName="id")
    @ManyToOne(optional=false)
    public Institution getInstitution() {
        return this.institution;
    }

    public void setInstitution(Institution institution) {
        this.institution = institution;
    }

    @JoinColumn(name="institution_role", referencedColumnName="id")
    @ManyToOne(optional=false)
    public InstitutionRole getInstitutionRole() {
        return this.institutionRole;
    }

    public void setInstitutionRole(InstitutionRole institutionRole) {
        this.institutionRole = institutionRole;
    }

    @JoinColumn(name="role", referencedColumnName="id")
    @ManyToOne(optional=false)
    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    @Column(name="active")
    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Column(name="salt")
    @Basic(optional=false)
    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    @Column(name="last_login_time")
    public Date getLastLoginTime() {
        return this.lastLoginTime;
    }

    public void setLastLoginTime(Date lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    @Transient
    public Integer getAuthStatus() {
        return this.authStatus;
    }

    public void setAuthStatus(Integer authStatus) {
        this.authStatus = authStatus;
    }

    @Transient
    public String getPreviousLoginTime() {
        return this.previousLoginTime;
    }

    public void setPreviousLoginTime(String previousLoginTime) {
        this.previousLoginTime = previousLoginTime;
    }

    @Transient
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Transient
    public List<BookedVisit> getBookedVisits() {
        return this.bookedVisits;
    }

    public void setBookedVisits(List<BookedVisit> bookedVisits) {
        this.bookedVisits = bookedVisits;
    }

    public String toString() {
        return "User [id=" + this.id + ", getId()=" + this.getId() + "]";
    }

    @Transient
    public String getPreferredNotificationEmail() {
        if (!StringUtils.hasText((String)this.getNotificationEmail())) {
            return this.email;
        }
        return this.notificationEmail;
    }

    @Column(name="notification_email")
    public String getNotificationEmail() {
        return this.notificationEmail;
    }

    public void setNotificationEmail(String notificationEmail) {
        this.notificationEmail = notificationEmail;
    }

    @Transient
    public boolean isStudyStaff() {
        return InstitutionRole.isStudyStaff(this.getInstitutionRole());
    }
}

