/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.subjectDataCleaner;

import edu.harvard.catalyst.scheduler.entity.ActivityLog;
import edu.harvard.catalyst.scheduler.entity.ArchivalStatus;
import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.BookedVisit;
import edu.harvard.catalyst.scheduler.entity.Study;
import edu.harvard.catalyst.scheduler.entity.StudySubject;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.persistence.AppointmentDAO;
import edu.harvard.catalyst.scheduler.persistence.StudyDAO;
import edu.harvard.catalyst.scheduler.persistence.SubjectDAO;
import edu.harvard.catalyst.scheduler.service.StandaloneSubjectService;
import edu.harvard.catalyst.scheduler.subjectDataCleaner.SubjectDataMerger;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class SubjectDataMergerTest {
    @Test
    public void testMergeSubject() {
        int primarySubjectId = 11;
        int secondarySubjectId = 22;
        String primaryMrnString = "0001";
        String secondaryMrnString = "0002";
        int studyWithOnlyPrimarySubjectId = 111;
        int studyWithBothSubjectsId = 222;
        int studyWithOnlySecondarySubjectId = 333;
        int studySubject1Id = 1111;
        int studySubject2Id = 2222;
        int studySubject3Id = 3333;
        int studySubject4Id = 4444;
        int bookedVisitStudy2Subject1Id = 22222;
        int bookedVisitStudy2Subject2Id = 33333;
        int bookedVisitStudy3Subject2Id = 44444;
        SubjectDAO subjectDAO = (SubjectDAO)Mockito.mock(SubjectDAO.class);
        StudyDAO studyDAO = (StudyDAO)Mockito.mock(StudyDAO.class);
        AppointmentDAO appointmentDao = (AppointmentDAO)Mockito.mock(AppointmentDAO.class);
        StandaloneSubjectService subjectService = new StandaloneSubjectService(subjectDAO);
        StandaloneSubjectService subjectServiceSpy = (StandaloneSubjectService)Mockito.spy((Object)subjectService);
        SubjectDataMerger subjectDataMerger = new SubjectDataMerger(null, subjectDAO, studyDAO, appointmentDao, subjectServiceSpy);
        subjectDataMerger.decrypt = false;
        Subject primarySubject = new Subject();
        primarySubject.setId(Integer.valueOf(primarySubjectId));
        SubjectMrn primarySubjectMrn = new SubjectMrn();
        primarySubjectMrn.setMrn(primaryMrnString);
        primarySubjectMrn.setSubject(primarySubject);
        primarySubject.getSubjectMrnSet().add(primarySubjectMrn);
        ArrayList<Subject> primarySubjectAsaList = new ArrayList<Subject>();
        primarySubjectAsaList.add(primarySubject);
        Subject secondarySubject = new Subject();
        secondarySubject.setId(Integer.valueOf(secondarySubjectId));
        SubjectMrn secondarySubjectMrn = new SubjectMrn();
        secondarySubjectMrn.setMrn(secondaryMrnString);
        secondarySubjectMrn.setSubject(secondarySubject);
        secondarySubject.getSubjectMrnSet().add(secondarySubjectMrn);
        ArrayList<Subject> secondarySubjectAsaList = new ArrayList<Subject>();
        secondarySubjectAsaList.add(secondarySubject);
        Study studyWithOnlyPrimarySubject = new Study();
        studyWithOnlyPrimarySubject.setId(Integer.valueOf(studyWithOnlyPrimarySubjectId));
        studyWithOnlyPrimarySubject.setName("study with only primary subject");
        Study studyWithBothSubjects = new Study();
        studyWithBothSubjects.setId(Integer.valueOf(studyWithBothSubjectsId));
        studyWithBothSubjects.setName("study with both subjects");
        Study studyWithOnlySecondarySubject = new Study();
        studyWithOnlySecondarySubject.setId(Integer.valueOf(studyWithOnlySecondarySubjectId));
        studyWithOnlySecondarySubject.setName("study with only secondary subject");
        StudySubject studySubject1 = new StudySubject();
        studySubject1.setId(Integer.valueOf(studySubject1Id));
        studySubject1.setSubjectMrn(primarySubjectMrn);
        studySubject1.setStudy(studyWithOnlyPrimarySubject);
        StudySubject studySubject2 = new StudySubject();
        studySubject2.setId(Integer.valueOf(studySubject2Id));
        studySubject2.setSubjectMrn(primarySubjectMrn);
        studySubject2.setStudy(studyWithBothSubjects);
        StudySubject studySubject3 = new StudySubject();
        studySubject3.setId(Integer.valueOf(studySubject3Id));
        studySubject3.setSubjectMrn(secondarySubjectMrn);
        studySubject3.setStudy(studyWithBothSubjects);
        StudySubject studySubject4 = new StudySubject();
        studySubject4.setId(Integer.valueOf(studySubject4Id));
        studySubject4.setSubjectMrn(secondarySubjectMrn);
        studySubject4.setStudy(studyWithOnlySecondarySubject);
        ArrayList<StudySubject> primarySubjectStudies = new ArrayList<StudySubject>();
        primarySubjectStudies.add(studySubject1);
        primarySubjectStudies.add(studySubject2);
        ArrayList<StudySubject> secondarySubjectStudies = new ArrayList<StudySubject>();
        secondarySubjectStudies.add(studySubject3);
        secondarySubjectStudies.add(studySubject4);
        BookedVisit bookedVisitStudy2Subject1 = new BookedVisit();
        bookedVisitStudy2Subject1.setId(Integer.valueOf(bookedVisitStudy2Subject1Id));
        bookedVisitStudy2Subject1.setName("visit for subject " + primaryMrnString + " on study 2");
        bookedVisitStudy2Subject1.setSubjectMrn(primarySubjectMrn);
        bookedVisitStudy2Subject1.setStudy(studyWithBothSubjects);
        ArrayList<BookedVisit> bookedVisitsStudy2Subject1 = new ArrayList<BookedVisit>();
        bookedVisitsStudy2Subject1.add(bookedVisitStudy2Subject1);
        BookedVisit bookedVisitStudy2Subject2 = new BookedVisit();
        bookedVisitStudy2Subject2.setId(Integer.valueOf(bookedVisitStudy2Subject2Id));
        bookedVisitStudy2Subject2.setName("visit for subject " + secondaryMrnString + " on study 2");
        bookedVisitStudy2Subject2.setSubjectMrn(secondarySubjectMrn);
        bookedVisitStudy2Subject2.setStudy(studyWithBothSubjects);
        ArrayList<BookedVisit> bookedVisitsStudy2Subject2 = new ArrayList<BookedVisit>();
        bookedVisitsStudy2Subject2.add(bookedVisitStudy2Subject2);
        BookedVisit bookedVisitStudy3Subject2 = new BookedVisit();
        bookedVisitStudy3Subject2.setId(Integer.valueOf(bookedVisitStudy3Subject2Id));
        bookedVisitStudy3Subject2.setName("visit for subject " + secondaryMrnString + " on study 3");
        bookedVisitStudy3Subject2.setSubjectMrn(secondarySubjectMrn);
        bookedVisitStudy3Subject2.setStudy(studyWithOnlySecondarySubject);
        ArrayList<BookedVisit> bookedVisitsStudy3Subject2 = new ArrayList<BookedVisit>();
        bookedVisitsStudy3Subject2.add(bookedVisitStudy3Subject2);
        Mockito.when((Object)subjectDAO.findById(primarySubjectId)).thenReturn((Object)primarySubject);
        Mockito.when((Object)subjectDAO.findById(secondarySubjectId)).thenReturn((Object)secondarySubject);
        Mockito.when((Object)studyDAO.findStudySubjectBySubjectMrn(primarySubjectMrn)).thenReturn(primarySubjectStudies);
        Mockito.when((Object)studyDAO.findStudySubjectBySubjectMrn(secondarySubjectMrn)).thenReturn(secondarySubjectStudies);
        Mockito.when((Object)appointmentDao.getAllBookedVisitByStudyAndSubjectMrn(studyWithBothSubjects, primarySubjectMrn)).thenReturn(bookedVisitsStudy2Subject1);
        Mockito.when((Object)appointmentDao.getAllBookedVisitByStudyAndSubjectMrn(studyWithBothSubjects, secondarySubjectMrn)).thenReturn(bookedVisitsStudy2Subject2);
        Mockito.when((Object)appointmentDao.getAllBookedVisitByStudyAndSubjectMrn(studyWithOnlySecondarySubject, secondarySubjectMrn)).thenReturn(bookedVisitsStudy3Subject2);
        boolean rowNumber = true;
        subjectDataMerger.mergeSubject(secondarySubjectId, primarySubjectId, 1);
        ((SubjectDAO)Mockito.verify((Object)subjectDAO, (VerificationMode)Mockito.times((int)1))).findById(primarySubjectId);
        ((SubjectDAO)Mockito.verify((Object)subjectDAO, (VerificationMode)Mockito.times((int)1))).findById(secondarySubjectId);
        ((AppointmentDAO)Mockito.verify((Object)appointmentDao, (VerificationMode)Mockito.times((int)1))).updateEntity((BaseEntity)bookedVisitStudy2Subject2);
        ((AppointmentDAO)Mockito.verify((Object)appointmentDao, (VerificationMode)Mockito.times((int)1))).updateEntity((BaseEntity)bookedVisitStudy3Subject2);
        ((StudyDAO)Mockito.verify((Object)studyDAO, (VerificationMode)Mockito.times((int)1))).deleteEntity((BaseEntity)studySubject3);
        ((StudyDAO)Mockito.verify((Object)studyDAO, (VerificationMode)Mockito.times((int)1))).updateEntity((BaseEntity)studySubject4);
        ((SubjectDAO)Mockito.verify((Object)subjectDAO, (VerificationMode)Mockito.times((int)1))).updateEntity((BaseEntity)secondarySubject);
        String changeDetails = "subject with ID " + secondarySubjectId + " and MRN " + secondaryMrnString + " merged into subject with ID " + primarySubjectId + " and MRN " + primaryMrnString + ",BookedVisit#" + bookedVisitStudy2Subject2Id + ".subjectMrn:from#" + secondaryMrnString + ":to#" + primaryMrnString + "," + "StudySubject#" + studySubject3Id + ":DELETED," + "BookedVisit#" + bookedVisitStudy3Subject2Id + ".subjectMrn:from#" + secondaryMrnString + ":to#" + primaryMrnString + ",StudySubject#" + studySubject4Id + ".subject:from#" + secondarySubjectId + ":to#11";
        ((StandaloneSubjectService)Mockito.verify((Object)subjectServiceSpy, (VerificationMode)Mockito.times((int)1))).markArchivalStatus(secondarySubject, "Merged by subject data clean-up program (SubjectDataMerger)", changeDetails, ArchivalStatus.MERGED);
        ArgumentCaptor argument = ArgumentCaptor.forClass(ActivityLog.class);
        ((SubjectDAO)Mockito.verify((Object)subjectDAO)).createEntity((BaseEntity)argument.capture());
        ActivityLog activityLogEntry = (ActivityLog)argument.getValue();
        Assert.assertNull((Object)activityLogEntry.getPerformingUser());
        Assert.assertNull((Object)activityLogEntry.getIpAddress());
        Assert.assertNull((Object)activityLogEntry.getAffectedUser());
        Assert.assertNull((Object)activityLogEntry.getAffectedResource());
        Assert.assertNull((Object)activityLogEntry.getAffectedSublocation());
        Assert.assertNull((Object)activityLogEntry.getAffectedStudy());
        Assert.assertNull((Object)activityLogEntry.getAffectedVisit());
        Assert.assertNull((Object)activityLogEntry.getChangesDetailRequiredField());
        Assert.assertNull((Object)activityLogEntry.getAppointmentOverrideReason());
        Assert.assertNull((Object)activityLogEntry.getBookedVisit());
        Assert.assertNull((Object)activityLogEntry.getId());
        Assert.assertEquals((Object)"Merged by subject data clean-up program (SubjectDataMerger)", (Object)activityLogEntry.getActionPerformed());
        Assert.assertEquals((Object)secondarySubject, (Object)activityLogEntry.getAffectedSubject());
        Assert.assertEquals((Object)("subject with ID " + secondarySubjectId + " and MRN " + secondaryMrnString + " merged into " + "subject with ID " + primarySubjectId + " and MRN " + primaryMrnString + ",BookedVisit#" + bookedVisitStudy2Subject2Id + ".subjectMrn:from#" + secondaryMrnString + ":to#" + primaryMrnString + ",StudySubject#" + studySubject3Id + ":DELETED,BookedVisit#" + bookedVisitStudy3Subject2Id + ".subjectMrn:from#" + secondaryMrnString + ":to#" + primaryMrnString + ",StudySubject#" + studySubject4Id + ".subject:from#" + secondarySubjectId + ":to#" + primarySubjectId), (Object)activityLogEntry.getChangesDetail());
        ((StudyDAO)Mockito.verify((Object)studyDAO, (VerificationMode)Mockito.times((int)1))).deleteEntity((BaseEntity)studySubject3);
        Assert.assertEquals((Object)studySubject4.getSubjectMrn(), (Object)primarySubjectMrn);
        Assert.assertEquals((Object)studySubject1.getSubjectMrn(), (Object)primarySubjectMrn);
        Assert.assertEquals((Object)studySubject2.getSubjectMrn(), (Object)primarySubjectMrn);
        Assert.assertEquals((String)"Secondary subject should now be archived as MERGED", (Object)ArchivalStatus.MERGED, (Object)secondarySubject.getArchivalStatus());
        Assert.assertEquals((Object)bookedVisitStudy2Subject1.getStudy(), (Object)studyWithBothSubjects);
        Assert.assertEquals((Object)bookedVisitStudy2Subject1.getSubjectMrn(), (Object)primarySubjectMrn);
        Assert.assertEquals((Object)bookedVisitStudy2Subject2.getStudy(), (Object)studyWithBothSubjects);
        Assert.assertEquals((Object)bookedVisitStudy2Subject2.getSubjectMrn(), (Object)primarySubjectMrn);
        Assert.assertEquals((Object)bookedVisitStudy3Subject2.getStudy(), (Object)studyWithOnlySecondarySubject);
        Assert.assertEquals((Object)bookedVisitStudy3Subject2.getSubjectMrn(), (Object)primarySubjectMrn);
    }
}

