/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import edu.harvard.catalyst.scheduler.dto.response.GanttResourcesResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.GanttResponseDTO;
import edu.harvard.catalyst.scheduler.entity.TemplateResource;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class GanttResourcesGroupResponseDTO
extends GanttResponseDTO {
    private final List<GanttResourceGroup> ganttResourceGroupList;
    private final int totalVisitResources;
    private final int totalVisitCalendarDays;

    public GanttResourcesGroupResponseDTO(List<TemplateResource> allTemplateResourcesFromVisit, Predicate<? super TemplateResource> relevancePredicate) {
        List<TemplateResource> relevantTemplateResourcesFromVisit = this.getRelevantTemplateResources(allTemplateResourcesFromVisit, relevancePredicate);
        this.ganttResourceGroupList = Lists.newArrayList();
        if (relevantTemplateResourcesFromVisit.size() > 0) {
            boolean flexDesired = relevantTemplateResourcesFromVisit.get(0).getFlexible();
            this.partitionResourcesIntoResourceGroupList(relevantTemplateResourcesFromVisit, allTemplateResourcesFromVisit, flexDesired);
        }
        this.totalVisitResources = allTemplateResourcesFromVisit.size();
        this.totalVisitCalendarDays = TemplateResource.totalVisitCalendarDays(allTemplateResourcesFromVisit);
    }

    void partitionResourcesIntoResourceGroupList(List<TemplateResource> relevantTemplateResourcesFromVisit, List<TemplateResource> allTemplateResourcesFromVisit, boolean flexDesired) {
        HashMap<String, List<TemplateResource>> groupIdToGroupsTrList = new HashMap<String, List<TemplateResource>>();
        HashMap<String, List<TemplateResource>> groupIdToGroupsComboDisplayList = new HashMap<String, List<TemplateResource>>();
        LinkedHashSet groupIds = Sets.newLinkedHashSet();
        relevantTemplateResourcesFromVisit.stream().forEach(tr -> {
            String groupId = tr.getGroupId();
            groupIds.add(groupId);
            groupIdToGroupsTrList.put(groupId, Lists.newArrayList());
            groupIdToGroupsComboDisplayList.put(groupId, Lists.newArrayList());
        });
        this.addTrToMaps(groupIdToGroupsTrList, groupIdToGroupsComboDisplayList, groupIds, flexDesired ? allTemplateResourcesFromVisit : relevantTemplateResourcesFromVisit);
        for (String groupId : groupIds) {
            List groupsTrResourceColumnList = (List)groupIdToGroupsTrList.get(groupId);
            List groupsTrDisplayList = (List)groupIdToGroupsComboDisplayList.get(groupId);
            List<GanttResourcesResponseDTO.GanttResourceDetail> detailList = groupsTrResourceColumnList.stream().map(tr -> new GanttResourcesResponseDTO.GanttResourceDetail((TemplateResource)tr)).collect(Collectors.toList());
            this.ganttResourceGroupList.add(new GanttResourceGroup(groupId, detailList, groupsTrDisplayList));
        }
    }

    void addTrToMaps(Map<String, List<TemplateResource>> groupIdToGroupsTrList, Map<String, List<TemplateResource>> groupIdToGroupsComboDisplayList, Set<String> groupIds, List<TemplateResource> trList) {
        for (TemplateResource tr : trList) {
            String groupId = tr.getGroupId();
            if (!groupIds.contains(groupId)) continue;
            this.addToTrGroupsTrList(tr, groupIdToGroupsTrList);
            this.addTrToComboDisplayList(groupId, tr, groupIdToGroupsComboDisplayList);
        }
    }

    void addTrToComboDisplayList(String groupId, TemplateResource tr, Map<String, List<TemplateResource>> groupIdToGroupsComboDisplayList) {
        List<TemplateResource> comboDisplayList = groupIdToGroupsComboDisplayList.get(groupId);
        comboDisplayList.add(tr);
    }

    void addToTrGroupsTrList(TemplateResource tr, Map<String, List<TemplateResource>> groupIdToGroupsTrList) {
        String groupId = tr.getGroupId();
        List<TemplateResource> groupTrList = groupIdToGroupsTrList.get(groupId);
        groupTrList.add(tr);
    }

    @Override
    public String jsonify(Gson gson) {
        return gson.toJson((Object)this);
    }

    public static final class GanttResourceGroup {
        private final List<GanttResourcesResponseDTO.GanttResourceDetail> children;
        private final String groupId;
        private final String groupComboDisplay;

        GanttResourceGroup(String groupId, List<GanttResourcesResponseDTO.GanttResourceDetail> children, List<TemplateResource> trListForComboDisplay) {
            this.children = children;
            this.groupId = groupId;
            List displayList = trListForComboDisplay.stream().map(tr -> this.trToDisplayString((TemplateResource)tr)).collect(Collectors.toList());
            this.groupComboDisplay = Joiner.on((String)";").join(displayList);
        }

        String trToDisplayString(TemplateResource tr) {
            int startDayNumber = DateUtility.dateToDayNumber(tr.getStartDate());
            int endDayNumber = DateUtility.dateToDayNumber(tr.getEndDate());
            LocalDateTime startLdt = DateUtility.dateToLocalDateTime(tr.getStartDate());
            LocalDateTime endLdt = DateUtility.dateToLocalDateTime(tr.getEndDate());
            String result = tr.getResource().getName() + ", " + tr.getResource().getResourceType().getName() + " (Day " + startDayNumber + " " + DateUtility.padTime(startLdt.getHour()) + ":" + DateUtility.padTime(startLdt.getMinute()) + " - Day " + endDayNumber + " " + DateUtility.padTime(endLdt.getHour()) + ":" + DateUtility.padTime(endLdt.getMinute()) + ")";
            return result;
        }
    }
}

