/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.subjectDataCleaner;

import edu.harvard.catalyst.scheduler.entity.ActivityLog;
import edu.harvard.catalyst.scheduler.entity.ArchivalStatus;
import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.persistence.SubjectDAO;
import edu.harvard.catalyst.scheduler.service.StandaloneSubjectService;
import edu.harvard.catalyst.scheduler.subjectDataCleaner.SubjectDataDeleter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class SubjectDataDeleterTest {
    @Test
    public void testDeleteSubject() {
        int subjectId = 1;
        String subjectMrn = "0001";
        SubjectDAO subjectDAO = (SubjectDAO)Mockito.mock(SubjectDAO.class);
        StandaloneSubjectService subjectService = new StandaloneSubjectService(subjectDAO);
        StandaloneSubjectService subjectServiceSpy = (StandaloneSubjectService)Mockito.spy((Object)subjectService);
        SubjectDataDeleter subjectDataDeleter = new SubjectDataDeleter(null, subjectDAO, subjectServiceSpy);
        subjectDataDeleter.decrypt = false;
        Subject subject1 = new Subject();
        subject1.setId(Integer.valueOf(subjectId));
        SubjectMrn mrn1 = new SubjectMrn();
        mrn1.setMrn(subjectMrn);
        subject1.getSubjectMrnSet().add(mrn1);
        Mockito.when((Object)((Subject)subjectDAO.findById(Subject.class, Integer.valueOf(subjectId)))).thenReturn((Object)subject1);
        subjectDataDeleter.deleteSubject(subjectId, 1);
        ((SubjectDAO)Mockito.verify((Object)subjectDAO, (VerificationMode)Mockito.times((int)1))).updateEntity((BaseEntity)subject1);
        String changeDetails = "Subject ID: " + subjectId + " (MRN: " + subjectMrn + ") archived (DELETED)";
        ((StandaloneSubjectService)Mockito.verify((Object)subjectServiceSpy, (VerificationMode)Mockito.times((int)1))).markArchivalStatus(subject1, "Deleted by subject data clean-up program (SubjectDataDeleter)", "Subject ID: " + subjectId + " (MRN: " + subjectMrn + ") archived (DELETED)", ArchivalStatus.DELETED);
        ArgumentCaptor argument = ArgumentCaptor.forClass(ActivityLog.class);
        ((SubjectDAO)Mockito.verify((Object)subjectDAO)).createEntity((BaseEntity)argument.capture());
        ActivityLog activityLogEntry = (ActivityLog)argument.getValue();
        Assert.assertNull((Object)activityLogEntry.getPerformingUser());
        Assert.assertNull((Object)activityLogEntry.getIpAddress());
        Assert.assertNull((Object)activityLogEntry.getAffectedUser());
        Assert.assertNull((Object)activityLogEntry.getAffectedResource());
        Assert.assertNull((Object)activityLogEntry.getAffectedSublocation());
        Assert.assertNull((Object)activityLogEntry.getAffectedStudy());
        Assert.assertNull((Object)activityLogEntry.getAffectedVisit());
        Assert.assertNull((Object)activityLogEntry.getChangesDetailRequiredField());
        Assert.assertNull((Object)activityLogEntry.getAppointmentOverrideReason());
        Assert.assertNull((Object)activityLogEntry.getBookedVisit());
        Assert.assertNull((Object)activityLogEntry.getId());
        Assert.assertEquals((Object)"Deleted by subject data clean-up program (SubjectDataDeleter)", (Object)activityLogEntry.getActionPerformed());
        Assert.assertEquals((Object)subject1, (Object)activityLogEntry.getAffectedSubject());
        Assert.assertEquals((Object)changeDetails, (Object)activityLogEntry.getChangesDetail());
        Assert.assertEquals((Object)ArchivalStatus.DELETED, (Object)subject1.getArchivalStatus());
    }
}

