/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.util;

import edu.harvard.catalyst.scheduler.util.PropertyHelper;

public class SchedulingRestriction {
    private static final SchedulingRestriction instance = new SchedulingRestriction();
    private final String schedulingRestriction = PropertyHelper.getProperties("scheduler.properties", this.getClass()).getProperty("schedulingRestriction");
    private final String lastMinuteIndicator = PropertyHelper.getProperties("scheduler.properties", this.getClass()).getProperty("lastMinuteIndicator");

    private SchedulingRestriction() {
    }

    public static SchedulingRestriction getInstance() {
        return instance;
    }

    public int getSchedulingRestriction() {
        return this.getRestriction(this.schedulingRestriction);
    }

    public int getLastMinuteIndicator() {
        return this.getRestriction(this.lastMinuteIndicator);
    }

    private int getRestriction(String restriction) {
        int restrictionInt;
        if (restriction == null) {
            return 0;
        }
        try {
            restrictionInt = Integer.parseInt(restriction);
        }
        catch (NumberFormatException e) {
            double restrictionDouble;
            try {
                restrictionDouble = Double.parseDouble(restriction);
            }
            catch (NumberFormatException n) {
                return 0;
            }
            restrictionInt = (int)restrictionDouble;
        }
        if (restrictionInt < 1) {
            return 0;
        }
        if (restrictionInt > 99) {
            return 99;
        }
        return restrictionInt;
    }
}

